/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.join;

import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.join.CompositeRecordReader;
import org.apache.hadoop.mapreduce.lib.join.ResetableIterator;
import org.apache.hadoop.mapreduce.lib.join.TupleWritable;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class MultiFilterRecordReader<K extends WritableComparable<?>, V extends Writable>
extends CompositeRecordReader<K, V, V> {
    private TupleWritable ivalue = null;

    public MultiFilterRecordReader(int id, Configuration conf, int capacity, Class<? extends WritableComparator> cmpcl) throws IOException {
        super(id, capacity, cmpcl);
        this.setConf(conf);
    }

    protected abstract V emit(TupleWritable var1) throws IOException;

    @Override
    protected boolean combine(Object[] srcs, TupleWritable dst) {
        return true;
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.key == null) {
            this.key = this.createKey();
        }
        if (this.value == null) {
            this.value = this.createValue();
        }
        if (this.jc.flush(this.ivalue)) {
            ReflectionUtils.copy(this.conf, this.jc.key(), this.key);
            ReflectionUtils.copy(this.conf, this.emit(this.ivalue), this.value);
            return true;
        }
        if (this.ivalue == null) {
            this.ivalue = this.createTupleWritable();
        }
        this.jc.clear();
        PriorityQueue q = this.getRecordReaderQueue();
        Object iterkey = this.createKey();
        while (q != null && !q.isEmpty()) {
            this.fillJoinCollector(iterkey);
            this.jc.reset(iterkey);
            if (this.jc.flush(this.ivalue)) {
                ReflectionUtils.copy(this.conf, this.jc.key(), this.key);
                ReflectionUtils.copy(this.conf, this.emit(this.ivalue), this.value);
                return true;
            }
            this.jc.clear();
        }
        return false;
    }

    @Override
    public void initialize(InputSplit split2, TaskAttemptContext context) throws IOException, InterruptedException {
        super.initialize(split2, context);
    }

    @Override
    protected ResetableIterator<V> getDelegate() {
        return new MultiFilterDelegationIterator();
    }

    protected class MultiFilterDelegationIterator
    implements ResetableIterator<V> {
        protected MultiFilterDelegationIterator() {
        }

        @Override
        public boolean hasNext() {
            return MultiFilterRecordReader.this.jc.hasNext();
        }

        @Override
        public boolean next(V val) throws IOException {
            boolean ret = MultiFilterRecordReader.this.jc.flush(MultiFilterRecordReader.this.ivalue);
            if (ret) {
                ReflectionUtils.copy(MultiFilterRecordReader.this.getConf(), MultiFilterRecordReader.this.emit(MultiFilterRecordReader.this.ivalue), val);
            }
            return ret;
        }

        @Override
        public boolean replay(V val) throws IOException {
            ReflectionUtils.copy(MultiFilterRecordReader.this.getConf(), MultiFilterRecordReader.this.emit(MultiFilterRecordReader.this.ivalue), val);
            return true;
        }

        @Override
        public void reset() {
            MultiFilterRecordReader.this.jc.reset(MultiFilterRecordReader.this.jc.key());
        }

        @Override
        public void add(V item) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            MultiFilterRecordReader.this.jc.close();
        }

        @Override
        public void clear() {
            MultiFilterRecordReader.this.jc.clear();
        }
    }
}

