/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.ApplicationClassLoader;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MRApps
extends Apps {
    public static final Log LOG = LogFactory.getLog(MRApps.class);
    private static final String STAGING_CONSTANT = ".staging";

    public static String toString(JobId jid) {
        return jid.toString();
    }

    public static JobId toJobID(String jid) {
        return TypeConverter.toYarn(JobID.forName(jid));
    }

    public static String toString(TaskId tid) {
        return tid.toString();
    }

    public static TaskId toTaskID(String tid) {
        return TypeConverter.toYarn(TaskID.forName(tid));
    }

    public static String toString(TaskAttemptId taid) {
        return taid.toString();
    }

    public static TaskAttemptId toTaskAttemptID(String taid) {
        return TypeConverter.toYarn(TaskAttemptID.forName(taid));
    }

    public static String taskSymbol(TaskType type) {
        switch (type) {
            case MAP: {
                return "m";
            }
            case REDUCE: {
                return "r";
            }
        }
        throw new YarnRuntimeException("Unknown task type: " + type.toString());
    }

    public static TaskType taskType(String symbol) {
        if (symbol.equals("m")) {
            return TaskType.MAP;
        }
        if (symbol.equals("r")) {
            return TaskType.REDUCE;
        }
        throw new YarnRuntimeException("Unknown task symbol: " + symbol);
    }

    public static TaskAttemptStateUI taskAttemptState(String attemptStateStr) {
        return TaskAttemptStateUI.valueOf(attemptStateStr);
    }

    private static void setMRFrameworkClasspath(Map<String, String> environment, Configuration conf) throws IOException {
        if (conf.getBoolean("yarn.is.minicluster", false)) {
            Apps.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), System.getProperty("java.class.path"));
        }
        for (String c : conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
            Apps.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), c.trim());
        }
        for (String c : conf.getStrings("mapreduce.application.classpath", StringUtils.getStrings(MRJobConfig.DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH))) {
            Apps.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), c.trim());
        }
    }

    public static void setClasspath(Map<String, String> environment, Configuration conf) throws IOException {
        boolean userClassesTakesPrecedence = conf.getBoolean("mapreduce.job.user.classpath.first", false);
        String classpathEnvVar = conf.getBoolean("mapreduce.job.classloader", false) ? ApplicationConstants.Environment.APP_CLASSPATH.name() : ApplicationConstants.Environment.CLASSPATH.name();
        Apps.addToEnvironment(environment, classpathEnvVar, ApplicationConstants.Environment.PWD.$());
        if (!userClassesTakesPrecedence) {
            MRApps.setMRFrameworkClasspath(environment, conf);
        }
        Apps.addToEnvironment(environment, classpathEnvVar, "job.jar/job.jar");
        Apps.addToEnvironment(environment, classpathEnvVar, "job.jar/classes/");
        Apps.addToEnvironment(environment, classpathEnvVar, "job.jar/lib/*");
        Apps.addToEnvironment(environment, classpathEnvVar, ApplicationConstants.Environment.PWD.$() + "/" + "*");
        MRApps.addToClasspathIfNotJar(DistributedCache.getFileClassPaths(conf), DistributedCache.getCacheFiles(conf), conf, environment, classpathEnvVar);
        MRApps.addToClasspathIfNotJar(DistributedCache.getArchiveClassPaths(conf), DistributedCache.getCacheArchives(conf), conf, environment, classpathEnvVar);
        if (userClassesTakesPrecedence) {
            MRApps.setMRFrameworkClasspath(environment, conf);
        }
    }

    private static void addToClasspathIfNotJar(Path[] paths, URI[] withLinks, Configuration conf, Map<String, String> environment, String classpathEnvVar) throws IOException {
        if (paths != null) {
            HashMap<Path, String> linkLookup = new HashMap<Path, String>();
            if (withLinks != null) {
                for (Comparable<URI> comparable : withLinks) {
                    String name;
                    Path p = new Path((URI)comparable);
                    FileSystem remoteFS = p.getFileSystem(conf);
                    p = remoteFS.resolvePath(p.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                    String string2 = name = null == ((URI)comparable).getFragment() ? p.getName() : ((URI)comparable).getFragment();
                    if (name.toLowerCase().endsWith(".jar")) continue;
                    linkLookup.put(p, name);
                }
            }
            for (Comparable<URI> comparable : paths) {
                FileSystem remoteFS = ((Path)comparable).getFileSystem(conf);
                Path path = remoteFS.resolvePath(((Path)comparable).makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                String name = (String)linkLookup.get(path);
                if (name == null) {
                    name = path.getName();
                }
                if (name.toLowerCase().endsWith(".jar")) continue;
                Apps.addToEnvironment(environment, classpathEnvVar, ApplicationConstants.Environment.PWD.$() + "/" + name);
            }
        }
    }

    public static void setJobClassLoader(Configuration conf) throws IOException {
        if (conf.getBoolean("mapreduce.job.classloader", false)) {
            String appClasspath = System.getenv(ApplicationConstants.Environment.APP_CLASSPATH.key());
            if (appClasspath == null) {
                LOG.warn((Object)"Not using job classloader since APP_CLASSPATH is not set.");
            } else {
                String[] systemClasses;
                ClassLoader jobClassLoader;
                LOG.info((Object)"Using job classloader");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("APP_CLASSPATH=" + appClasspath));
                }
                if ((jobClassLoader = MRApps.createJobClassLoader(appClasspath, systemClasses = conf.getStrings("mapreduce.job.classloader.system.classes"))) != null) {
                    conf.setClassLoader(jobClassLoader);
                    Thread.currentThread().setContextClassLoader(jobClassLoader);
                }
            }
        }
    }

    private static ClassLoader createJobClassLoader(final String appClasspath, final String[] systemClasses) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws MalformedURLException {
                    return new ApplicationClassLoader(appClasspath, MRApps.class.getClassLoader(), Arrays.asList(systemClasses));
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof MalformedURLException) {
                throw (MalformedURLException)t;
            }
            throw new IOException(e);
        }
    }

    public static Path getStagingAreaDir(Configuration conf, String user) {
        return new Path(conf.get("yarn.app.mapreduce.am.staging-dir", "/tmp/hadoop-yarn/staging") + "/" + user + "/" + STAGING_CONSTANT);
    }

    public static String getJobFile(Configuration conf, String user, JobID jobId) {
        Path jobFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "job.xml");
        return jobFile.toString();
    }

    public static Path getEndJobCommitSuccessFile(Configuration conf, String user, JobId jobId) {
        Path endCommitFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "COMMIT_SUCCESS");
        return endCommitFile;
    }

    public static Path getEndJobCommitFailureFile(Configuration conf, String user, JobId jobId) {
        Path endCommitFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "COMMIT_FAIL");
        return endCommitFile;
    }

    public static Path getStartJobCommitFile(Configuration conf, String user, JobId jobId) {
        Path startCommitFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "COMMIT_STARTED");
        return startCommitFile;
    }

    public static void setupDistributedCache(Configuration conf, Map<String, LocalResource> localResources) throws IOException {
        MRApps.parseDistributedCacheArtifacts(conf, localResources, LocalResourceType.ARCHIVE, DistributedCache.getCacheArchives(conf), DistributedCache.getArchiveTimestamps(conf), MRApps.getFileSizes(conf, "mapreduce.job.cache.archives.filesizes"), DistributedCache.getArchiveVisibilities(conf));
        MRApps.parseDistributedCacheArtifacts(conf, localResources, LocalResourceType.FILE, DistributedCache.getCacheFiles(conf), DistributedCache.getFileTimestamps(conf), MRApps.getFileSizes(conf, "mapreduce.job.cache.files.filesizes"), DistributedCache.getFileVisibilities(conf));
    }

    private static String getResourceDescription(LocalResourceType type) {
        if (type == LocalResourceType.ARCHIVE || type == LocalResourceType.PATTERN) {
            return "cache archive (mapreduce.job.cache.archives) ";
        }
        return "cache file (mapreduce.job.cache.files) ";
    }

    private static String toString(URL url) {
        StringBuffer b = new StringBuffer();
        b.append(url.getScheme()).append("://").append(url.getHost());
        if (url.getPort() >= 0) {
            b.append(":").append(url.getPort());
        }
        b.append(url.getFile());
        return b.toString();
    }

    private static void parseDistributedCacheArtifacts(Configuration conf, Map<String, LocalResource> localResources, LocalResourceType type, URI[] uris, long[] timestamps, long[] sizes, boolean[] visibilities) throws IOException {
        if (uris != null) {
            if (uris.length != timestamps.length || uris.length != sizes.length || uris.length != visibilities.length) {
                throw new IllegalArgumentException("Invalid specification for distributed-cache artifacts of type " + (Object)((Object)type) + " :" + " #uris=" + uris.length + " #timestamps=" + timestamps.length + " #visibilities=" + visibilities.length);
            }
            for (int i = 0; i < uris.length; ++i) {
                URI u = uris[i];
                Path p = new Path(u);
                FileSystem remoteFS = p.getFileSystem(conf);
                p = remoteFS.resolvePath(p.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                if (name.isAbsolute()) {
                    throw new IllegalArgumentException("Resource name must be relative");
                }
                String linkName = name.toUri().getPath();
                LocalResource orig = localResources.get(linkName);
                URL url = ConverterUtils.getYarnUrlFromURI(p.toUri());
                if (orig != null && !orig.getResource().equals(url)) {
                    LOG.warn((Object)(MRApps.getResourceDescription(orig.getType()) + MRApps.toString(orig.getResource()) + " conflicts with " + MRApps.getResourceDescription(type) + MRApps.toString(url) + " This will be an error in Hadoop 2.0"));
                    continue;
                }
                localResources.put(linkName, LocalResource.newInstance(ConverterUtils.getYarnUrlFromURI(p.toUri()), type, visibilities[i] ? LocalResourceVisibility.PUBLIC : LocalResourceVisibility.PRIVATE, sizes[i], timestamps[i]));
            }
        }
    }

    private static long[] getFileSizes(Configuration conf, String key) {
        String[] strs = conf.getStrings(key);
        if (strs == null) {
            return null;
        }
        long[] result2 = new long[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result2[i] = Long.parseLong(strs[i]);
        }
        return result2;
    }

    public static void addLog4jSystemProperties(String logLevel, long logSize, List<String> vargs) {
        vargs.add("-Dlog4j.configuration=container-log4j.properties");
        vargs.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        vargs.add("-Dyarn.app.container.log.filesize=" + logSize);
        vargs.add("-Dhadoop.root.logger=" + logLevel + ",CLA");
    }

    public static enum TaskAttemptStateUI {
        NEW(new TaskAttemptState[]{TaskAttemptState.NEW, TaskAttemptState.STARTING}),
        RUNNING(new TaskAttemptState[]{TaskAttemptState.RUNNING, TaskAttemptState.COMMIT_PENDING}),
        SUCCESSFUL(new TaskAttemptState[]{TaskAttemptState.SUCCEEDED}),
        FAILED(new TaskAttemptState[]{TaskAttemptState.FAILED}),
        KILLED(new TaskAttemptState[]{TaskAttemptState.KILLED});

        private final List<TaskAttemptState> correspondingStates;

        private TaskAttemptStateUI(TaskAttemptState[] correspondingStates) {
            this.correspondingStates = Arrays.asList(correspondingStates);
        }

        public boolean correspondsTo(TaskAttemptState state) {
            return this.correspondingStates.contains((Object)state);
        }
    }
}

