/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.spark-project.guava.annotations.VisibleForTesting;
import org.spark-project.guava.base.Splitter;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationClassLoader
extends URLClassLoader {
    private static final Log LOG = LogFactory.getLog((String)ApplicationClassLoader.class.getName());
    private static final FilenameFilter JAR_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar") || name.endsWith(".JAR");
        }
    };
    private ClassLoader parent;
    private List<String> systemClasses;

    public ApplicationClassLoader(URL[] urls, ClassLoader parent, List<String> systemClasses) {
        super(urls, parent);
        this.parent = parent;
        if (parent == null) {
            throw new IllegalArgumentException("No parent classloader!");
        }
        this.systemClasses = systemClasses;
    }

    public ApplicationClassLoader(String classpath, ClassLoader parent, List<String> systemClasses) throws MalformedURLException {
        this(ApplicationClassLoader.constructUrlsFromClasspath(classpath), parent, systemClasses);
    }

    @VisibleForTesting
    static URL[] constructUrlsFromClasspath(String classpath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String element : Splitter.on((String)File.pathSeparator).split((CharSequence)classpath)) {
            if (element.endsWith("/*")) {
                String dir = element.substring(0, element.length() - 1);
                File[] files = new File(dir).listFiles(JAR_FILENAME_FILTER);
                if (files == null) continue;
                for (File file : files) {
                    urls.add(file.toURI().toURL());
                }
                continue;
            }
            File file = new File(element);
            if (!file.exists()) continue;
            urls.add(new File(element).toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (!ApplicationClassLoader.isSystemClass(name, this.systemClasses) && (url = this.findResource(name)) == null && name.startsWith("/")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Remove leading / off " + name));
            }
            url = this.findResource(name.substring(1));
        }
        if (url == null) {
            url = this.parent.getResource(name);
        }
        if (url != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("getResource(" + name + ")=" + url));
        }
        return url;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loading class: " + name));
        }
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        if (c == null && !ApplicationClassLoader.isSystemClass(name, this.systemClasses)) {
            try {
                c = this.findClass(name);
                if (LOG.isDebugEnabled() && c != null) {
                    LOG.debug((Object)("Loaded class: " + name + " "));
                }
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)e);
                }
                ex = e;
            }
        }
        if (c == null) {
            c = this.parent.loadClass(name);
            if (LOG.isDebugEnabled() && c != null) {
                LOG.debug((Object)("Loaded class from parent: " + name + " "));
            }
        }
        if (c == null) {
            throw ex != null ? ex : new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @VisibleForTesting
    static boolean isSystemClass(String name, List<String> systemClasses) {
        if (systemClasses != null) {
            String canonicalName = name.replace('/', '.');
            while (canonicalName.startsWith(".")) {
                canonicalName = canonicalName.substring(1);
            }
            for (String c : systemClasses) {
                boolean result2 = true;
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result2 = false;
                }
                if (c.endsWith(".") && canonicalName.startsWith(c)) {
                    return result2;
                }
                if (!canonicalName.equals(c)) continue;
                return result2;
            }
        }
        return false;
    }
}

