/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.LazyCookieState;

public class LazyCookie
extends Cookie {
    private final LazyCookieState lazyState = new LazyCookieState();
    private boolean isInitialized;

    @Override
    public String getName() {
        this.checkInitialized();
        return super.getName();
    }

    @Override
    public String getValue() {
        this.checkInitialized();
        return super.getValue();
    }

    @Override
    public int getVersion() {
        this.checkInitialized();
        return super.getVersion();
    }

    @Override
    public String getComment() {
        this.checkInitialized();
        return super.getComment();
    }

    @Override
    public String getDomain() {
        this.checkInitialized();
        return super.getDomain();
    }

    @Override
    public int getMaxAge() {
        this.checkInitialized();
        return super.getMaxAge();
    }

    @Override
    public String getPath() {
        this.checkInitialized();
        return super.getPath();
    }

    @Override
    public boolean isSecure() {
        this.checkInitialized();
        return super.isSecure();
    }

    protected final void checkInitialized() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.initialize();
        }
    }

    protected void initialize() {
        String strName = this.lazyState.getName().toString();
        LazyCookie.checkName(strName);
        this.name = strName;
        this.value = this.unescape(this.lazyState.getValue().toString());
        this.path = this.unescape(this.lazyState.getPath().toString());
        String domainStr = this.lazyState.getDomain().toString();
        if (domainStr != null) {
            this.domain = this.unescape(domainStr);
        }
        String commentStr = this.lazyState.getComment().toString();
        this.comment = this.version == 1 ? this.unescape(commentStr) : null;
    }

    public LazyCookieState lazy() {
        return this.lazyState;
    }

    @Override
    protected boolean lazyNameEquals(String name) {
        return this.lazyState.getName().equals(name);
    }

    public void recycle() {
        this.isInitialized = false;
        this.lazyState.recycle();
    }

    protected String unescape(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.indexOf(92) == -1) {
            return s2;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c != '\\') {
                buf.append(c);
                continue;
            }
            if (++i >= s2.length()) {
                throw new IllegalArgumentException();
            }
            c = s2.charAt(i);
            buf.append(c);
        }
        return buf.toString();
    }
}

