/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractTransformer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.AbstractCodecFilter;
import org.glassfish.grizzly.memory.Buffers;

public class ChunkingFilter
extends AbstractCodecFilter<Buffer, Buffer> {
    private static final Logger LOGGER = Grizzly.logger(ChunkingFilter.class);
    private final int chunkSize;

    public ChunkingFilter(int chunkSize) {
        super(new ChunkingDecoder(chunkSize), new ChunkingEncoder(chunkSize));
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public static abstract class ChunkingTransformer
    extends AbstractTransformer<Buffer, Buffer> {
        private final int chunk;

        public ChunkingTransformer(int chunk) {
            this.chunk = chunk;
        }

        @Override
        public String getName() {
            return "ChunkingTransformer";
        }

        @Override
        protected TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage storage, Buffer input2) throws TransformationException {
            if (!input2.hasRemaining()) {
                return TransformationResult.createIncompletedResult(input2);
            }
            int chunkSize = Math.min(this.chunk, input2.remaining());
            int oldInputPos = input2.position();
            int oldInputLimit = input2.limit();
            Buffers.setPositionLimit(input2, oldInputPos, oldInputPos + chunkSize);
            Object output = this.obtainMemoryManager(storage).allocate(chunkSize);
            output.put(input2).flip();
            Buffers.setPositionLimit(input2, oldInputPos + chunkSize, oldInputLimit);
            return TransformationResult.createCompletedResult(output, input2);
        }

        @Override
        public boolean hasInputRemaining(AttributeStorage storage, Buffer input2) {
            return input2 != null && input2.hasRemaining();
        }
    }

    public static final class ChunkingEncoder
    extends ChunkingTransformer {
        public ChunkingEncoder(int chunk) {
            super(chunk);
        }
    }

    public static final class ChunkingDecoder
    extends ChunkingTransformer {
        public ChunkingDecoder(int chunk) {
            super(chunk);
        }
    }
}

