/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.UnrecoverableIOException;

public class RepeatableInputStream
extends InputStream
implements InputStreamWrapper {
    private static final Log log = LogFactory.getLog((Class)RepeatableInputStream.class);
    private InputStream is = null;
    private int bufferSize = 0;
    private int bufferOffset = 0;
    private long bytesReadPastMark = 0L;
    private byte[] buffer = null;

    public RepeatableInputStream(InputStream inputStream, int bufferSize) {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.is = inputStream;
        this.bufferSize = bufferSize;
        this.buffer = new byte[this.bufferSize];
        if (log.isDebugEnabled()) {
            log.debug((Object)("Underlying input stream will be repeatable up to " + this.buffer.length + " bytes"));
        }
    }

    public void reset() throws IOException {
        if (this.bytesReadPastMark <= (long)this.bufferSize) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reset after reading " + this.bytesReadPastMark + " bytes."));
            }
        } else {
            throw new UnrecoverableIOException("Input stream cannot be reset as " + this.bytesReadPastMark + " bytes have been written, exceeding the available buffer size of " + this.bufferSize);
        }
        this.bufferOffset = 0;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int readlimit) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input stream marked at " + this.bytesReadPastMark + " bytes"));
        }
        if (this.bytesReadPastMark <= (long)this.bufferSize && this.buffer != null) {
            byte[] newBuffer = new byte[this.bufferSize];
            System.arraycopy(this.buffer, this.bufferOffset, newBuffer, 0, (int)(this.bytesReadPastMark - (long)this.bufferOffset));
            this.buffer = newBuffer;
            this.bytesReadPastMark -= (long)this.bufferOffset;
            this.bufferOffset = 0;
        } else {
            this.bufferOffset = 0;
            this.bytesReadPastMark = 0L;
            this.buffer = new byte[this.bufferSize];
        }
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.is.close();
    }

    public int read(byte[] out, int outOffset, int outLength) throws IOException {
        byte[] tmp = new byte[outLength];
        if ((long)this.bufferOffset < this.bytesReadPastMark && this.buffer != null) {
            int bytesFromBuffer = tmp.length;
            if ((long)(this.bufferOffset + bytesFromBuffer) > this.bytesReadPastMark) {
                bytesFromBuffer = (int)this.bytesReadPastMark - this.bufferOffset;
            }
            System.arraycopy(this.buffer, this.bufferOffset, out, outOffset, bytesFromBuffer);
            this.bufferOffset += bytesFromBuffer;
            return bytesFromBuffer;
        }
        int count2 = this.is.read(tmp);
        if (count2 <= 0) {
            return count2;
        }
        if (this.bytesReadPastMark + (long)count2 <= (long)this.bufferSize) {
            System.arraycopy(tmp, 0, this.buffer, (int)this.bytesReadPastMark, count2);
            this.bufferOffset += count2;
        } else if (this.buffer != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Buffer size " + this.bufferSize + " has been exceeded and the input stream " + "will not be repeatable until the next mark. Freeing buffer memory"));
            }
            this.buffer = null;
        }
        System.arraycopy(tmp, 0, out, outOffset, count2);
        this.bytesReadPastMark += (long)count2;
        return count2;
    }

    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int count2 = this.read(tmp);
        if (count2 != -1) {
            return tmp[0];
        }
        return count2;
    }

    public InputStream getWrappedInputStream() {
        return this.is;
    }
}

