/*
 * Decompiled with CFR 0.152.
 */
package org.znerd.xmlenc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.znerd.xmlenc.InvalidXMLException;
import org.znerd.xmlenc.XMLChecker;

public class XMLEncoder {
    private static final char[] DECLARATION_START = "<?xml version=\"1.0\" encoding=\"".toCharArray();
    private static final int DECLARATION_START_LENGTH = DECLARATION_START.length;
    private static final char[] DECLARATION_END = "\"?>".toCharArray();
    private static final int DECLARATION_END_LENGTH = DECLARATION_END.length;
    private static final char[] ESC_GREATER_THAN = new char[]{'&', 'g', 't', ';'};
    private static final char[] ESC_LESS_THAN = new char[]{'&', 'l', 't', ';'};
    private static final char[] ESC_AMPERSAND = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] ESC_APOSTROPHE = new char[]{'&', 'a', 'p', 'o', 's', ';'};
    private static final char[] ESC_QUOTE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private static final char[] AMPERSAND_HASH = new char[]{'&', '#'};
    private static final char[] EQUALS_APOSTROPHE = new char[]{'=', '\''};
    private static final char[] EQUALS_QUOTE = new char[]{'=', '\"'};
    private final String _encoding;
    private final char[] _encodingCharArray;
    private final boolean _sevenBitEncoding;

    public static final XMLEncoder getEncoder(String string2) throws IllegalArgumentException, UnsupportedEncodingException {
        return new XMLEncoder(string2);
    }

    public XMLEncoder(String string2) throws IllegalArgumentException, UnsupportedEncodingException {
        if (string2 == null) {
            throw new IllegalArgumentException("encoding == null");
        }
        String string3 = string2.toUpperCase();
        if (string3.equals("UTF-8") || string3.equals("UTF-16")) {
            this._sevenBitEncoding = false;
        } else if (string3.equals("US-ASCII") || string3.equals("ASCII") || string3.startsWith("ISO-8859-")) {
            this._sevenBitEncoding = true;
        } else {
            throw new UnsupportedEncodingException(string2);
        }
        this._encoding = string2;
        this._encodingCharArray = string2.toCharArray();
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void declaration(Writer writer) throws NullPointerException, IOException {
        writer.write(DECLARATION_START, 0, DECLARATION_START_LENGTH);
        writer.write(this._encodingCharArray);
        writer.write(DECLARATION_END, 0, DECLARATION_END_LENGTH);
    }

    public void text(Writer writer, String string2, boolean bl) throws NullPointerException, InvalidXMLException, IOException {
        this.text(writer, string2.toCharArray(), 0, string2.length(), bl);
    }

    public void text(Writer writer, char[] cArray, int n, int n2, boolean bl) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        int n3 = n + n2;
        int n4 = n;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (c >= '?' && c <= '\u007f' || c >= '\'' && c <= ';' || c >= ' ' && c <= '%' || c == '&' && !bl || c > '\u007f' && !this._sevenBitEncoding || c == '\n' || c == '\r' || c == '=' || c == '\t') continue;
            writer.write(cArray, n4, i - n4);
            if (c == '<') {
                writer.write(ESC_LESS_THAN, 0, 4);
            } else if (c == '>') {
                writer.write(ESC_GREATER_THAN, 0, 4);
            } else if (c == '&') {
                writer.write(ESC_AMPERSAND, 0, 5);
            } else if (c > '\u007f') {
                writer.write(AMPERSAND_HASH, 0, 2);
                writer.write(Integer.toString(c));
                writer.write(59);
            } else {
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
            }
            n4 = i + 1;
        }
        writer.write(cArray, n4, n3 - n4);
    }

    public void text(Writer writer, char c) throws InvalidXMLException, IOException {
        if (c >= '?' && c <= '\u007f' || c >= '\'' && c <= ';' || c >= ' ' && c <= '%' || c == '&' || c > '\u007f' && !this._sevenBitEncoding || c == '\n' || c == '\r' || c == '=' || c == '\t') {
            writer.write(c);
        } else if (c == '<') {
            writer.write(ESC_LESS_THAN, 0, 4);
        } else if (c == '>') {
            writer.write(ESC_GREATER_THAN, 0, 4);
        } else if (c > '\u007f') {
            writer.write(AMPERSAND_HASH, 0, 2);
            writer.write(Integer.toString(c));
            writer.write(59);
        } else {
            throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
        }
    }

    public void text(Writer writer, char c, boolean bl) throws InvalidXMLException, IOException {
        if (c >= '?' && c <= '\u007f' || c >= '\'' && c <= ';' || c >= ' ' && c <= '%' || c == '&' && bl || c > '\u007f' && !this._sevenBitEncoding || c == '\n' || c == '\r' || c == '=' || c == '\t') {
            writer.write(c);
        } else if (c == '<') {
            writer.write(ESC_LESS_THAN, 0, 4);
        } else if (c == '>') {
            writer.write(ESC_GREATER_THAN, 0, 4);
        } else if (c == '&') {
            writer.write(ESC_AMPERSAND, 0, 5);
        } else if (c > '\u007f') {
            writer.write(AMPERSAND_HASH, 0, 2);
            writer.write(Integer.toString(c));
            writer.write(59);
        } else {
            throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
        }
    }

    public void whitespace(Writer writer, String string2) throws NullPointerException, InvalidXMLException, IOException {
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        this.whitespace(writer, cArray, 0, n);
    }

    public void whitespace(Writer writer, char[] cArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        XMLChecker.checkS(cArray, n, n2);
        writer.write(cArray, n, n2);
    }

    public void attribute(Writer writer, String string2, String string3, char c, boolean bl) throws NullPointerException, IOException {
        boolean bl2;
        char[] cArray = string3.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = n2 + n;
        int n4 = 0;
        if (c == '\"') {
            bl2 = true;
        } else if (c == '\'') {
            bl2 = false;
        } else {
            String string4 = "Character 0x" + Integer.toHexString(c) + " ('" + c + "') is not a valid quotation mark.";
            throw new IllegalArgumentException(string4);
        }
        writer.write(32);
        writer.write(string2);
        if (bl2) {
            writer.write(EQUALS_QUOTE, 0, 2);
        } else {
            writer.write(EQUALS_APOSTROPHE, 0, 2);
        }
        for (int i = n2; i < n3; ++i) {
            char c2 = cArray[i];
            if (c2 >= '?' && c2 <= '\u007f' || c2 >= '(' && c2 <= ';' || c2 >= ' ' && c2 <= '%' && c2 != '\"' || c2 == '&' && !bl || c2 > '\u007f' && !this._sevenBitEncoding || !bl2 && c2 == '\"' || bl2 && c2 == '\'' || c2 == '\n' || c2 == '\r' || c2 == '=' || c2 == '\t') continue;
            writer.write(cArray, n4, i - n4);
            if (c2 == '<') {
                writer.write(ESC_LESS_THAN, 0, 4);
            } else if (c2 == '>') {
                writer.write(ESC_GREATER_THAN, 0, 4);
            } else if (c2 == '\"') {
                writer.write(ESC_QUOTE, 0, 6);
            } else if (c2 == '\'') {
                writer.write(ESC_APOSTROPHE, 0, 6);
            } else if (c2 == '&') {
                writer.write(ESC_AMPERSAND, 0, 5);
            } else if (c2 > '\u007f') {
                writer.write(AMPERSAND_HASH, 0, 2);
                writer.write(Integer.toString(c2));
                writer.write(59);
            } else {
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c2) + " is not valid.");
            }
            n4 = i + 1;
        }
        writer.write(cArray, n4, n - n4);
        writer.write(c);
    }
}

