/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.util.Enumerator;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.servlet.CookieWrapper;
import org.glassfish.grizzly.servlet.HttpSessionImpl;
import org.glassfish.grizzly.servlet.ServletContextImpl;
import org.glassfish.grizzly.servlet.ServletInputStreamImpl;
import org.glassfish.grizzly.servlet.ServletReaderImpl;

public class HttpServletRequestImpl
implements HttpServletRequest {
    private static final Logger logger = Grizzly.logger(HttpServletRequestImpl.class);
    private final ServletInputStreamImpl inputStream = new ServletInputStreamImpl();
    private ServletReaderImpl reader;
    private HttpSessionImpl httpSession = null;
    private ServletContextImpl contextImpl;
    private String servletPath = "";
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    private static final ThreadCache.CachedTypeIndex<HttpServletRequestImpl> CACHE_IDX = ThreadCache.obtainIndex(HttpServletRequestImpl.class, 2);
    protected Request request = null;

    public static HttpServletRequestImpl create() {
        HttpServletRequestImpl request = ThreadCache.takeFromCache(CACHE_IDX);
        if (request != null) {
            return request;
        }
        return new HttpServletRequestImpl();
    }

    protected HttpServletRequestImpl() {
    }

    public void initialize(Request request) throws IOException {
        this.request = request;
        this.inputStream.initialize(request);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public Object getAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetAttributePrivilegedAction());
        }
        return new Enumerator<String>(this.request.getAttributeNames());
    }

    @Override
    public String getCharacterEncoding() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return (String)AccessController.doPrivileged(new GetCharacterEncodingPrivilegedAction());
        }
        return this.request.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        this.request.setCharacterEncoding(env);
    }

    @Override
    public int getContentLength() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getContentLength();
    }

    @Override
    public String getContentType() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getContentType();
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException("Illegal attempt to call getInputStream() after getReader() has already been called.");
        }
        this.usingInputStream = true;
        return this.inputStream;
    }

    void recycle() {
        this.request = null;
        this.reader = null;
        this.inputStream.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
    }

    @Override
    public String getParameter(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return (String)AccessController.doPrivileged(new GetParameterPrivilegedAction(name));
        }
        return this.request.getParameter(name);
    }

    public Enumeration getParameterNames() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return new Enumerator((Set)AccessController.doPrivileged(new GetParameterNamesPrivilegedAction()));
        }
        return new Enumerator<String>(this.request.getParameterNames());
    }

    @Override
    public String[] getParameterValues(String name) {
        String[] ret;
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            ret = (String[])AccessController.doPrivileged(new GetParameterValuePrivilegedAction(name));
            if (ret != null) {
                ret = (String[])ret.clone();
            }
        } else {
            ret = this.request.getParameterValues(name);
        }
        return ret;
    }

    public Map getParameterMap() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return (Map)AccessController.doPrivileged(new GetParameterMapPrivilegedAction());
        }
        return this.request.getParameterMap();
    }

    @Override
    public String getProtocol() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getProtocol().getProtocolString();
    }

    @Override
    public String getScheme() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getScheme();
    }

    @Override
    public String getServerName() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getServerName();
    }

    @Override
    public int getServerPort() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getServerPort();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException("Illegal attempt to call getReader() after getInputStream() has already been called.");
        }
        this.usingReader = true;
        if (this.reader == null) {
            this.reader = new ServletReaderImpl(this.request.getReader(false));
        }
        return this.reader;
    }

    @Override
    public String getRemoteAddr() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemoteHost();
    }

    @Override
    public void setAttribute(String name, Object value2) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        Object oldValue = this.request.getAttribute(name);
        this.request.setAttribute(name, value2);
        List<EventListener> listeners = this.contextImpl.getListeners();
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        for (int i = 0; i < listeners.size(); ++i) {
            if (!(listeners.get(i) instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners.get(i);
            try {
                if (event == null) {
                    event = oldValue != null ? new ServletRequestAttributeEvent(this.contextImpl, this, name, oldValue) : new ServletRequestAttributeEvent(this.contextImpl, this, name, value2);
                }
                if (oldValue != null) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_ADD_ERROR("ServletRequestAttributeListener", listener.getClass().getName()), t);
            }
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        Object value2 = this.request.getAttribute(name);
        this.request.removeAttribute(name);
        List<EventListener> listeners = this.contextImpl.getListeners();
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        for (int i = 0; i < listeners.size(); ++i) {
            if (!(listeners.get(i) instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners.get(i);
            try {
                if (event == null) {
                    event = new ServletRequestAttributeEvent(this.contextImpl, this, name, value2);
                }
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_REMOVE_ERROR("ServletRequestAttributeListener", listener.getClass().getName()), t);
            }
        }
    }

    @Override
    public Locale getLocale() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return (Locale)AccessController.doPrivileged(new GetLocalePrivilegedAction());
        }
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetLocalesPrivilegedAction());
        }
        return new Enumerator<Locale>(this.request.getLocales());
    }

    @Override
    public boolean isSecure() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.isSecure();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return (RequestDispatcher)AccessController.doPrivileged(new GetRequestDispatcherPrivilegedAction(path));
        }
        return this.getRequestDispatcherInternal(path);
    }

    private RequestDispatcher getRequestDispatcherInternal(String path) {
        if (this.contextImpl == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.contextImpl.getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        String requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? requestPath.substring(0, pos + 1) + path : requestPath + path;
        return this.contextImpl.getRequestDispatcher(relative);
    }

    @Override
    public String getRealPath(String path) {
        return this.contextImpl.getRealPath(path);
    }

    @Override
    public String getAuthType() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getAuthType();
    }

    public org.glassfish.grizzly.http.Cookie[] getGrizzlyCookies() {
        org.glassfish.grizzly.http.Cookie[] ret;
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            ret = (org.glassfish.grizzly.http.Cookie[])AccessController.doPrivileged(new GetCookiesPrivilegedAction());
            if (ret != null) {
                ret = (org.glassfish.grizzly.http.Cookie[])ret.clone();
            }
        } else {
            ret = this.request.getCookies();
        }
        return ret;
    }

    @Override
    public long getDateHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getDateHeader(name);
    }

    @Override
    public String getHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetHeadersPrivilegedAction(name));
        }
        return new Enumerator<String>(this.request.getHeaders(name).iterator());
    }

    public Enumeration getHeaderNames() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new GetHeaderNamesPrivilegedAction());
        }
        return new Enumerator<String>(this.request.getHeaderNames().iterator());
    }

    @Override
    public int getIntHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getIntHeader(name);
    }

    @Override
    public String getMethod() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getMethod().getMethodString();
    }

    @Override
    public String getPathInfo() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        String path = this.request.getRequestURI();
        StringBuilder pathToRemove = new StringBuilder();
        pathToRemove.append(this.contextImpl.getContextPath());
        pathToRemove.append(this.getServletPath());
        String s = pathToRemove.toString();
        if (path.startsWith(s)) {
            String pathInfo = path.substring(s.length());
            return "".equals(pathInfo) ? null : pathInfo;
        }
        throw new IllegalStateException("Request path not in servlet context.");
    }

    @Override
    public String getPathTranslated() {
        if (this.getPathInfo() == null) {
            return null;
        }
        return this.contextImpl.getRealPath(this.getPathInfo());
    }

    @Override
    public String getContextPath() {
        return this.contextImpl.getContextPath();
    }

    @Override
    public String getQueryString() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getQueryString();
    }

    @Override
    public String getRemoteUser() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemoteUser();
    }

    @Override
    public boolean isUserInRole(String role) {
        throw new IllegalStateException("Not yet implemented");
    }

    @Override
    public Principal getUserPrincipal() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getUserPrincipal();
    }

    @Override
    public String getRequestedSessionId() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRequestedSessionId();
    }

    @Override
    public String getRequestURI() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRequestURI();
    }

    @Override
    public StringBuffer getRequestURL() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return Request.appendRequestURL(this.request, new StringBuffer());
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    protected void initSession() {
        Session session = this.request.getSession(false);
        if (session != null) {
            this.httpSession = new HttpSessionImpl(this.contextImpl);
            this.httpSession.notifyNew();
            this.httpSession.setSession(session);
            this.httpSession.access();
        }
    }

    @Override
    public HttpSession getSession(boolean create2) {
        if (this.httpSession == null && create2) {
            this.httpSession = new HttpSessionImpl(this.contextImpl);
        }
        if (this.httpSession != null) {
            Session session = this.request.getSession(create2);
            if (session != null) {
                this.httpSession.setSession(session);
                this.httpSession.access();
            } else {
                return null;
            }
        }
        return this.httpSession;
    }

    @Override
    public HttpSession getSession() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.getSession(true);
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    @Override
    public Cookie[] getCookies() {
        org.glassfish.grizzly.http.Cookie[] internalCookies = this.request.getCookies();
        if (internalCookies == null) {
            return null;
        }
        Cookie[] cookies = new Cookie[internalCookies.length];
        for (int i = 0; i < internalCookies.length; ++i) {
            org.glassfish.grizzly.http.Cookie cook = internalCookies[i];
            if (cook instanceof CookieWrapper) {
                cookies[i] = ((CookieWrapper)internalCookies[i]).getWrappedCookie();
                continue;
            }
            cookies[i] = new Cookie(cook.getName(), cook.getValue());
            cookies[i].setComment(cook.getComment());
            if (cook.getDomain() != null) {
                cookies[i].setDomain(cook.getDomain());
            }
            cookies[i].setMaxAge(cook.getMaxAge());
            cookies[i].setPath(cook.getPath());
            cookies[i].setSecure(cook.isSecure());
            cookies[i].setVersion(cook.getVersion());
        }
        return cookies;
    }

    @Override
    public int getRemotePort() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getRemotePort();
    }

    @Override
    public String getLocalName() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getLocalName();
    }

    @Override
    public String getLocalAddr() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getLocalAddr();
    }

    @Override
    public int getLocalPort() {
        if (this.request == null) {
            throw new IllegalStateException("Null request object");
        }
        return this.request.getLocalPort();
    }

    protected ServletContextImpl getContextImpl() {
        return this.contextImpl;
    }

    protected void setContextImpl(ServletContextImpl contextImpl) {
        this.contextImpl = contextImpl;
    }

    protected void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    private static final class GetSessionPrivilegedAction
    implements PrivilegedAction {
        private final boolean create;

        public GetSessionPrivilegedAction(boolean create2) {
            this.create = create2;
        }

        public Object run() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private final class GetLocalesPrivilegedAction
    implements PrivilegedAction {
        private GetLocalesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getLocales();
        }
    }

    private final class GetLocalePrivilegedAction
    implements PrivilegedAction {
        private GetLocalePrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getLocale();
        }
    }

    private final class GetHeaderNamesPrivilegedAction
    implements PrivilegedAction {
        private GetHeaderNamesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getHeaderNames();
        }
    }

    private final class GetHeadersPrivilegedAction
    implements PrivilegedAction {
        private final String name;

        public GetHeadersPrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getHeaders(this.name);
        }
    }

    private final class GetCharacterEncodingPrivilegedAction
    implements PrivilegedAction {
        private GetCharacterEncodingPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getCharacterEncoding();
        }
    }

    private final class GetCookiesPrivilegedAction
    implements PrivilegedAction {
        private GetCookiesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getCookies();
        }
    }

    private final class GetParameterValuePrivilegedAction
    implements PrivilegedAction {
        public final String name;

        public GetParameterValuePrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameterValues(this.name);
        }
    }

    private final class GetParameterNamesPrivilegedAction
    implements PrivilegedAction {
        private GetParameterNamesPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameterNames();
        }
    }

    private final class GetParameterPrivilegedAction
    implements PrivilegedAction {
        public final String name;

        public GetParameterPrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameter(this.name);
        }
    }

    private final class GetRequestDispatcherPrivilegedAction
    implements PrivilegedAction {
        private final String path;

        public GetRequestDispatcherPrivilegedAction(String path) {
            this.path = path;
        }

        public Object run() {
            return HttpServletRequestImpl.this.getRequestDispatcherInternal(this.path);
        }
    }

    private final class GetParameterMapPrivilegedAction
    implements PrivilegedAction {
        private GetParameterMapPrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getParameterMap();
        }
    }

    private final class GetAttributePrivilegedAction
    implements PrivilegedAction {
        private GetAttributePrivilegedAction() {
        }

        public Object run() {
            return HttpServletRequestImpl.this.request.getAttributeNames();
        }
    }
}

