/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.streams;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.streams.Output;
import org.glassfish.grizzly.streams.Stream;
import org.glassfish.grizzly.streams.StreamWriter;

public abstract class AbstractStreamWriter
implements StreamWriter {
    protected static final Logger logger = Grizzly.logger(AbstractStreamWriter.class);
    protected static final Integer ZERO = 0;
    protected static final GrizzlyFuture<Integer> ZERO_READY_FUTURE = ReadyFutureImpl.create(ZERO);
    private final Connection connection;
    private long timeoutMillis = 30000L;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    protected final boolean isOutputBuffered;
    protected final Output output;

    protected AbstractStreamWriter(Connection connection, Output streamOutput) {
        this.connection = connection;
        this.output = streamOutput;
        this.isOutputBuffered = streamOutput.isBuffered();
    }

    @Override
    public GrizzlyFuture<Integer> flush() throws IOException {
        return this.flush(null);
    }

    @Override
    public GrizzlyFuture<Integer> flush(CompletionHandler<Integer> completionHandler) throws IOException {
        return this.output.flush(completionHandler);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    @Override
    public GrizzlyFuture<Integer> close(CompletionHandler<Integer> completionHandler) throws IOException {
        if (!this.isClosed.getAndSet(true)) {
            return this.output.close(completionHandler);
        }
        return ReadyFutureImpl.create(0);
    }

    @Override
    public void writeBuffer(Buffer b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void writeBoolean(boolean data) throws IOException {
        byte value2 = data ? (byte)1 : 0;
        this.writeByte(value2);
    }

    @Override
    public void writeByte(byte data) throws IOException {
        this.output.write(data);
    }

    @Override
    public void writeChar(char data) throws IOException {
        if (this.isOutputBuffered) {
            this.output.ensureBufferCapacity(2);
            this.output.getBuffer().putChar(data);
        } else {
            this.output.write((byte)(data >>> 8 & 0xFF));
            this.output.write((byte)(data & 0xFF));
        }
    }

    @Override
    public void writeShort(short data) throws IOException {
        if (this.isOutputBuffered) {
            this.output.ensureBufferCapacity(2);
            this.output.getBuffer().putShort(data);
        } else {
            this.output.write((byte)(data >>> 8 & 0xFF));
            this.output.write((byte)(data & 0xFF));
        }
    }

    @Override
    public void writeInt(int data) throws IOException {
        if (this.isOutputBuffered) {
            this.output.ensureBufferCapacity(4);
            this.output.getBuffer().putInt(data);
        } else {
            this.output.write((byte)(data >>> 24 & 0xFF));
            this.output.write((byte)(data >>> 16 & 0xFF));
            this.output.write((byte)(data >>> 8 & 0xFF));
            this.output.write((byte)(data & 0xFF));
        }
    }

    @Override
    public void writeLong(long data) throws IOException {
        if (this.isOutputBuffered) {
            this.output.ensureBufferCapacity(8);
            this.output.getBuffer().putLong(data);
        } else {
            this.output.write((byte)(data >>> 56 & 0xFFL));
            this.output.write((byte)(data >>> 48 & 0xFFL));
            this.output.write((byte)(data >>> 40 & 0xFFL));
            this.output.write((byte)(data >>> 32 & 0xFFL));
            this.output.write((byte)(data >>> 24 & 0xFFL));
            this.output.write((byte)(data >>> 16 & 0xFFL));
            this.output.write((byte)(data >>> 8 & 0xFFL));
            this.output.write((byte)(data & 0xFFL));
        }
    }

    @Override
    public void writeFloat(float data) throws IOException {
        this.writeInt(Float.floatToIntBits(data));
    }

    @Override
    public void writeDouble(double data) throws IOException {
        this.writeLong(Double.doubleToLongBits(data));
    }

    @Override
    public void writeBooleanArray(boolean[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.output.write((byte)(data[i] ? 1 : 0));
        }
    }

    @Override
    public void writeByteArray(byte[] data) throws IOException {
        this.writeByteArray(data, 0, data.length);
    }

    @Override
    public void writeByteArray(byte[] data, int offset, int length) throws IOException {
        Buffer buffer = Buffers.wrap(this.connection.getTransport().getMemoryManager(), data, offset, length);
        this.output.write(buffer);
    }

    @Override
    public void writeCharArray(char[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.writeChar(data[i]);
        }
    }

    @Override
    public void writeShortArray(short[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.writeShort(data[i]);
        }
    }

    @Override
    public void writeIntArray(int[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.writeInt(data[i]);
        }
    }

    @Override
    public void writeLongArray(long[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.writeLong(data[i]);
        }
    }

    @Override
    public void writeFloatArray(float[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.writeFloat(data[i]);
        }
    }

    @Override
    public void writeDoubleArray(double[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.writeDouble(data[i]);
        }
    }

    @Override
    public <E> GrizzlyFuture<Stream> encode(Transformer<E, Buffer> encoder, E object) throws IOException {
        return this.encode(encoder, object, null);
    }

    @Override
    public <E> GrizzlyFuture<Stream> encode(Transformer<E, Buffer> encoder, E object, CompletionHandler<Stream> completionHandler) throws IOException {
        RuntimeException exception = null;
        TransformationResult<E, Buffer> result = encoder.transform(this.connection, object);
        TransformationResult.Status status = result.getStatus();
        if (status == TransformationResult.Status.COMPLETE) {
            this.output.write(result.getMessage());
            if (completionHandler != null) {
                completionHandler.completed(this);
            }
            return ReadyFutureImpl.create(this);
        }
        if (status == TransformationResult.Status.INCOMPLETE) {
            exception = new IllegalStateException("Encoder returned INCOMPLETE state");
        }
        if (exception == null) {
            exception = new TransformationException(result.getErrorCode() + ": " + result.getErrorDescription());
        }
        return ReadyFutureImpl.create(exception);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public long getTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setTimeout(long timeout, TimeUnit timeunit) {
        this.timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
    }

    public static class DisposeBufferCompletionHandler
    implements CompletionHandler {
        private final Buffer buffer;

        public DisposeBufferCompletionHandler(Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void cancelled() {
            this.disposeBuffer();
        }

        @Override
        public void failed(Throwable throwable) {
            this.disposeBuffer();
        }

        public void completed(Object result) {
            this.disposeBuffer();
        }

        public void updated(Object result) {
        }

        protected void disposeBuffer() {
            this.buffer.dispose();
        }
    }
}

