/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.memory.MemoryManager;

public abstract class AbstractTransformer<K, L>
implements Transformer<K, L> {
    protected final AttributeBuilder attributeBuilder = Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
    protected final Attribute<LastResultAwareState<K, L>> stateAttr;
    private MemoryManager memoryManager;

    public AbstractTransformer() {
        String namePrefix = this.getNamePrefix();
        this.stateAttr = this.attributeBuilder.createAttribute(namePrefix + ".state");
    }

    protected String getNamePrefix() {
        return this.getClass().getName();
    }

    @Override
    public final TransformationResult<K, L> transform(AttributeStorage storage, K input) throws TransformationException {
        return this.saveLastResult(storage, this.transformImpl(storage, input));
    }

    protected abstract TransformationResult<K, L> transformImpl(AttributeStorage var1, K var2) throws TransformationException;

    @Override
    public final TransformationResult<K, L> getLastResult(AttributeStorage storage) {
        LastResultAwareState<K, L> state = this.stateAttr.get(storage);
        if (state != null) {
            return state.getLastResult();
        }
        return null;
    }

    protected final TransformationResult<K, L> saveLastResult(AttributeStorage storage, TransformationResult<K, L> result) {
        this.obtainStateObject(storage).setLastResult(result);
        return result;
    }

    @Override
    public void release(AttributeStorage storage) {
        this.stateAttr.remove(storage);
    }

    protected MemoryManager obtainMemoryManager(AttributeStorage storage) {
        if (this.memoryManager != null) {
            return this.memoryManager;
        }
        if (storage instanceof Connection) {
            Connection connection = (Connection)storage;
            return connection.getTransport().getMemoryManager();
        }
        return MemoryManager.DEFAULT_MEMORY_MANAGER;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public void setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public static <T> T getValue(AttributeStorage storage, Attribute<T> attribute, T defaultValue) {
        T value2 = attribute.get(storage);
        if (value2 != null) {
            return value2;
        }
        return defaultValue;
    }

    protected final LastResultAwareState<K, L> obtainStateObject(AttributeStorage storage) {
        LastResultAwareState<K, L> value2 = this.stateAttr.get(storage);
        if (value2 == null) {
            value2 = this.createStateObject();
            this.stateAttr.set(storage, value2);
        }
        return value2;
    }

    protected LastResultAwareState<K, L> createStateObject() {
        return new LastResultAwareState();
    }

    public static class LastResultAwareState<K, L> {
        protected TransformationResult<K, L> lastResult;

        public TransformationResult<K, L> getLastResult() {
            return this.lastResult;
        }

        public void setLastResult(TransformationResult<K, L> lastResult) {
            this.lastResult = lastResult;
        }
    }
}

