/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelPromiseAggregator;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private final ChannelHandlerContext ctx;
    private final ChannelOutboundBuffer buffer;
    private final MessageSizeEstimator.Handle estimatorHandle;
    private PendingWrite head;
    private PendingWrite tail;
    private int size;

    public PendingWriteQueue(ChannelHandlerContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx");
        }
        this.ctx = ctx;
        this.buffer = ctx.channel().unsafe().outboundBuffer();
        this.estimatorHandle = ctx.channel().config().getMessageSizeEstimator().newHandle();
    }

    public boolean isEmpty() {
        assert (this.ctx.executor().inEventLoop());
        return this.head == null;
    }

    public int size() {
        assert (this.ctx.executor().inEventLoop());
        return this.size;
    }

    public void add(Object msg, ChannelPromise promise) {
        assert (this.ctx.executor().inEventLoop());
        if (msg == null) {
            throw new NullPointerException("msg");
        }
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        int messageSize = this.estimatorHandle.size(msg);
        if (messageSize < 0) {
            messageSize = 0;
        }
        PendingWrite write2 = PendingWrite.newInstance(msg, messageSize, promise);
        PendingWrite currentTail = this.tail;
        if (currentTail == null) {
            this.tail = this.head = write2;
        } else {
            currentTail.next = write2;
            this.tail = write2;
        }
        ++this.size;
        this.buffer.incrementPendingOutboundBytes(write2.size);
    }

    public void removeAndFailAll(Throwable cause) {
        assert (this.ctx.executor().inEventLoop());
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        PendingWrite write2 = this.head;
        this.tail = null;
        this.head = null;
        this.size = 0;
        while (write2 != null) {
            PendingWrite next2 = write2.next;
            ReferenceCountUtil.safeRelease(write2.msg);
            ChannelPromise promise = write2.promise;
            this.recycle(write2, false);
            PendingWriteQueue.safeFail(promise, cause);
            write2 = next2;
        }
        this.assertEmpty();
    }

    public void removeAndFail(Throwable cause) {
        assert (this.ctx.executor().inEventLoop());
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return;
        }
        ReferenceCountUtil.safeRelease(write2.msg);
        ChannelPromise promise = write2.promise;
        PendingWriteQueue.safeFail(promise, cause);
        this.recycle(write2, true);
    }

    public ChannelFuture removeAndWriteAll() {
        assert (this.ctx.executor().inEventLoop());
        if (this.size == 1) {
            return this.removeAndWrite();
        }
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        this.tail = null;
        this.head = null;
        this.size = 0;
        ChannelPromise p = this.ctx.newPromise();
        ChannelPromiseAggregator aggregator = new ChannelPromiseAggregator(p);
        while (write2 != null) {
            PendingWrite next2 = write2.next;
            Object msg = write2.msg;
            ChannelPromise promise = write2.promise;
            this.recycle(write2, false);
            this.ctx.write(msg, promise);
            aggregator.add(promise);
            write2 = next2;
        }
        this.assertEmpty();
        return p;
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    public ChannelFuture removeAndWrite() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        Object msg = write2.msg;
        ChannelPromise promise = write2.promise;
        this.recycle(write2, true);
        return this.ctx.write(msg, promise);
    }

    public ChannelPromise remove() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        ChannelPromise promise = write2.promise;
        ReferenceCountUtil.safeRelease(write2.msg);
        this.recycle(write2, true);
        return promise;
    }

    public Object current() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        return write2.msg;
    }

    private void recycle(PendingWrite write2, boolean update2) {
        PendingWrite next2 = write2.next;
        long writeSize = write2.size;
        if (update2) {
            if (next2 == null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
            } else {
                this.head = next2;
                --this.size;
                assert (this.size > 0);
            }
        }
        write2.recycle();
        this.buffer.decrementPendingOutboundBytes(writeSize);
    }

    private static void safeFail(ChannelPromise promise, Throwable cause) {
        if (!(promise instanceof VoidChannelPromise) && !promise.tryFailure(cause)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)promise, (Object)cause);
        }
    }

    static final class PendingWrite {
        private static final Recycler<PendingWrite> RECYCLER = new Recycler<PendingWrite>(){

            @Override
            protected PendingWrite newObject(Recycler.Handle handle2) {
                return new PendingWrite(handle2);
            }
        };
        private final Recycler.Handle handle;
        private PendingWrite next;
        private long size;
        private ChannelPromise promise;
        private Object msg;

        private PendingWrite(Recycler.Handle handle2) {
            this.handle = handle2;
        }

        static PendingWrite newInstance(Object msg, int size2, ChannelPromise promise) {
            PendingWrite write2 = RECYCLER.get();
            write2.size = size2;
            write2.msg = msg;
            write2.promise = promise;
            return write2;
        }

        private void recycle() {
            this.size = 0L;
            this.next = null;
            this.msg = null;
            this.promise = null;
            RECYCLER.recycle(this, this.handle);
        }
    }
}

