/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.IntegerHolder;
import io.netty.util.internal.ThreadLocalRandom;
import io.netty.util.internal.TypeParameterMatcher;
import io.netty.util.internal.UnpaddedInternalThreadLocalMap;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class InternalThreadLocalMap
extends UnpaddedInternalThreadLocalMap {
    public static final Object UNSET = new Object();
    public long rp1;
    public long rp2;
    public long rp3;
    public long rp4;
    public long rp5;
    public long rp6;
    public long rp7;
    public long rp8;
    public long rp9;

    public static InternalThreadLocalMap getIfSet() {
        ThreadLocal<InternalThreadLocalMap> slowThreadLocalMap;
        Thread thread = Thread.currentThread();
        Object threadLocalMap = thread instanceof FastThreadLocalThread ? ((FastThreadLocalThread)thread).threadLocalMap() : ((slowThreadLocalMap = UnpaddedInternalThreadLocalMap.slowThreadLocalMap) == null ? null : slowThreadLocalMap.get());
        return threadLocalMap;
    }

    public static InternalThreadLocalMap get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return InternalThreadLocalMap.fastGet((FastThreadLocalThread)thread);
        }
        return InternalThreadLocalMap.slowGet();
    }

    private static InternalThreadLocalMap fastGet(FastThreadLocalThread thread) {
        InternalThreadLocalMap threadLocalMap = thread.threadLocalMap();
        if (threadLocalMap == null) {
            threadLocalMap = new InternalThreadLocalMap();
            thread.setThreadLocalMap(threadLocalMap);
        }
        return threadLocalMap;
    }

    private static InternalThreadLocalMap slowGet() {
        InternalThreadLocalMap ret;
        ThreadLocal<InternalThreadLocalMap> slowThreadLocalMap = UnpaddedInternalThreadLocalMap.slowThreadLocalMap;
        if (slowThreadLocalMap == null) {
            slowThreadLocalMap = new ThreadLocal();
            UnpaddedInternalThreadLocalMap.slowThreadLocalMap = slowThreadLocalMap;
        }
        if ((ret = slowThreadLocalMap.get()) == null) {
            ret = new InternalThreadLocalMap();
            slowThreadLocalMap.set(ret);
        }
        return ret;
    }

    public static void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            ((FastThreadLocalThread)thread).setThreadLocalMap(null);
        } else {
            ThreadLocal<InternalThreadLocalMap> slowThreadLocalMap = UnpaddedInternalThreadLocalMap.slowThreadLocalMap;
            if (slowThreadLocalMap != null) {
                slowThreadLocalMap.remove();
            }
        }
    }

    public static void destroy() {
        slowThreadLocalMap = null;
    }

    public static int nextVariableIndex() {
        int index = nextIndex.getAndIncrement();
        if (index < 0) {
            nextIndex.decrementAndGet();
            throw new IllegalStateException("too many thread-local indexed variables");
        }
        return index;
    }

    public static int lastVariableIndex() {
        return nextIndex.get() - 1;
    }

    private InternalThreadLocalMap() {
        super(InternalThreadLocalMap.newIndexedVariableTable());
    }

    private static Object[] newIndexedVariableTable() {
        Object[] array = new Object[32];
        Arrays.fill(array, UNSET);
        return array;
    }

    public int size() {
        int count2 = 0;
        if (this.futureListenerStackDepth != 0) {
            ++count2;
        }
        if (this.localChannelReaderStackDepth != 0) {
            ++count2;
        }
        if (this.handlerSharableCache != null) {
            ++count2;
        }
        if (this.counterHashCode != null) {
            ++count2;
        }
        if (this.random != null) {
            ++count2;
        }
        if (this.typeParameterMatcherGetCache != null) {
            ++count2;
        }
        if (this.typeParameterMatcherFindCache != null) {
            ++count2;
        }
        if (this.stringBuilder != null) {
            ++count2;
        }
        if (this.charsetEncoderCache != null) {
            ++count2;
        }
        if (this.charsetDecoderCache != null) {
            ++count2;
        }
        for (Object o : this.indexedVariables) {
            if (o == UNSET) continue;
            ++count2;
        }
        return count2 - 1;
    }

    public StringBuilder stringBuilder() {
        StringBuilder builder = this.stringBuilder;
        if (builder == null) {
            this.stringBuilder = builder = new StringBuilder(512);
        } else {
            builder.setLength(0);
        }
        return builder;
    }

    public Map<Charset, CharsetEncoder> charsetEncoderCache() {
        IdentityHashMap cache = this.charsetEncoderCache;
        if (cache == null) {
            this.charsetEncoderCache = cache = new IdentityHashMap();
        }
        return cache;
    }

    public Map<Charset, CharsetDecoder> charsetDecoderCache() {
        IdentityHashMap cache = this.charsetDecoderCache;
        if (cache == null) {
            this.charsetDecoderCache = cache = new IdentityHashMap();
        }
        return cache;
    }

    public int futureListenerStackDepth() {
        return this.futureListenerStackDepth;
    }

    public void setFutureListenerStackDepth(int futureListenerStackDepth) {
        this.futureListenerStackDepth = futureListenerStackDepth;
    }

    public ThreadLocalRandom random() {
        ThreadLocalRandom r = this.random;
        if (r == null) {
            this.random = r = new ThreadLocalRandom();
        }
        return r;
    }

    public Map<Class<?>, TypeParameterMatcher> typeParameterMatcherGetCache() {
        IdentityHashMap cache = this.typeParameterMatcherGetCache;
        if (cache == null) {
            this.typeParameterMatcherGetCache = cache = new IdentityHashMap();
        }
        return cache;
    }

    public Map<Class<?>, Map<String, TypeParameterMatcher>> typeParameterMatcherFindCache() {
        IdentityHashMap cache = this.typeParameterMatcherFindCache;
        if (cache == null) {
            this.typeParameterMatcherFindCache = cache = new IdentityHashMap();
        }
        return cache;
    }

    public IntegerHolder counterHashCode() {
        return this.counterHashCode;
    }

    public void setCounterHashCode(IntegerHolder counterHashCode) {
        this.counterHashCode = counterHashCode;
    }

    public Map<Class<?>, Boolean> handlerSharableCache() {
        WeakHashMap cache = this.handlerSharableCache;
        if (cache == null) {
            this.handlerSharableCache = cache = new WeakHashMap(4);
        }
        return cache;
    }

    public int localChannelReaderStackDepth() {
        return this.localChannelReaderStackDepth;
    }

    public void setLocalChannelReaderStackDepth(int localChannelReaderStackDepth) {
        this.localChannelReaderStackDepth = localChannelReaderStackDepth;
    }

    public Object indexedVariable(int index) {
        Object[] lookup2 = this.indexedVariables;
        return index < lookup2.length ? lookup2[index] : UNSET;
    }

    public boolean setIndexedVariable(int index, Object value2) {
        Object[] lookup2 = this.indexedVariables;
        if (index < lookup2.length) {
            Object oldValue = lookup2[index];
            lookup2[index] = value2;
            return oldValue == UNSET;
        }
        this.expandIndexedVariableTableAndSet(index, value2);
        return true;
    }

    private void expandIndexedVariableTableAndSet(int index, Object value2) {
        Object[] oldArray = this.indexedVariables;
        int oldCapacity = oldArray.length;
        int newCapacity = index;
        newCapacity |= newCapacity >>> 1;
        newCapacity |= newCapacity >>> 2;
        newCapacity |= newCapacity >>> 4;
        newCapacity |= newCapacity >>> 8;
        newCapacity |= newCapacity >>> 16;
        Object[] newArray = Arrays.copyOf(oldArray, ++newCapacity);
        Arrays.fill(newArray, oldCapacity, newArray.length, UNSET);
        newArray[index] = value2;
        this.indexedVariables = newArray;
    }

    public Object removeIndexedVariable(int index) {
        Object[] lookup2 = this.indexedVariables;
        if (index < lookup2.length) {
            Object v = lookup2[index];
            lookup2[index] = UNSET;
            return v;
        }
        return UNSET;
    }

    public boolean isIndexedVariableSet(int index) {
        Object[] lookup2 = this.indexedVariables;
        return index < lookup2.length && lookup2[index] != UNSET;
    }
}

