/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.common.TopicAndPartition;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.BrokerTopicStats$;
import kafka.server.FetchDataInfo;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.RecordBatchTooLargeException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rMd\u0001B\u0001\u0003\u0001\u001d\u00111\u0001T8h\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u001diW\r\u001e:jGNL!!\u0007\f\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\r!\u0017N]\u000b\u0002;A\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0003S>T\u0011AI\u0001\u0005U\u00064\u0018-\u0003\u0002%?\t!a)\u001b7f\u0011!1\u0003A!A!\u0002\u0013i\u0012\u0001\u00023je\u0002B\u0001\u0002\u000b\u0001\u0003\u0002\u0004%\t!K\u0001\u0007G>tg-[4\u0016\u0003)\u0002\"a\u000b\u0017\u000e\u0003\tI!!\f\u0002\u0003\u00131{wmQ8oM&<\u0007\u0002C\u0018\u0001\u0005\u0003\u0007I\u0011\u0001\u0019\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u00022iA\u0011\u0011BM\u0005\u0003g)\u0011A!\u00168ji\"9QGLA\u0001\u0002\u0004Q\u0013a\u0001=%c!Aq\u0007\u0001B\u0001B\u0003&!&A\u0004d_:4\u0017n\u001a\u0011)\u0005YJ\u0004CA\u0005;\u0013\tY$B\u0001\u0005w_2\fG/\u001b7f\u0011!i\u0004A!a\u0001\n\u0003q\u0014!\u0004:fG>4XM]=Q_&tG/F\u0001@!\tI\u0001)\u0003\u0002B\u0015\t!Aj\u001c8h\u0011!\u0019\u0005A!a\u0001\n\u0003!\u0015!\u0005:fG>4XM]=Q_&tGo\u0018\u0013fcR\u0011\u0011'\u0012\u0005\bk\t\u000b\t\u00111\u0001@\u0011!9\u0005A!A!B\u0013y\u0014A\u0004:fG>4XM]=Q_&tG\u000f\t\u0015\u0003\rfB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IaS\u0001\ng\u000eDW\rZ;mKJ\u0004\"a\u0004'\n\u00055\u0003\"!C*dQ\u0016$W\u000f\\3s\u0011!y\u0005A!A!\u0002\u0013\u0001\u0016\u0001\u0002;j[\u0016\u0004\"aD)\n\u0005I\u0003\"\u0001\u0002+j[\u0016DQ\u0001\u0016\u0001\u0005\u0002U\u000ba\u0001P5oSRtDC\u0002,X1fS6\f\u0005\u0002,\u0001!)1d\u0015a\u0001;!)\u0001f\u0015a\u0001U!9Qh\u0015I\u0001\u0002\u0004y\u0004\"\u0002&T\u0001\u0004Y\u0005bB(T!\u0003\u0005\r\u0001\u0015\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0003\u0011awnY6\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!AY\u0011\u0002\t1\fgnZ\u0005\u0003I\u0006\u0014aa\u00142kK\u000e$\bB\u00024\u0001A\u0003%q,A\u0003m_\u000e\\\u0007\u0005C\u0004i\u0001\t\u0007I\u0011B5\u0002\u001f1\f7\u000f\u001e4mkNDW\r\u001a+j[\u0016,\u0012A\u001b\t\u0003WJl\u0011\u0001\u001c\u0006\u0003[:\fa!\u0019;p[&\u001c'BA8q\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003c\u0006\nA!\u001e;jY&\u00111\u000f\u001c\u0002\u000b\u0003R|W.[2M_:<\u0007BB;\u0001A\u0003%!.\u0001\tmCN$h\r\\;tQ\u0016$G+[7fA!)q\u000f\u0001C\u0001q\u0006a\u0011N\\5u\r&dWmU5{KR\t\u0011\u0010\u0005\u0002\nu&\u00111P\u0003\u0002\u0004\u0013:$\bbB?\u0001\u0005\u0004%IA`\u0001\tg\u0016<W.\u001a8ugV\tq\u0010\u0005\u0005\u0002\u0002\u0005\r\u0011qAA\u0006\u001b\u0005q\u0017bAA\u0003]\n12i\u001c8dkJ\u0014XM\u001c;OCZLw-\u00192mK6\u000b\u0007\u000fE\u0002a\u0003\u0013I!!Q1\u0011\u0007-\ni!C\u0002\u0002\u0010\t\u0011!\u0002T8h'\u0016<W.\u001a8u\u0011\u001d\t\u0019\u0002\u0001Q\u0001\n}\f\u0011b]3h[\u0016tGo\u001d\u0011\t\u0013\u0005]\u0001\u00011A\u0005\u0002\u0005e\u0011A\u00058fqR|eMZ:fi6+G/\u00193bi\u0006,\"!a\u0007\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t\u0005\u0003\u0019\u0019XM\u001d<fe&!\u0011QEA\u0010\u0005EaunZ(gMN,G/T3uC\u0012\fG/\u0019\u0005\n\u0003S\u0001\u0001\u0019!C\u0001\u0003W\taC\\3yi>3gm]3u\u001b\u0016$\u0018\rZ1uC~#S-\u001d\u000b\u0004c\u00055\u0002\"C\u001b\u0002(\u0005\u0005\t\u0019AA\u000e\u0011!\t\t\u0004\u0001Q!\n\u0005m\u0011a\u00058fqR|eMZ:fi6+G/\u00193bi\u0006\u0004\u0003fAA\u0018s!I\u0011q\u0007\u0001C\u0002\u0013\u0005\u0011\u0011H\u0001\u0012i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>tWCAA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!\t\u000511m\\7n_:LA!!\u0012\u0002@\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005%\u0003\u0001)A\u0005\u0003w\t!\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8oA!I\u0011Q\n\u0001C\u0002\u0013\u0005\u0011qJ\u0001\u0005i\u0006<7/\u0006\u0002\u0002RAA\u00111KA/\u0003C\n\t'\u0004\u0002\u0002V)!\u0011qKA-\u0003%IW.\\;uC\ndWMC\u0002\u0002\\)\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty&!\u0016\u0003\u00075\u000b\u0007\u000fE\u0002a\u0003GJ1!!\u001ab\u0005\u0019\u0019FO]5oO\"A\u0011\u0011\u000e\u0001!\u0002\u0013\t\t&A\u0003uC\u001e\u001c\b\u0005C\u0004\u0002n\u0001!\t!a\u001c\u0002\t9\fW.Z\u000b\u0003\u0003CBq!a\u001d\u0001\t\u0013\t)(\u0001\u0007m_\u0006$7+Z4nK:$8\u000fF\u00012\u0011\u001d\tI\b\u0001C\u0005\u0003w\n!#\u001e9eCR,Gj\\4F]\u0012|eMZ:fiR\u0019\u0011'! \t\u000f\u0005}\u0014q\u000fa\u0001\u007f\u0005iQ.Z:tC\u001e,wJ\u001a4tKRDq!a!\u0001\t\u0013\t)(\u0001\u0006sK\u000e|g/\u001a:M_\u001eDq!a\"\u0001\t\u0013\tI)\u0001\u000biCN\u001cE.Z1o'\",H\u000fZ8x]\u001aKG.\u001a\u000b\u0003\u0003\u0017\u00032!CAG\u0013\r\tyI\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+\u000b\u0001C\\;nE\u0016\u0014xJZ*fO6,g\u000e^:\u0016\u0003eDq!!'\u0001\t\u0003\t)(A\u0003dY>\u001cX\rC\u0004\u0002\u001e\u0002!\t!a(\u0002\r\u0005\u0004\b/\u001a8e)\u0019\t\t+a*\u00028B\u00191&a)\n\u0007\u0005\u0015&AA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\t\u0003S\u000bY\n1\u0001\u0002,\u0006AQ.Z:tC\u001e,7\u000f\u0005\u0003\u0002.\u0006MVBAAX\u0015\r\t\t\fB\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t),a,\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0011)\tI,a'\u0011\u0002\u0003\u0007\u00111R\u0001\u000eCN\u001c\u0018n\u001a8PM\u001a\u001cX\r^:\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\u0006a\u0012M\\1msj,\u0017I\u001c3WC2LG-\u0019;f\u001b\u0016\u001c8/Y4f'\u0016$H\u0003BAQ\u0003\u0003D\u0001\"!+\u0002<\u0002\u0007\u00111\u0016\u0005\b\u0003\u000b\u0004A\u0011BAd\u0003A!(/[7J]Z\fG.\u001b3CsR,7\u000f\u0006\u0004\u0002,\u0006%\u00171\u001a\u0005\t\u0003S\u000b\u0019\r1\u0001\u0002,\"A\u0011QZAb\u0001\u0004\t\t+\u0001\u0003j]\u001a|\u0007bBAi\u0001\u0011\u0005\u00111[\u0001\u0005e\u0016\fG\r\u0006\u0005\u0002V\u0006m\u0017q\\Ar!\u0011\ti\"a6\n\t\u0005e\u0017q\u0004\u0002\u000e\r\u0016$8\r\u001b#bi\u0006LeNZ8\t\u000f\u0005u\u0017q\u001aa\u0001\u007f\u0005Y1\u000f^1si>3gm]3u\u0011\u001d\t\t/a4A\u0002e\f\u0011\"\\1y\u0019\u0016tw\r\u001e5\t\u0015\u0005\u0015\u0018q\u001aI\u0001\u0002\u0004\t9/A\u0005nCb|eMZ:fiB!\u0011\"!;@\u0013\r\tYO\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005=\b\u0001\"\u0001\u0002r\u000692m\u001c8wKJ$Hk\\(gMN,G/T3uC\u0012\fG/\u0019\u000b\u0005\u00037\t\u0019\u0010C\u0004\u0002v\u00065\b\u0019A \u0002\r=4gm]3u\u0011\u001d\tI\u0010\u0001C\u0001\u0003w\f\u0011\u0003Z3mKR,w\n\u001c3TK\u001elWM\u001c;t)\rI\u0018Q \u0005\t\u0003\u007f\f9\u00101\u0001\u0003\u0002\u0005I\u0001O]3eS\u000e\fG/\u001a\t\b\u0013\t\r\u00111BAF\u0013\r\u0011)A\u0003\u0002\n\rVt7\r^5p]FBaA!\u0003\u0001\t\u0003q\u0014\u0001B:ju\u0016DaA!\u0004\u0001\t\u0003q\u0014A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0005#\u0001A\u0011AA\r\u0003QawnZ#oI>3gm]3u\u001b\u0016$\u0018\rZ1uC\"1!Q\u0003\u0001\u0005\u0002y\nA\u0002\\8h\u000b:$wJ\u001a4tKRDqA!\u0007\u0001\t\u0013\u0011Y\"A\u0005nCf\u0014WMU8mYR!\u00111\u0002B\u000f\u0011\u001d\u0011yBa\u0006A\u0002e\fA\"\\3tg\u0006<Wm]*ju\u0016DqAa\t\u0001\t\u0003\u0011)#\u0001\u0003s_2dGCAA\u0006\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005W\t\u0011#\u001e8gYV\u001c\b.\u001a3NKN\u001c\u0018mZ3t)\u0005y\u0004b\u0002B\u0018\u0001\u0011\u0005\u0011QO\u0001\u0006M2,8\u000f\u001b\u0005\b\u0005_\u0001A\u0011\u0001B\u001a)\r\t$Q\u0007\u0005\b\u0003k\u0014\t\u00041\u0001@\u0011!\u0011I\u0004\u0001C\u0001\u0005\u0005U\u0014A\u00023fY\u0016$X\r\u0003\u0005\u0003>\u0001!\tA\u0001B \u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0004c\t\u0005\u0003b\u0002B\"\u0005w\u0001\raP\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r\u001e\u0005\t\u0005\u000f\u0002A\u0011\u0001\u0002\u0003J\u00059BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0004c\t-\u0003b\u0002B'\u0005\u000b\u0002\raP\u0001\n]\u0016<xJ\u001a4tKRDqA!\u0015\u0001\t\u0003\u0011Y#A\u0007mCN$h\t\\;tQRKW.\u001a\u0005\b\u0005+\u0002A\u0011\u0001B,\u00035\t7\r^5wKN+w-\\3oiV\u0011\u00111\u0002\u0005\b\u00057\u0002A\u0011\u0001B/\u0003-awnZ*fO6,g\u000e^:\u0016\u0005\t}\u0003C\u0002B1\u0005c\nYA\u0004\u0003\u0003d\t5d\u0002\u0002B3\u0005Wj!Aa\u001a\u000b\u0007\t%d!\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0019!q\u000e\u0006\u0002\u000fA\f7m[1hK&!!1\u000fB;\u0005!IE/\u001a:bE2,'b\u0001B8\u0015!9!1\f\u0001\u0005\u0002\teDC\u0002B0\u0005w\u0012y\bC\u0004\u0003~\t]\u0004\u0019A \u0002\t\u0019\u0014x.\u001c\u0005\b\u0005\u0003\u00139\b1\u0001@\u0003\t!x\u000eC\u0004\u0003\u0006\u0002!\tEa\"\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0019\t\u000f\t-\u0005\u0001\"\u0003\u0003\u000e\u0006iA-\u001a7fi\u0016\u001cVmZ7f]R$2!\rBH\u0011!\u0011\tJ!#A\u0002\u0005-\u0011aB:fO6,g\u000e\u001e\u0005\b\u0005+\u0003A\u0011\u0002BL\u0003I\t7/\u001f8d\t\u0016dW\r^3TK\u001elWM\u001c;\u0015\u0007E\u0012I\n\u0003\u0005\u0003\u0012\nM\u0005\u0019AA\u0006\u0011!\u0011i\n\u0001C\u0001\u0005\t}\u0015a\u0004:fa2\f7-Z*fO6,g\u000e^:\u0015\u000fE\u0012\tK!*\u00030\"A!1\u0015BN\u0001\u0004\tY!\u0001\u0006oK^\u001cVmZ7f]RD\u0001Ba*\u0003\u001c\u0002\u0007!\u0011V\u0001\f_2$7+Z4nK:$8\u000f\u0005\u0004\u0003b\t-\u00161B\u0005\u0005\u0005[\u0013)HA\u0002TKFD!B!-\u0003\u001cB\u0005\t\u0019AAF\u0003MI7OU3d_Z,'/\u001a3To\u0006\u0004h)\u001b7f\u0011!\u0011)\f\u0001C\u0001\u0005\u0005U\u0014\u0001\u0005:f[>4X\rT8h\u001b\u0016$(/[2t\u0011\u001d\u0011I\f\u0001C\u0001\u0005w\u000b!\"\u00193e'\u0016<W.\u001a8u)\u0011\tYA!0\t\u0011\tE%q\u0017a\u0001\u0003\u0017A\u0011B!1\u0001#\u0003%\tAa1\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u0012\u0012TC\u0001BcU\u0011\tYIa2,\u0005\t%\u0007\u0003\u0002Bf\u0005+l!A!4\u000b\t\t='\u0011[\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa5\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005/\u0014iMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba7\u0001#\u0003%\tA!8\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u001c\u0016\u0005\u0003O\u00149\rC\u0005\u0003d\u0002\t\n\u0011\"\u0001\u0003D\u0006I\"/\u001a9mC\u000e,7+Z4nK:$8\u000f\n3fM\u0006,H\u000e\u001e\u00134Q\r\u0001!q\u001d\t\u0004\u001f\t%\u0018b\u0001Bv!\tQA\u000f\u001b:fC\u0012\u001c\u0018MZ3\b\u000f\t=(\u0001#\u0001\u0003r\u0006\u0019Aj\\4\u0011\u0007-\u0012\u0019P\u0002\u0004\u0002\u0005!\u0005!Q_\n\u0004\u0005gD\u0001b\u0002+\u0003t\u0012\u0005!\u0011 \u000b\u0003\u0005cD!B!@\u0003t\n\u0007I\u0011AA8\u00035aun\u001a$jY\u0016\u001cVO\u001a4jq\"I1\u0011\u0001BzA\u0003%\u0011\u0011M\u0001\u000f\u0019><g)\u001b7f'V4g-\u001b=!\u0011)\u0019)Aa=C\u0002\u0013\u0005\u0011qN\u0001\u0010\u0013:$W\r\u001f$jY\u0016\u001cVO\u001a4jq\"I1\u0011\u0002BzA\u0003%\u0011\u0011M\u0001\u0011\u0013:$W\r\u001f$jY\u0016\u001cVO\u001a4jq\u0002B!b!\u0004\u0003t\n\u0007I\u0011AA8\u0003E!U\r\\3uK\u00124\u0015\u000e\\3Tk\u001a4\u0017\u000e\u001f\u0005\n\u0007#\u0011\u0019\u0010)A\u0005\u0003C\n!\u0003R3mKR,GMR5mKN+hMZ5yA!Q1Q\u0003Bz\u0005\u0004%\t!a\u001c\u0002#\rcW-\u00198fI\u001aKG.Z*vM\u001aL\u0007\u0010C\u0005\u0004\u001a\tM\b\u0015!\u0003\u0002b\u0005\u00112\t\\3b]\u0016$g)\u001b7f'V4g-\u001b=!\u0011)\u0019iBa=C\u0002\u0013\u0005\u0011qN\u0001\u000f'^\f\u0007OR5mKN+hMZ5y\u0011%\u0019\tCa=!\u0002\u0013\t\t'A\bTo\u0006\u0004h)\u001b7f'V4g-\u001b=!\u0011)\u0019)Ca=C\u0002\u0013\u0005\u0011qN\u0001\u0012\u00072,\u0017M\\*ikR$wn\u001e8GS2,\u0007\"CB\u0015\u0005g\u0004\u000b\u0011BA1\u0003I\u0019E.Z1o'\",H\u000fZ8x]\u001aKG.\u001a\u0011\t\u0011\r5\"1\u001fC\u0001\u0007_\t\u0001DZ5mK:\fW.\u001a)sK\u001aL\u0007P\u0012:p[>3gm]3u)\u0011\u0019\td!\u0010\u0011\t\rM2\u0011\b\b\u0004\u0013\rU\u0012bAB\u001c\u0015\u00051\u0001K]3eK\u001aLA!!\u001a\u0004<)\u00191q\u0007\u0006\t\u000f\u0005U81\u0006a\u0001\u007f!A1\u0011\tBz\t\u0003\u0019\u0019%A\u0006m_\u001e4\u0015\u000e\\3oC6,G#B\u000f\u0004F\r\u001d\u0003BB\u000e\u0004@\u0001\u0007Q\u0004C\u0004\u0002v\u000e}\u0002\u0019A \t\u0011\r-#1\u001fC\u0001\u0007\u001b\nQ\"\u001b8eKb4\u0015\u000e\\3oC6,G#B\u000f\u0004P\rE\u0003BB\u000e\u0004J\u0001\u0007Q\u0004C\u0004\u0002v\u000e%\u0003\u0019A \t\u0011\rU#1\u001fC\u0001\u0007/\nq\u0003]1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3\u0015\t\u0005m2\u0011\f\u0005\u00077\rM\u0003\u0019A\u000f\t\u0011\ru#1\u001fC\u0001\u0007?\na\u0002\u001e5s_^,\u0005pY3qi&|g\u000eF\u00022\u0007CBaaGB.\u0001\u0004i\u0002BCB3\u0005g\f\n\u0011\"\u0001\u0004h\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"a!\u001b+\u0007}\u00129\r\u0003\u0006\u0004n\tM\u0018\u0013!C\u0001\u0007_\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAB9U\r\u0001&q\u0019")
public class Log
implements KafkaMetricsGroup {
    private final File dir;
    private volatile LogConfig config;
    private volatile long recoveryPoint;
    private final Scheduler scheduler;
    public final Time kafka$log$Log$$time;
    private final Object lock;
    private final AtomicLong lastflushedTime;
    private final ConcurrentNavigableMap<Long, LogSegment> kafka$log$Log$$segments;
    private volatile LogOffsetMetadata nextOffsetMetadata;
    private final TopicAndPartition topicAndPartition;
    private final scala.collection.immutable.Map<String, String> tags;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Log$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$3() {
        return Log$.MODULE$.$lessinit$greater$default$3();
    }

    public static void throwException(File file) {
        Log$.MODULE$.throwException(file);
    }

    public static TopicAndPartition parseTopicPartitionName(File file) {
        return Log$.MODULE$.parseTopicPartitionName(file);
    }

    public static File indexFilename(File file, long l) {
        return Log$.MODULE$.indexFilename(file, l);
    }

    public static File logFilename(File file, long l) {
        return Log$.MODULE$.logFilename(file, l);
    }

    public static String filenamePrefixFromOffset(long l) {
        return Log$.MODULE$.filenamePrefixFromOffset(l);
    }

    public static String CleanShutdownFile() {
        return Log$.MODULE$.CleanShutdownFile();
    }

    public static String SwapFileSuffix() {
        return Log$.MODULE$.SwapFileSuffix();
    }

    public static String CleanedFileSuffix() {
        return Log$.MODULE$.CleanedFileSuffix();
    }

    public static String DeletedFileSuffix() {
        return Log$.MODULE$.DeletedFileSuffix();
    }

    public static String IndexFileSuffix() {
        return Log$.MODULE$.IndexFileSuffix();
    }

    public static String LogFileSuffix() {
        return Log$.MODULE$.LogFileSuffix();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Log log = this;
        synchronized (log) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File dir() {
        return this.dir;
    }

    public LogConfig config() {
        return this.config;
    }

    public void config_$eq(LogConfig x$1) {
        this.config = x$1;
    }

    public long recoveryPoint() {
        return this.recoveryPoint;
    }

    public void recoveryPoint_$eq(long x$1) {
        this.recoveryPoint = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private AtomicLong lastflushedTime() {
        return this.lastflushedTime;
    }

    public int initFileSize() {
        return Predef$.MODULE$.Boolean2boolean(this.config().preallocate()) ? Predef$.MODULE$.Integer2int(this.config().segmentSize()) : 0;
    }

    public ConcurrentNavigableMap<Long, LogSegment> kafka$log$Log$$segments() {
        return this.kafka$log$Log$$segments;
    }

    public LogOffsetMetadata nextOffsetMetadata() {
        return this.nextOffsetMetadata;
    }

    public void nextOffsetMetadata_$eq(LogOffsetMetadata x$1) {
        this.nextOffsetMetadata = x$1;
    }

    public TopicAndPartition topicAndPartition() {
        return this.topicAndPartition;
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    public String name() {
        return this.dir().getName();
    }

    private void loadSegments() {
        this.dir().mkdirs();
        ObjectRef swapFiles = new ObjectRef((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.isFile();
            }
        }).foreach((Function1)new Serializable(this, swapFiles){
            public static final long serialVersionUID = 0L;
            private final ObjectRef swapFiles$1;

            public final Object apply(File file) {
                if (file.canRead()) {
                    Boolean bl;
                    String filename = file.getName();
                    if (filename.endsWith(Log$.MODULE$.DeletedFileSuffix()) || filename.endsWith(Log$.MODULE$.CleanedFileSuffix())) {
                        bl = BoxesRunTime.boxToBoolean((boolean)file.delete());
                    } else if (filename.endsWith(Log$.MODULE$.SwapFileSuffix())) {
                        File baseName = new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.SwapFileSuffix(), ""));
                        if (baseName.getPath().endsWith(Log$.MODULE$.IndexFileSuffix())) {
                            bl = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        } else if (baseName.getPath().endsWith(Log$.MODULE$.LogFileSuffix())) {
                            File index = new File(CoreUtils$.MODULE$.replaceSuffix(baseName.getPath(), Log$.MODULE$.LogFileSuffix(), Log$.MODULE$.IndexFileSuffix()));
                            index.delete();
                            this.swapFiles$1.elem = (Set)((Set)this.swapFiles$1.elem).$plus((Object)file);
                            bl = BoxedUnit.UNIT;
                        } else {
                            bl = BoxedUnit.UNIT;
                        }
                    } else {
                        bl = BoxedUnit.UNIT;
                    }
                    return bl;
                }
                throw new IOException(new StringBuilder().append((Object)"Could not read file ").append((Object)file).toString());
            }
            {
                this.swapFiles$1 = swapFiles$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.isFile();
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(File file) {
                Object object;
                Object object2;
                String filename = file.getName();
                if (filename.endsWith(Log$.MODULE$.IndexFileSuffix())) {
                    File logFile = new File(file.getAbsolutePath().replace(Log$.MODULE$.IndexFileSuffix(), Log$.MODULE$.LogFileSuffix()));
                    if (logFile.exists()) {
                        object2 = BoxedUnit.UNIT;
                        return object2;
                    }
                    this.$outer.warn((Function0<String>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final File file$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Found an orphaned index file, %s, with no corresponding log file.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1.getAbsolutePath()}));
                        }
                        {
                            this.file$1 = file$1;
                        }
                    });
                    object2 = BoxesRunTime.boxToBoolean((boolean)file.delete());
                    return object2;
                }
                if (!filename.endsWith(Log$.MODULE$.LogFileSuffix())) {
                    object2 = BoxedUnit.UNIT;
                    return object2;
                }
                long start2 = new StringOps(Predef$.MODULE$.augmentString(filename.substring(0, filename.length() - Log$.MODULE$.LogFileSuffix().length()))).toLong();
                File indexFile = Log$.MODULE$.indexFilename(this.$outer.dir(), start2);
                LogSegment segment = new LogSegment(this.$outer.dir(), start2, Predef$.MODULE$.Integer2int(this.$outer.config().indexInterval()), Predef$.MODULE$.Integer2int(this.$outer.config().maxIndexSize()), this.$outer.config().randomSegmentJitter(), this.$outer.kafka$log$Log$$time, true, LogSegment$.MODULE$.$lessinit$greater$default$8(), LogSegment$.MODULE$.$lessinit$greater$default$9());
                if (indexFile.exists()) {
                    try {
                        segment.index().sanityCheck();
                        object = BoxedUnit.UNIT;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.$outer.warn((Function0<String>)new Serializable(this, indexFile){
                            public static final long serialVersionUID = 0L;
                            private final File indexFile$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Found a corrupted index file, %s, deleting and rebuilding index...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.indexFile$1.getAbsolutePath()}));
                            }
                            {
                                this.indexFile$1 = indexFile$1;
                            }
                        });
                        segment.deleteIndex();
                        indexFile.delete();
                        object = BoxesRunTime.boxToInteger((int)segment.recover(Predef$.MODULE$.Integer2int(this.$outer.config().maxMessageSize())));
                    }
                } else {
                    this.$outer.error((Function0<String>)new Serializable(this, segment){
                        public static final long serialVersionUID = 0L;
                        private final LogSegment segment$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Could not find index file corresponding to log file %s, rebuilding index...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.segment$1.log().file().getAbsolutePath()}));
                        }
                        {
                            this.segment$1 = segment$1;
                        }
                    });
                    object = BoxesRunTime.boxToInteger((int)segment.recover(Predef$.MODULE$.Integer2int(this.$outer.config().maxMessageSize())));
                }
                object2 = this.$outer.kafka$log$Log$$segments().put(Predef$.MODULE$.long2Long(start2), segment);
                return object2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        ((Set)swapFiles.elem).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;

            public final void apply(File swapFile) {
                File logFile = new File(CoreUtils$.MODULE$.replaceSuffix(swapFile.getPath(), Log$.MODULE$.SwapFileSuffix(), ""));
                String fileName = logFile.getName();
                long startOffset = new StringOps(Predef$.MODULE$.augmentString(fileName.substring(0, fileName.length() - Log$.MODULE$.LogFileSuffix().length()))).toLong();
                File indexFile = new File(new StringBuilder().append((Object)CoreUtils$.MODULE$.replaceSuffix(logFile.getPath(), Log$.MODULE$.LogFileSuffix(), Log$.MODULE$.IndexFileSuffix())).append((Object)Log$.MODULE$.SwapFileSuffix()).toString());
                OffsetIndex index = new OffsetIndex(indexFile, startOffset, Predef$.MODULE$.Integer2int(this.$outer.config().maxIndexSize()));
                LogSegment swapSegment = new LogSegment(new FileMessageSet(swapFile), index, startOffset, Predef$.MODULE$.Integer2int(this.$outer.config().indexInterval()), this.$outer.config().randomSegmentJitter(), this.$outer.kafka$log$Log$$time);
                this.$outer.info((Function0<String>)new Serializable(this, swapFile){
                    public static final long serialVersionUID = 0L;
                    private final File swapFile$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Found log file %s from interrupted swap operation, repairing.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.swapFile$1.getPath()}));
                    }
                    {
                        this.swapFile$1 = swapFile$1;
                    }
                });
                swapSegment.recover(Predef$.MODULE$.Integer2int(this.$outer.config().maxMessageSize()));
                Iterable<LogSegment> oldSegments = this.$outer.logSegments(swapSegment.baseOffset(), swapSegment.nextOffset());
                this.$outer.replaceSegments(swapSegment, (Seq<LogSegment>)oldSegments.toSeq(), true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (this.logSegments().size() == 0) {
            this.kafka$log$Log$$segments().put(Predef$.MODULE$.long2Long(0L), new LogSegment(this.dir(), 0L, Predef$.MODULE$.Integer2int(this.config().indexInterval()), Predef$.MODULE$.Integer2int(this.config().maxIndexSize()), this.config().randomSegmentJitter(), this.kafka$log$Log$$time, false, this.initFileSize(), Predef$.MODULE$.Boolean2boolean(this.config().preallocate())));
        } else {
            this.recoverLog();
            this.activeSegment().index().resize(Predef$.MODULE$.Integer2int(this.config().maxIndexSize()));
        }
    }

    private void updateLogEndOffset(long messageOffset) {
        this.nextOffsetMetadata_$eq(new LogOffsetMetadata(messageOffset, this.activeSegment().baseOffset(), (int)this.activeSegment().size()));
    }

    /*
     * Exception decompiling
     */
    private void recoverLog() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 133->154)] kafka.common.InvalidOffsetException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean hasCleanShutdownFile() {
        return new File(this.dir().getParentFile(), Log$.MODULE$.CleanShutdownFile()).exists();
    }

    public int numberOfSegments() {
        return this.kafka$log$Log$$segments().size();
    }

    public void close() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Closing log ").append((Object)this.$outer.name()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Object object = this.lock();
        synchronized (object) {
            this.logSegments().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(LogSegment seg) {
                    seg.close();
                }
            });
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LogAppendInfo append(ByteBufferMessageSet messages, boolean assignOffsets) {
        LogAppendInfo appendInfo = this.analyzeAndValidateMessageSet(messages);
        if (appendInfo.shallowCount() == 0) {
            return appendInfo;
        }
        ObjectRef validMessages = new ObjectRef((Object)this.trimInvalidBytes(messages, appendInfo));
        try {
            Object object = this.lock();
            synchronized (object) {
                block12: {
                    if (assignOffsets) {
                        Tuple2 tuple2;
                        kafka.common.LongRef offset = new kafka.common.LongRef(this.nextOffsetMetadata().messageOffset());
                        appendInfo.firstOffset_$eq(offset.value());
                        long now = this.kafka$log$Log$$time.milliseconds();
                        Tuple2 tuple22 = this.liftedTree1$1(appendInfo, validMessages, offset, now);
                        if (tuple22 == null) throw new MatchError((Object)tuple22);
                        ByteBufferMessageSet validatedMessages = (ByteBufferMessageSet)tuple22._1();
                        boolean messageSizesMaybeChanged = tuple22._2$mcZ$sp();
                        Tuple2 tuple23 = tuple2 = new Tuple2((Object)validatedMessages, (Object)BoxesRunTime.boxToBoolean((boolean)messageSizesMaybeChanged));
                        ByteBufferMessageSet validatedMessages2 = (ByteBufferMessageSet)tuple23._1();
                        boolean messageSizesMaybeChanged2 = tuple23._2$mcZ$sp();
                        validMessages.elem = validatedMessages2;
                        appendInfo.lastOffset_$eq(offset.value() - 1L);
                        TimestampType timestampType2 = this.config().messageTimestampType();
                        TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
                        if (!(timestampType2 != null ? !((Object)((Object)timestampType2)).equals((Object)timestampType3) : timestampType3 != null)) {
                            appendInfo.timestamp_$eq(now);
                        }
                        if (messageSizesMaybeChanged2) {
                            ((ByteBufferMessageSet)validMessages.elem).shallowIterator().foreach((Function1)new Serializable(this, messages){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Log $outer;
                                private final ByteBufferMessageSet messages$1;

                                public final void apply(MessageAndOffset messageAndOffset) {
                                    if (MessageSet$.MODULE$.entrySize(messageAndOffset.message()) > Predef$.MODULE$.Integer2int(this.$outer.config().maxMessageSize())) {
                                        BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.$outer.topicAndPartition().topic()).bytesRejectedRate().mark(this.messages$1.sizeInBytes());
                                        BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesRejectedRate().mark(this.messages$1.sizeInBytes());
                                        throw new RecordTooLargeException(new StringOps(Predef$.MODULE$.augmentString("Message size is %d bytes which exceeds the maximum configured message size of %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)MessageSet$.MODULE$.entrySize(messageAndOffset.message())), this.$outer.config().maxMessageSize()})));
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.messages$1 = messages$1;
                                }
                            });
                        }
                    } else if (!appendInfo.offsetsMonotonic() || appendInfo.firstOffset() < this.nextOffsetMetadata().messageOffset()) break block12;
                    if (((ByteBufferMessageSet)validMessages.elem).sizeInBytes() > Predef$.MODULE$.Integer2int(this.config().segmentSize())) {
                        throw new RecordBatchTooLargeException(new StringOps(Predef$.MODULE$.augmentString("Message set size is %d bytes which exceeds the maximum configured segment size of %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((ByteBufferMessageSet)validMessages.elem).sizeInBytes()), this.config().segmentSize()})));
                    }
                    LogSegment segment = this.maybeRoll(((ByteBufferMessageSet)validMessages.elem).sizeInBytes());
                    segment.append(appendInfo.firstOffset(), (ByteBufferMessageSet)validMessages.elem);
                    this.updateLogEndOffset(appendInfo.lastOffset() + 1L);
                    this.trace((Function0<String>)new Serializable(this, appendInfo, validMessages){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Log $outer;
                        private final LogAppendInfo appendInfo$1;
                        private final ObjectRef validMessages$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Appended message set to log %s with first offset: %d, next offset: %d, and messages: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToLong((long)this.appendInfo$1.firstOffset()), BoxesRunTime.boxToLong((long)this.$outer.nextOffsetMetadata().messageOffset()), (ByteBufferMessageSet)this.validMessages$1.elem}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.appendInfo$1 = appendInfo$1;
                            this.validMessages$1 = validMessages$1;
                        }
                    });
                    if (this.unflushedMessages() < Predef$.MODULE$.Long2long(this.config().flushInterval())) return appendInfo;
                    this.flush();
                    return appendInfo;
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Out of order offsets found in ").append((Object)messages).toString());
            }
        }
        catch (IOException iOException) {
            throw new KafkaStorageException(new StringOps(Predef$.MODULE$.augmentString("I/O exception in append to log '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})), iOException);
        }
    }

    public boolean append$default$2() {
        return true;
    }

    private LogAppendInfo analyzeAndValidateMessageSet(ByteBufferMessageSet messages) {
        IntRef shallowMessageCount = new IntRef(0);
        IntRef validBytesCount = new IntRef(0);
        LongRef firstOffset = new LongRef(-1L);
        LongRef lastOffset = new LongRef(-1L);
        ObjectRef sourceCodec = new ObjectRef((Object)NoCompressionCodec$.MODULE$);
        BooleanRef monotonic = new BooleanRef(true);
        messages.shallowIterator().foreach((Function1)new Serializable(this, messages, shallowMessageCount, validBytesCount, firstOffset, lastOffset, sourceCodec, monotonic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final ByteBufferMessageSet messages$2;
            private final IntRef shallowMessageCount$1;
            private final IntRef validBytesCount$1;
            private final LongRef firstOffset$1;
            private final LongRef lastOffset$1;
            private final ObjectRef sourceCodec$1;
            private final BooleanRef monotonic$1;

            public final void apply(MessageAndOffset messageAndOffset) {
                CompressionCodec messageCodec;
                if (this.firstOffset$1.elem < 0L) {
                    this.firstOffset$1.elem = messageAndOffset.offset();
                }
                if (this.lastOffset$1.elem >= messageAndOffset.offset()) {
                    this.monotonic$1.elem = false;
                }
                this.lastOffset$1.elem = messageAndOffset.offset();
                Message m = messageAndOffset.message();
                int messageSize = MessageSet$.MODULE$.entrySize(m);
                if (messageSize > Predef$.MODULE$.Integer2int(this.$outer.config().maxMessageSize())) {
                    BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.$outer.topicAndPartition().topic()).bytesRejectedRate().mark(this.messages$2.sizeInBytes());
                    BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesRejectedRate().mark(this.messages$2.sizeInBytes());
                    throw new RecordTooLargeException(new StringOps(Predef$.MODULE$.augmentString("Message size is %d bytes which exceeds the maximum configured message size of %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messageSize), this.$outer.config().maxMessageSize()})));
                }
                m.ensureValid();
                ++this.shallowMessageCount$1.elem;
                this.validBytesCount$1.elem += messageSize;
                CompressionCodec compressionCodec = messageCodec = m.compressionCodec();
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                if (compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$)) {
                    this.sourceCodec$1.elem = messageCodec;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messages$2 = messages$2;
                this.shallowMessageCount$1 = shallowMessageCount$1;
                this.validBytesCount$1 = validBytesCount$1;
                this.firstOffset$1 = firstOffset$1;
                this.lastOffset$1 = lastOffset$1;
                this.sourceCodec$1 = sourceCodec$1;
                this.monotonic$1 = monotonic$1;
            }
        });
        CompressionCodec targetCodec = BrokerCompressionCodec$.MODULE$.getTargetCompressionCodec(this.config().compressionType(), (CompressionCodec)sourceCodec.elem);
        return new LogAppendInfo(firstOffset.elem, lastOffset.elem, Message$.MODULE$.NoTimestamp(), (CompressionCodec)sourceCodec.elem, targetCodec, shallowMessageCount.elem, validBytesCount.elem, monotonic.elem);
    }

    private ByteBufferMessageSet trimInvalidBytes(ByteBufferMessageSet messages, LogAppendInfo info) {
        ByteBufferMessageSet byteBufferMessageSet;
        int messageSetValidBytes = info.validBytes();
        if (messageSetValidBytes < 0) {
            throw new CorruptRecordException(new StringBuilder().append((Object)"Illegal length of message set ").append((Object)BoxesRunTime.boxToInteger((int)messageSetValidBytes)).append((Object)" Message set cannot be appended to log. Possible causes are corrupted produce requests").toString());
        }
        if (messageSetValidBytes == messages.sizeInBytes()) {
            byteBufferMessageSet = messages;
        } else {
            ByteBuffer validByteBuffer = messages.buffer().duplicate();
            validByteBuffer.limit(messageSetValidBytes);
            byteBufferMessageSet = new ByteBufferMessageSet(validByteBuffer);
        }
        return byteBufferMessageSet;
    }

    public FetchDataInfo read(long startOffset, int maxLength, Option<Object> maxOffset) {
        FetchDataInfo fetchInfo;
        this.trace((Function0<String>)new Serializable(this, startOffset, maxLength){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final long startOffset$1;
            private final int maxLength$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Reading %d bytes from offset %d in log %s of length %d bytes")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxLength$1), BoxesRunTime.boxToLong((long)this.startOffset$1), this.$outer.name(), BoxesRunTime.boxToLong((long)this.$outer.size())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.startOffset$1 = startOffset$1;
                this.maxLength$1 = maxLength$1;
            }
        });
        LogOffsetMetadata currentNextOffsetMetadata = this.nextOffsetMetadata();
        long next2 = currentNextOffsetMetadata.messageOffset();
        if (startOffset == next2) {
            return new FetchDataInfo(currentNextOffsetMetadata, MessageSet$.MODULE$.Empty());
        }
        Map.Entry entry2 = this.kafka$log$Log$$segments().floorEntry(Predef$.MODULE$.long2Long(startOffset));
        if (startOffset > next2 || entry2 == null) {
            throw new OffsetOutOfRangeException(new StringOps(Predef$.MODULE$.augmentString("Request for offset %d but we only have log segments in the range %d to %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startOffset), this.kafka$log$Log$$segments().firstKey(), BoxesRunTime.boxToLong((long)next2)})));
        }
        while (true) {
            long l;
            Map.Entry entry3;
            if (entry2 == null) {
                return new FetchDataInfo(this.nextOffsetMetadata(), MessageSet$.MODULE$.Empty());
            }
            void v0 = entry3;
            Map.Entry entry4 = this.kafka$log$Log$$segments().lastEntry();
            if (!(v0 != null ? !v0.equals(entry4) : entry4 != null)) {
                long exposedPos = this.nextOffsetMetadata().relativePositionInSegment();
                void v1 = entry3;
                Map.Entry entry5 = this.kafka$log$Log$$segments().lastEntry();
                l = !(v1 != null ? !v1.equals(entry5) : entry5 != null) ? exposedPos : ((LogSegment)entry3.getValue()).size();
            } else {
                l = ((LogSegment)entry3.getValue()).size();
            }
            long maxPosition = l;
            fetchInfo = ((LogSegment)entry3.getValue()).read(startOffset, maxOffset, maxLength, maxPosition);
            if (fetchInfo != null) break;
            entry3 = this.kafka$log$Log$$segments().higherEntry((Long)entry3.getKey());
        }
        return fetchInfo;
    }

    public Option<Object> read$default$3() {
        return None$.MODULE$;
    }

    public LogOffsetMetadata convertToOffsetMetadata(long offset) {
        LogOffsetMetadata logOffsetMetadata;
        try {
            FetchDataInfo fetchDataInfo = this.read(offset, 1, this.read$default$3());
            logOffsetMetadata = fetchDataInfo.fetchOffsetMetadata();
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            logOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        }
        return logOffsetMetadata;
    }

    public int deleteOldSegments(Function1<LogSegment, Object> predicate) {
        Object object = this.lock();
        synchronized (object) {
            Map.Entry lastEntry = this.kafka$log$Log$$segments().lastEntry();
            Iterable deletable = lastEntry == null ? (Iterable)Seq$.MODULE$.empty() : (Iterable)this.logSegments().takeWhile((Function1)new Serializable(this, predicate, lastEntry){
                public static final long serialVersionUID = 0L;
                private final Function1 predicate$1;
                private final Map.Entry lastEntry$1;

                public final boolean apply(LogSegment s) {
                    return BoxesRunTime.unboxToBoolean((Object)this.predicate$1.apply((Object)s)) && (s.baseOffset() != ((LogSegment)this.lastEntry$1.getValue()).baseOffset() || s.size() > 0L);
                }
                {
                    this.predicate$1 = predicate$1;
                    this.lastEntry$1 = lastEntry$1;
                }
            });
            int numToDelete = deletable.size();
            if (numToDelete > 0) {
                Object object2 = this.kafka$log$Log$$segments().size() == numToDelete ? this.roll() : BoxedUnit.UNIT;
                deletable.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Log $outer;

                    public final void apply(LogSegment x$2) {
                        this.$outer.kafka$log$Log$$deleteSegment(x$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            Integer n = BoxesRunTime.boxToInteger((int)numToDelete);
            return BoxesRunTime.unboxToInt((Object)n);
        }
    }

    public long size() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$3) {
                return x$3.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long logStartOffset() {
        return ((LogSegment)this.logSegments().head()).baseOffset();
    }

    public LogOffsetMetadata logEndOffsetMetadata() {
        return this.nextOffsetMetadata();
    }

    public long logEndOffset() {
        return this.nextOffsetMetadata().messageOffset();
    }

    private LogSegment maybeRoll(int messagesSize) {
        LogSegment logSegment;
        LogSegment segment = this.activeSegment();
        if (segment.size() > (long)(Predef$.MODULE$.Integer2int(this.config().segmentSize()) - messagesSize) || segment.size() > 0L && this.kafka$log$Log$$time.milliseconds() - segment.created() > Predef$.MODULE$.Long2long(this.config().segmentMs()) - segment.rollJitterMs() || segment.index().isFull()) {
            this.debug((Function0<String>)new Serializable(this, segment){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Log $outer;
                private final LogSegment segment$3;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Rolling new log segment in %s (log_size = %d/%d, index_size = %d/%d, age_ms = %d/%d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToLong((long)this.segment$3.size()), this.$outer.config().segmentSize(), BoxesRunTime.boxToInteger((int)this.segment$3.index().entries()), BoxesRunTime.boxToInteger((int)this.segment$3.index().maxEntries()), BoxesRunTime.boxToLong((long)(this.$outer.kafka$log$Log$$time.milliseconds() - this.segment$3.created())), BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(this.$outer.config().segmentMs()) - this.segment$3.rollJitterMs()))}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.segment$3 = segment$3;
                }
            });
            logSegment = this.roll();
        } else {
            logSegment = segment;
        }
        return logSegment;
    }

    /*
     * WARNING - void declaration
     */
    public LogSegment roll() {
        long start2 = this.kafka$log$Log$$time.nanoseconds();
        Object object = this.lock();
        synchronized (object) {
            void var4_3;
            block6: {
                long newOffset = this.logEndOffset();
                File logFile = Log$.MODULE$.logFilename(this.dir(), newOffset);
                File indexFile = Log$.MODULE$.indexFilename(this.dir(), newOffset);
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{logFile, indexFile})).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File file) {
                        return file.exists();
                    }
                }).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Log $outer;

                    public final boolean apply(File file) {
                        this.$outer.warn((Function0<String>)new Serializable(this, file){
                            public static final long serialVersionUID = 0L;
                            private final File file$2;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Newly rolled segment file ").append((Object)this.file$2.getName()).append((Object)" already exists; deleting it first").toString();
                            }
                            {
                                this.file$2 = file$2;
                            }
                        });
                        return file.delete();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Map.Entry entry2 = this.kafka$log$Log$$segments().lastEntry();
                if (entry2 == null) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    ((LogSegment)entry2.getValue()).index().trimToValidSize();
                    ((LogSegment)entry2.getValue()).log().trim();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                LogSegment segment = new LogSegment(this.dir(), newOffset, Predef$.MODULE$.Integer2int(this.config().indexInterval()), Predef$.MODULE$.Integer2int(this.config().maxIndexSize()), this.config().randomSegmentJitter(), this.kafka$log$Log$$time, false, this.initFileSize(), Predef$.MODULE$.Boolean2boolean(this.config().preallocate()));
                LogSegment prev = this.addSegment(segment);
                if (prev != null) break block6;
                this.updateLogEndOffset(this.nextOffsetMetadata().messageOffset());
                this.scheduler.schedule("flush-log", (Function0<BoxedUnit>)new Serializable(this, newOffset){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Log $outer;
                    private final long newOffset$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.flush(this.newOffset$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.newOffset$1 = newOffset$1;
                    }
                }, 0L, this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
                this.info((Function0<String>)new Serializable(this, start2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Log $outer;
                    private final long start$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Rolled new log segment for '").append((Object)this.$outer.name()).append((Object)new StringOps(Predef$.MODULE$.augmentString("' in %.0f ms.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)(System.nanoTime() - this.start$1) / 1000000.0))}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.start$1 = start$1;
                    }
                });
                LogSegment logSegment = segment;
                return logSegment;
            }
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Trying to roll a new log segment for topic partition %s with start offset %d while it already exists.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToLong((long)var4_3)})));
        }
    }

    public long unflushedMessages() {
        return this.logEndOffset() - this.recoveryPoint();
    }

    public void flush() {
        this.flush(this.logEndOffset());
    }

    public void flush(long offset) {
        if (offset <= this.recoveryPoint()) {
            return;
        }
        this.debug((Function0<String>)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final long offset$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Flushing log '").append((Object)this.$outer.name()).append((Object)" up to offset ").append((Object)BoxesRunTime.boxToLong((long)this.offset$2)).append((Object)", last flushed: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.lastFlushTime())).append((Object)" current time: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$log$Log$$time.milliseconds())).append((Object)" unflushed = ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.unflushedMessages())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
        this.logSegments(this.recoveryPoint(), offset).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogSegment segment) {
                segment.flush();
            }
        });
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (offset > this.recoveryPoint()) {
                this.recoveryPoint_$eq(offset);
                this.lastflushedTime().set(this.kafka$log$Log$$time.milliseconds());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void delete() {
        Object object = this.lock();
        synchronized (object) {
            this.removeLogMetrics();
            this.logSegments().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(LogSegment x$4) {
                    x$4.delete();
                }
            });
            this.kafka$log$Log$$segments().clear();
            Utils.delete(this.dir());
            return;
        }
    }

    public void truncateTo(long targetOffset) {
        this.info((Function0<String>)new Serializable(this, targetOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final long targetOffset$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Truncating log %s to offset %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToLong((long)this.targetOffset$1)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.targetOffset$1 = targetOffset$1;
            }
        });
        if (targetOffset < 0L) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Cannot truncate to a negative offset (%d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)targetOffset)})));
        }
        if (targetOffset > this.logEndOffset()) {
            this.info((Function0<String>)new Serializable(this, targetOffset){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Log $outer;
                private final long targetOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Truncating %s to %d has no effect as the largest offset in the log is %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToLong((long)this.targetOffset$1), BoxesRunTime.boxToLong((long)(this.$outer.logEndOffset() - 1L))}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.targetOffset$1 = targetOffset$1;
                }
            });
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (((LogSegment)this.kafka$log$Log$$segments().firstEntry().getValue()).baseOffset() > targetOffset) {
                this.truncateFullyAndStartAt(targetOffset);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Iterable deletable = (Iterable)this.logSegments().filter((Function1)new Serializable(this, targetOffset){
                    public static final long serialVersionUID = 0L;
                    private final long targetOffset$1;

                    public final boolean apply(LogSegment segment) {
                        return segment.baseOffset() > this.targetOffset$1;
                    }
                    {
                        this.targetOffset$1 = targetOffset$1;
                    }
                });
                deletable.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Log $outer;

                    public final void apply(LogSegment x$5) {
                        this.$outer.kafka$log$Log$$deleteSegment(x$5);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.activeSegment().truncateTo(targetOffset);
                this.updateLogEndOffset(targetOffset);
                this.recoveryPoint_$eq(package$.MODULE$.min(targetOffset, this.recoveryPoint()));
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void truncateFullyAndStartAt(long newOffset) {
        this.debug((Function0<String>)new Serializable(this, newOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final long newOffset$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Truncate and start log '").append((Object)this.$outer.name()).append((Object)"' to ").append((Object)BoxesRunTime.boxToLong((long)this.newOffset$2)).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newOffset$2 = newOffset$2;
            }
        });
        Object object = this.lock();
        synchronized (object) {
            List segmentsToDelete = this.logSegments().toList();
            segmentsToDelete.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Log $outer;

                public final void apply(LogSegment x$6) {
                    this.$outer.kafka$log$Log$$deleteSegment(x$6);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.addSegment(new LogSegment(this.dir(), newOffset, Predef$.MODULE$.Integer2int(this.config().indexInterval()), Predef$.MODULE$.Integer2int(this.config().maxIndexSize()), this.config().randomSegmentJitter(), this.kafka$log$Log$$time, false, this.initFileSize(), Predef$.MODULE$.Boolean2boolean(this.config().preallocate())));
            this.updateLogEndOffset(newOffset);
            this.recoveryPoint_$eq(package$.MODULE$.min(newOffset, this.recoveryPoint()));
            return;
        }
    }

    public long lastFlushTime() {
        return this.lastflushedTime().get();
    }

    public LogSegment activeSegment() {
        return (LogSegment)this.kafka$log$Log$$segments().lastEntry().getValue();
    }

    public Iterable<LogSegment> logSegments() {
        return JavaConversions$.MODULE$.collectionAsScalaIterable(this.kafka$log$Log$$segments().values());
    }

    public Iterable<LogSegment> logSegments(long from, long to) {
        Object object = this.lock();
        synchronized (object) {
            Long floor = this.kafka$log$Log$$segments().floorKey(Predef$.MODULE$.long2Long(from));
            Iterable iterable = floor == null ? JavaConversions$.MODULE$.collectionAsScalaIterable(this.kafka$log$Log$$segments().headMap((Object)Predef$.MODULE$.long2Long(to)).values()) : JavaConversions$.MODULE$.collectionAsScalaIterable(this.kafka$log$Log$$segments().subMap((Object)floor, true, (Object)Predef$.MODULE$.long2Long(to), false).values());
            return iterable;
        }
    }

    public String toString() {
        return new StringBuilder().append((Object)"Log(").append((Object)this.dir()).append((Object)")").toString();
    }

    public void kafka$log$Log$$deleteSegment(LogSegment segment) {
        this.info((Function0<String>)new Serializable(this, segment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final LogSegment segment$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Scheduling log segment %d for log %s for deletion.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.segment$2.baseOffset()), this.$outer.name()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.segment$2 = segment$2;
            }
        });
        Object object = this.lock();
        synchronized (object) {
            this.kafka$log$Log$$segments().remove(BoxesRunTime.boxToLong((long)segment.baseOffset()));
            this.kafka$log$Log$$asyncDeleteSegment(segment);
            return;
        }
    }

    public void kafka$log$Log$$asyncDeleteSegment(LogSegment segment) {
        segment.changeFileSuffixes("", Log$.MODULE$.DeletedFileSuffix());
        this.scheduler.schedule("delete-file", (Function0<BoxedUnit>)new Serializable(this, segment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final LogSegment segment$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$Log$$deleteSeg$1(this.segment$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.segment$4 = segment$4;
            }
        }, Predef$.MODULE$.Long2long(this.config().fileDeleteDelayMs()), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void replaceSegments(LogSegment newSegment, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile) {
        Object object = this.lock();
        synchronized (object) {
            if (!isRecoveredSwapFile) {
                newSegment.changeFileSuffixes(Log$.MODULE$.CleanedFileSuffix(), Log$.MODULE$.SwapFileSuffix());
            }
            this.addSegment(newSegment);
            oldSegments.foreach((Function1)new Serializable(this, newSegment){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Log $outer;
                private final LogSegment newSegment$1;

                public final void apply(LogSegment seg) {
                    Object object = seg.baseOffset() != this.newSegment$1.baseOffset() ? this.$outer.kafka$log$Log$$segments().remove(BoxesRunTime.boxToLong((long)seg.baseOffset())) : BoxedUnit.UNIT;
                    this.$outer.kafka$log$Log$$asyncDeleteSegment(seg);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.newSegment$1 = newSegment$1;
                }
            });
            newSegment.changeFileSuffixes(Log$.MODULE$.SwapFileSuffix(), "");
            return;
        }
    }

    public boolean replaceSegments$default$3() {
        return false;
    }

    public void removeLogMetrics() {
        this.removeMetric("NumLogSegments", (Map<String, String>)this.tags());
        this.removeMetric("LogStartOffset", (Map<String, String>)this.tags());
        this.removeMetric("LogEndOffset", (Map<String, String>)this.tags());
        this.removeMetric("Size", (Map<String, String>)this.tags());
    }

    public LogSegment addSegment(LogSegment segment) {
        return this.kafka$log$Log$$segments().put(Predef$.MODULE$.long2Long(segment.baseOffset()), segment);
    }

    private final Tuple2 liftedTree1$1(LogAppendInfo appendInfo$1, ObjectRef validMessages$1, kafka.common.LongRef offset$1, long now$1) {
        try {
            return ((ByteBufferMessageSet)validMessages$1.elem).validateMessagesAndAssignOffsets(offset$1, now$1, appendInfo$1.sourceCodec(), appendInfo$1.targetCodec(), this.config().compact(), this.config().messageFormatVersion().messageFormatVersion(), this.config().messageTimestampType(), this.config().messageTimestampDifferenceMaxMs());
        }
        catch (IOException iOException) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Error in validating messages while appending to log '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})), iOException);
        }
    }

    public final void kafka$log$Log$$deleteSeg$1(LogSegment segment$4) {
        this.info((Function0<String>)new Serializable(this, segment$4){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;
            private final LogSegment segment$4;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Deleting segment %d from log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.segment$4.baseOffset()), this.$outer.name()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.segment$4 = segment$4;
            }
        });
        segment$4.delete();
    }

    public Log(File dir, LogConfig config, long recoveryPoint, Scheduler scheduler, Time time) {
        this.dir = dir;
        this.config = config;
        this.recoveryPoint = recoveryPoint;
        this.scheduler = scheduler;
        this.kafka$log$Log$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.lock = new Object();
        this.lastflushedTime = new AtomicLong(time.milliseconds());
        this.kafka$log$Log$$segments = new ConcurrentSkipListMap<Long, LogSegment>();
        this.loadSegments();
        this.nextOffsetMetadata = new LogOffsetMetadata(this.activeSegment().nextOffset(), this.activeSegment().baseOffset(), (int)this.activeSegment().size());
        this.topicAndPartition = Log$.MODULE$.parseTopicPartitionName(dir);
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Log $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Completed load of log %s with log end offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToLong((long)this.$outer.logEndOffset())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic"), (Object)this.topicAndPartition().topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partition"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.topicAndPartition().partition())).toString())}));
        this.newGauge("NumLogSegments", new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public int value() {
                return this.$outer.numberOfSegments();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("LogStartOffset", new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public long value() {
                return this.$outer.logStartOffset();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("LogEndOffset", new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public long value() {
                return this.$outer.logEndOffset();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
        this.newGauge("Size", new Gauge<Object>(this){
            private final /* synthetic */ Log $outer;

            public long value() {
                return this.$outer.size();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.tags());
    }
}

