/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.message.OffsetAssigner;
import kafka.message.OffsetAssigner$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t%t!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+GO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKR\u001c\"!\u0003\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0012\u0002\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0003\u0017\u0013\u0011%q#\u0001\u0004de\u0016\fG/\u001a\u000b\u00071\u0001*#FM!\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012a\u00018j_*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006CU\u0001\rAI\u0001\u000f_\u001a47/\u001a;BgNLwM\\3s!\tA1%\u0003\u0002%\u0005\tqqJ\u001a4tKR\f5o]5h]\u0016\u0014\b\"\u0002\u0014\u0016\u0001\u00049\u0013\u0001E2p[B\u0014Xm]:j_:\u001cu\u000eZ3d!\tA\u0001&\u0003\u0002*\u0005\t\u00012i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0005\u0006WU\u0001\r\u0001L\u0001\u0018oJ\f\u0007\u000f]3s\u001b\u0016\u001c8/Y4f)&lWm\u001d;b[B\u00042!D\u00170\u0013\tqcB\u0001\u0004PaRLwN\u001c\t\u0003\u001bAJ!!\r\b\u0003\t1{gn\u001a\u0005\u0006gU\u0001\r\u0001N\u0001\u000ei&lWm\u001d;b[B$\u0016\u0010]3\u0011\u0005UzT\"\u0001\u001c\u000b\u0005]B\u0014A\u0002:fG>\u0014HM\u0003\u0002:u\u000511m\\7n_:T!!B\u001e\u000b\u0005qj\u0014AB1qC\u000eDWMC\u0001?\u0003\ry'oZ\u0005\u0003\u0001Z\u0012Q\u0002V5nKN$\u0018-\u001c9UsB,\u0007\"\u0002\"\u0016\u0001\u0004\u0019\u0015\u0001C7fgN\fw-Z:\u0011\u00075!e)\u0003\u0002F\u001d\tQAH]3qK\u0006$X\r\u001a \u0011\u0005!9\u0015B\u0001%\u0003\u0005\u001diUm]:bO\u0016DQAS\u0005\u0005\u0002-\u000bA\u0002Z3fa&#XM]1u_J$\"\u0001T.\u0011\u00075+\u0006L\u0004\u0002O':\u0011qJU\u0007\u0002!*\u0011\u0011KB\u0001\u0007yI|w\u000e\u001e \n\u0003=I!\u0001\u0016\b\u0002\u000fA\f7m[1hK&\u0011ak\u0016\u0002\t\u0013R,'/\u0019;pe*\u0011AK\u0004\t\u0003\u0011eK!A\u0017\u0002\u0003!5+7o]1hK\u0006sGm\u00144gg\u0016$\b\"\u0002/J\u0001\u0004A\u0016aF<sCB\u0004XM]'fgN\fw-Z!oI>3gm]3u\u0011\u0019q\u0016\u0002\"\u0001\u0005?\u0006aqO]5uK6+7o]1hKR!\u0001mY3g!\ti\u0011-\u0003\u0002c\u001d\t!QK\\5u\u0011\u0015!W\f1\u0001\u0019\u0003\u0019\u0011WO\u001a4fe\")1!\u0018a\u0001\r\")q-\u0018a\u0001_\u00051qN\u001a4tKRDaAX\u0005\u0005\u0002\u0011IG\u0003\u00021kWBDQ\u0001\u001a5A\u0002aAQ\u0001\u001c5A\u00025\fQ\"\\3tg\u0006<Wm\u0016:ji\u0016\u0014\bC\u0001\u0005o\u0013\ty'AA\u0007NKN\u001c\u0018mZ3Xe&$XM\u001d\u0005\u0006O\"\u0004\ra\f\u0004\u0005\u0015\t\u0001!oE\u0002rgZ\u0004\"\u0001\u0003;\n\u0005U\u0014!AC'fgN\fw-Z*fiB\u0011qO_\u0007\u0002q*\u0011\u0011\u0010B\u0001\u0006kRLGn]\u0005\u0003wb\u0014q\u0001T8hO&tw\r\u0003\u0005ec\n\u0015\r\u0011\"\u0001~+\u0005A\u0002\u0002C@r\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u000f\t,hMZ3sA!11#\u001dC\u0001\u0003\u0007!B!!\u0002\u0002\bA\u0011\u0001\"\u001d\u0005\u0007I\u0006\u0005\u0001\u0019\u0001\r\t\u0013\u0005-\u0011\u000f1A\u0005\n\u00055\u0011!F:iC2dwn\u001e,bY&$')\u001f;f\u0007>,h\u000e^\u000b\u0003\u0003\u001f\u00012!DA\t\u0013\r\t\u0019B\u0004\u0002\u0004\u0013:$\b\"CA\fc\u0002\u0007I\u0011BA\r\u0003e\u0019\b.\u00197m_^4\u0016\r\\5e\u0005f$XmQ8v]R|F%Z9\u0015\u0007\u0001\fY\u0002\u0003\u0006\u0002\u001e\u0005U\u0011\u0011!a\u0001\u0003\u001f\t1\u0001\u001f\u00132\u0011!\t\t#\u001dQ!\n\u0005=\u0011AF:iC2dwn\u001e,bY&$')\u001f;f\u0007>,h\u000e\u001e\u0011\t\u000fM\tH\u0011\u0001\u0003\u0002&Qa\u0011QAA\u0014\u0003S\t9$!\u000f\u0002<!1a%a\tA\u0002\u001dB\u0001\"a\u000b\u0002$\u0001\u0007\u0011QF\u0001\u000e_\u001a47/\u001a;D_VtG/\u001a:\u0011\t\u0005=\u00121G\u0007\u0003\u0003cQ!!\u000f\u0003\n\t\u0005U\u0012\u0011\u0007\u0002\b\u0019>twMU3g\u0011\u0019Y\u00131\u0005a\u0001Y!11'a\tA\u0002QBaAQA\u0012\u0001\u0004\u0019\u0005BB\nr\t\u0003\ty\u0004\u0006\u0005\u0002\u0006\u0005\u0005\u00131IA#\u0011\u00191\u0013Q\ba\u0001O!A\u00111FA\u001f\u0001\u0004\ti\u0003\u0003\u0004C\u0003{\u0001\ra\u0011\u0005\u0007'E$\t!!\u0013\u0015\u0011\u0005\u0015\u00111JA'\u0003/BaAJA$\u0001\u00049\u0003\u0002CA(\u0003\u000f\u0002\r!!\u0015\u0002\u0013=4gm]3u'\u0016\f\b\u0003B'\u0002T=J1!!\u0016X\u0005\r\u0019V-\u001d\u0005\u0007\u0005\u0006\u001d\u0003\u0019A\"\t\rM\tH\u0011AA.)\u0019\t)!!\u0018\u0002`!1a%!\u0017A\u0002\u001dBaAQA-\u0001\u0004\u0019\u0005BB\nr\t\u0003\t\u0019\u0007\u0006\u0003\u0002\u0006\u0005\u0015\u0004B\u0002\"\u0002b\u0001\u00071\t\u0003\u0004\u0002jE$\t!`\u0001\nO\u0016$()\u001e4gKJDq!!\u001cr\t\u0013\ti!A\ttQ\u0006dGn\\<WC2LGMQ=uKNDq!!\u001dr\t\u0003\t\u0019(\u0001\u0007xe&$XMR;mYf$v\u000e\u0006\u0003\u0002\u0010\u0005U\u0004\u0002CA<\u0003_\u0002\r!!\u001f\u0002\u000f\rD\u0017M\u001c8fYB!\u00111PAA\u001b\t\tiHC\u0002\u0002\u0000i\t\u0001b\u00195b]:,Gn]\u0005\u0005\u0003\u0007\u000biH\u0001\u000bHCRDWM]5oO\nKH/Z\"iC:tW\r\u001c\u0005\b\u0003\u000f\u000bH\u0011AAE\u0003\u001d9(/\u001b;f)>$\u0002\"a\u0004\u0002\f\u00065\u0015q\u0012\u0005\t\u0003o\n)\t1\u0001\u0002z!1q-!\"A\u0002=B\u0001\"!%\u0002\u0006\u0002\u0007\u0011qB\u0001\b[\u0006D8+\u001b>f\u0011\u001d\t)*\u001dC!\u0003/\u000b\u0001%[:NC\u001eL7MV1mk\u0016Le.\u00117m/J\f\u0007\u000f]3s\u001b\u0016\u001c8/Y4fgR!\u0011\u0011TAP!\ri\u00111T\u0005\u0004\u0003;s!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003C\u000b\u0019\n1\u0001\u0002$\u0006\u0011R\r\u001f9fGR,G-T1hS\u000e4\u0016\r\\;f!\ri\u0011QU\u0005\u0004\u0003Os!\u0001\u0002\"zi\u0016Dq!a+r\t\u0003\ni+\u0001\u0005ji\u0016\u0014\u0018\r^8s+\u0005a\u0005bBAYc\u0012\u0005\u0011QV\u0001\u0010g\"\fG\u000e\\8x\u0013R,'/\u0019;pe\"9\u0011QW9\u0005\n\u0005]\u0016\u0001E5oi\u0016\u0014h.\u00197Ji\u0016\u0014\u0018\r^8s)\ra\u0015\u0011\u0018\u0005\u000b\u0003w\u000b\u0019\f%AA\u0002\u0005e\u0015!C5t'\"\fG\u000e\\8x\u0011!\ty,\u001dC\u0001\t\u0005\u0005\u0017\u0001\t<bY&$\u0017\r^3NKN\u001c\u0018mZ3t\u0003:$\u0017i]:jO:|eMZ:fiN$\"#a1\u0002J\u0006-\u0017qZAj\u0003/\fY.a8\u0002dB9Q\"!2\u0002\u0006\u0005e\u0015bAAd\u001d\t1A+\u001e9mKJB\u0001\"a\u000b\u0002>\u0002\u0007\u0011Q\u0006\u0005\b\u0003\u001b\fi\f1\u00010\u0003\rqwn\u001e\u0005\b\u0003#\fi\f1\u0001(\u0003-\u0019x.\u001e:dK\u000e{G-Z2\t\u000f\u0005U\u0017Q\u0018a\u0001O\u0005YA/\u0019:hKR\u001cu\u000eZ3d\u0011)\tI.!0\u0011\u0002\u0003\u0007\u0011\u0011T\u0001\u000fG>l\u0007/Y2uK\u0012$v\u000e]5d\u0011)\ti.!0\u0011\u0002\u0003\u0007\u00111U\u0001\u0015[\u0016\u001c8/Y4f\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\t\u000f\u0005\u0005\u0018Q\u0018a\u0001i\u0005!R.Z:tC\u001e,G+[7fgR\fW\u000e\u001d+za\u0016Dq!!:\u0002>\u0002\u0007q&A\rnKN\u001c\u0018mZ3US6,7\u000f^1na\u0012KgMZ'bq6\u001b\bbBAuc\u0012%\u00111^\u0001\u001dG>tg/\u001a:u\u001d>t7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3t)9\t)!!<\u0002p\u0006E\u00181_A{\u0003oD\u0001\"a\u000b\u0002h\u0002\u0007\u0011Q\u0006\u0005\t\u00033\f9\u000f1\u0001\u0002\u001a\"9\u0011QZAt\u0001\u0004y\u0003BB\u001a\u0002h\u0002\u0007A\u0007C\u0004\u0002f\u0006\u001d\b\u0019A\u0018\t\u0011\u0005e\u0018q\u001da\u0001\u0003G\u000bA\u0002^8NC\u001eL7MV1mk\u0016Dq!!@r\t\u0013\ty0A\u001awC2LG-\u0019;f\u001d>t7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3t\u0003:$\u0017i]:jO:|eMZ:fi&s\u0007\u000b\\1dKRa\u0011Q\u0001B\u0001\u0005\u0007\u0011)Aa\u0002\u0003\n!A\u00111FA~\u0001\u0004\ti\u0003C\u0004\u0002N\u0006m\b\u0019A\u0018\t\u0011\u0005e\u00171 a\u0001\u00033CaaMA~\u0001\u0004!\u0004b\u0002B\u0006\u0003w\u0004\raL\u0001\u0013i&lWm\u001d;b[B$\u0015N\u001a4NCbl5\u000fC\u0004\u0003\u0010E$IA!\u0005\u0002%Y\fG.\u001b3bi\u0016lUm]:bO\u0016\\U-\u001f\u000b\u0006A\nM!Q\u0003\u0005\u0007\u0007\t5\u0001\u0019\u0001$\t\u0011\u0005e'Q\u0002a\u0001\u00033CqA!\u0007r\t\u0013\u0011Y\"A\twC2LG-\u0019;f)&lWm\u001d;b[B$\u0012\u0002\u0019B\u000f\u0005?\u0011\tCa\t\t\r\r\u00119\u00021\u0001G\u0011\u001d\tiMa\u0006A\u0002=Baa\rB\f\u0001\u0004!\u0004b\u0002B\u0006\u0005/\u0001\ra\f\u0005\b\u0005O\tH\u0011AA\u0007\u0003-\u0019\u0018N_3J]\nKH/Z:\t\u000f\t-\u0012\u000f\"\u0001\u0002\u000e\u0005Qa/\u00197jI\nKH/Z:\t\u000f\t=\u0012\u000f\"\u0011\u00032\u00051Q-];bYN$B!!'\u00034!A!Q\u0007B\u0017\u0001\u0004\u00119$A\u0003pi\",'\u000fE\u0002\u000e\u0005sI1Aa\u000f\u000f\u0005\r\te.\u001f\u0005\b\u0005\u007f\tH\u0011\tB!\u0003!A\u0017m\u001d5D_\u0012,GCAA\b\u0011%\u0011)%]I\u0001\n\u0003\u00119%\u0001\u0016wC2LG-\u0019;f\u001b\u0016\u001c8/Y4fg\u0006sG-Q:tS\u001etwJ\u001a4tKR\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t%#\u0006BAM\u0005\u0017Z#A!\u0014\u0011\t\t=#\u0011L\u0007\u0003\u0005#RAAa\u0015\u0003V\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005/r\u0011AC1o]>$\u0018\r^5p]&!!1\fB)\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005?\n\u0018\u0013!C\u0001\u0005C\n!F^1mS\u0012\fG/Z'fgN\fw-Z:B]\u0012\f5o]5h]>3gm]3ug\u0012\"WMZ1vYR$c'\u0006\u0002\u0003d)\"\u00111\u0015B&\u0011%\u00119']I\u0001\n\u0013\u00119%\u0001\u000ej]R,'O\\1m\u0013R,'/\u0019;pe\u0012\"WMZ1vYR$\u0013\u0007")
public class ByteBufferMessageSet
extends MessageSet
implements Logging {
    private final ByteBuffer buffer;
    private int shallowValidByteCount;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Iterator<MessageAndOffset> deepIterator(MessageAndOffset messageAndOffset) {
        return ByteBufferMessageSet$.MODULE$.deepIterator(messageAndOffset);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ByteBufferMessageSet byteBufferMessageSet = this;
        synchronized (byteBufferMessageSet) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    private int shallowValidByteCount() {
        return this.shallowValidByteCount;
    }

    private void shallowValidByteCount_$eq(int x$1) {
        this.shallowValidByteCount = x$1;
    }

    public ByteBuffer getBuffer() {
        return this.buffer();
    }

    private int shallowValidBytes() {
        if (this.shallowValidByteCount() < 0) {
            this.shallowValidByteCount_$eq(BoxesRunTime.unboxToInt((Object)this.internalIterator(true).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(MessageAndOffset messageAndOffset) {
                    return MessageSet$.MODULE$.entrySize(messageAndOffset.message());
                }
            }).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        }
        return this.shallowValidByteCount();
    }

    /*
     * WARNING - void declaration
     */
    public int writeFullyTo(GatheringByteChannel channel) {
        void var2_2;
        this.buffer().mark();
        for (int written = 0; written < this.sizeInBytes(); written += channel.write(this.buffer())) {
        }
        this.buffer().reset();
        return (int)var2_2;
    }

    @Override
    public int writeTo(GatheringByteChannel channel, long offset, int maxSize) {
        if (offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset should not be larger than Int.MaxValue: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset)})));
        }
        ByteBuffer dup = this.buffer().duplicate();
        int position = (int)offset;
        dup.position(position);
        dup.limit(package$.MODULE$.min(this.buffer().limit(), position + maxSize));
        return channel.write(dup);
    }

    @Override
    public boolean isMagicValueInAllWrapperMessages(byte expectedMagicValue) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                this.shallowIterator().foreach((Function1)new Serializable(this, expectedMagicValue, object){
                    public static final long serialVersionUID = 0L;
                    private final byte expectedMagicValue$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(MessageAndOffset messageAndOffset) {
                        if (messageAndOffset.message().magic() != this.expectedMagicValue$1) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                        }
                    }
                    {
                        this.expectedMagicValue$1 = expectedMagicValue$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.internalIterator(this.internalIterator$default$1());
    }

    public Iterator<MessageAndOffset> shallowIterator() {
        return this.internalIterator(true);
    }

    private Iterator<MessageAndOffset> internalIterator(boolean isShallow) {
        return new IteratorTemplate<MessageAndOffset>(this, isShallow){
            private ByteBuffer topIter;
            private Iterator<MessageAndOffset> innerIter;
            private final boolean isShallow$1;

            private ByteBuffer topIter() {
                return this.topIter;
            }

            private void topIter_$eq(ByteBuffer x$1) {
                this.topIter = x$1;
            }

            private Iterator<MessageAndOffset> innerIter() {
                return this.innerIter;
            }

            private void innerIter_$eq(Iterator<MessageAndOffset> x$1) {
                this.innerIter = x$1;
            }

            private boolean innerDone() {
                return this.innerIter() == null || !this.innerIter().hasNext();
            }

            private MessageAndOffset makeNextOuter() {
                MessageAndOffset messageAndOffset;
                if (this.topIter().remaining() < 12) {
                    return (MessageAndOffset)this.allDone();
                }
                long offset = this.topIter().getLong();
                int size2 = this.topIter().getInt();
                if (size2 < Message$.MODULE$.MinMessageOverhead()) {
                    throw new InvalidMessageException(new StringBuilder().append((Object)"Message found with corrupt size (").append((Object)BoxesRunTime.boxToInteger((int)size2)).append((Object)") in shallow iterator").toString());
                }
                if (this.topIter().remaining() < size2) {
                    return (MessageAndOffset)this.allDone();
                }
                ByteBuffer message = this.topIter().slice();
                message.limit(size2);
                this.topIter().position(this.topIter().position() + size2);
                Message newMessage = new Message(message, Message$.MODULE$.$lessinit$greater$default$2(), Message$.MODULE$.$lessinit$greater$default$3());
                if (this.isShallow$1) {
                    messageAndOffset = new MessageAndOffset(newMessage, offset);
                } else {
                    MessageAndOffset messageAndOffset2;
                    CompressionCodec compressionCodec = newMessage.compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    if (!(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null)) {
                        this.innerIter_$eq(null);
                        messageAndOffset2 = new MessageAndOffset(newMessage, offset);
                    } else {
                        this.innerIter_$eq(ByteBufferMessageSet$.MODULE$.deepIterator(new MessageAndOffset(newMessage, offset)));
                        if (!this.innerIter().hasNext()) {
                            this.innerIter_$eq(null);
                        }
                        messageAndOffset2 = this.makeNext();
                    }
                    messageAndOffset = messageAndOffset2;
                }
                return messageAndOffset;
            }

            public MessageAndOffset makeNext() {
                return this.isShallow$1 ? this.makeNextOuter() : (this.innerDone() ? this.makeNextOuter() : (MessageAndOffset)this.innerIter().next());
            }
            {
                this.isShallow$1 = isShallow$1;
                this.topIter = $outer.buffer().slice();
                this.innerIter = null;
            }
        };
    }

    private boolean internalIterator$default$1() {
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Tuple2<ByteBufferMessageSet, Object> validateMessagesAndAssignOffsets(kafka.common.LongRef offsetCounter, long now, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic, byte messageFormatVersion, TimestampType messageTimestampType, long messageTimestampDiffMaxMs) {
        block8: {
            block11: {
                block10: {
                    block9: {
                        block7: {
                            v0 = sourceCodec;
                            var11_9 = NoCompressionCodec$.MODULE$;
                            if (v0 != null ? v0.equals(var11_9) == false : var11_9 != null) break block7;
                            v1 = targetCodec;
                            var12_10 = NoCompressionCodec$.MODULE$;
                            if (v1 != null ? v1.equals(var12_10) == false : var12_10 != null) break block7;
                            v2 = this.isMagicValueInAllWrapperMessages(messageFormatVersion) ? new Tuple2((Object)this.validateNonCompressedMessagesAndAssignOffsetInPlace(offsetCounter, now, compactedTopic, messageTimestampType, messageTimestampDiffMaxMs), (Object)BoxesRunTime.boxToBoolean((boolean)false)) : new Tuple2((Object)this.convertNonCompressedMessages(offsetCounter, compactedTopic, now, messageTimestampType, messageTimestampDiffMaxMs, messageFormatVersion), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                            break block8;
                        }
                        v3 = sourceCodec;
                        var13_11 = targetCodec;
                        inPlaceAssignment = new BooleanRef(!(v3 != null ? v3.equals(var13_11) == false : var13_11 != null) && messageFormatVersion > Message$.MODULE$.MagicValue_V0());
                        maxTimestamp = new LongRef(Message$.MODULE$.NoTimestamp());
                        expectedInnerOffset = new kafka.common.LongRef(0L);
                        validatedMessages = new ArrayBuffer();
                        this.internalIterator(false).foreach((Function1)new Serializable(this, now, sourceCodec, compactedTopic, messageFormatVersion, messageTimestampType, messageTimestampDiffMaxMs, inPlaceAssignment, maxTimestamp, expectedInnerOffset, validatedMessages){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ByteBufferMessageSet $outer;
                            private final long now$1;
                            private final CompressionCodec sourceCodec$1;
                            private final boolean compactedTopic$1;
                            private final byte messageFormatVersion$1;
                            private final TimestampType messageTimestampType$1;
                            private final long messageTimestampDiffMaxMs$1;
                            private final BooleanRef inPlaceAssignment$1;
                            private final LongRef maxTimestamp$1;
                            private final kafka.common.LongRef expectedInnerOffset$1;
                            private final ArrayBuffer validatedMessages$1;

                            /*
                             * WARNING - void declaration
                             */
                            public final ArrayBuffer<Message> apply(MessageAndOffset messageAndOffset) {
                                void var2_2;
                                block7: {
                                    Message message;
                                    block6: {
                                        message = messageAndOffset.message();
                                        this.$outer.kafka$message$ByteBufferMessageSet$$validateMessageKey(message, this.compactedTopic$1);
                                        if (message.magic() > Message$.MODULE$.MagicValue_V0() && this.messageFormatVersion$1 > Message$.MODULE$.MagicValue_V0()) {
                                            this.$outer.kafka$message$ByteBufferMessageSet$$validateTimestamp(message, this.now$1, this.messageTimestampType$1, this.messageTimestampDiffMaxMs$1);
                                            if (messageAndOffset.offset() != this.expectedInnerOffset$1.getAndIncrement()) {
                                                this.inPlaceAssignment$1.elem = false;
                                            }
                                            this.maxTimestamp$1.elem = package$.MODULE$.max(this.maxTimestamp$1.elem, message.timestamp());
                                        }
                                        CompressionCodec compressionCodec = this.sourceCodec$1;
                                        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                                        if (!(compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$))) break block6;
                                        CompressionCodec compressionCodec2 = message.compressionCodec();
                                        NoCompressionCodec$ noCompressionCodec$2 = NoCompressionCodec$.MODULE$;
                                        if (compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$2) : noCompressionCodec$2 != null) break block7;
                                    }
                                    if (message.magic() != this.messageFormatVersion$1) {
                                        this.inPlaceAssignment$1.elem = false;
                                    }
                                    return this.validatedMessages$1.$plus$eq((Object)message.toFormatVersion(this.messageFormatVersion$1));
                                }
                                throw new InvalidMessageException(new StringBuilder().append((Object)"Compressed outer message should not have an inner message with a ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression attribute set: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2}))).toString());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.now$1 = now$1;
                                this.sourceCodec$1 = sourceCodec$1;
                                this.compactedTopic$1 = compactedTopic$1;
                                this.messageFormatVersion$1 = messageFormatVersion$1;
                                this.messageTimestampType$1 = messageTimestampType$1;
                                this.messageTimestampDiffMaxMs$1 = messageTimestampDiffMaxMs$1;
                                this.inPlaceAssignment$1 = inPlaceAssignment$1;
                                this.maxTimestamp$1 = maxTimestamp$1;
                                this.expectedInnerOffset$1 = expectedInnerOffset$1;
                                this.validatedMessages$1 = validatedMessages$1;
                            }
                        });
                        if (!inPlaceAssignment.elem) break block9;
                        this.buffer().putLong(0, offsetCounter.addAndGet(validatedMessages.size()) - 1L);
                        validatedMessages.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Message x$2) {
                                x$2.ensureValid();
                            }
                        });
                        crcUpdateNeeded = true;
                        timestampOffset = MessageSet$.MODULE$.LogOverhead() + Message$.MODULE$.TimestampOffset();
                        attributeOffset = MessageSet$.MODULE$.LogOverhead() + Message$.MODULE$.AttributesOffset();
                        timestamp = this.buffer().getLong(timestampOffset);
                        attributes = this.buffer().get(attributeOffset);
                        v4 = messageTimestampType;
                        var24_21 = TimestampType.CREATE_TIME;
                        if (!(v4 != null ? v4.equals((Object)var24_21) == false : var24_21 != null) && timestamp == maxTimestamp.elem) {
                            crcUpdateNeeded = false;
                            v5 /* !! */  = BoxedUnit.UNIT;
                        } else {
                            v6 = messageTimestampType;
                            var25_22 = TimestampType.LOG_APPEND_TIME;
                            if (!(v6 != null ? v6.equals((Object)var25_22) == false : var25_22 != null)) {
                                this.buffer().putLong(timestampOffset, now);
                                v5 /* !! */  = this.buffer().put(attributeOffset, messageTimestampType.updateAttributes(attributes));
                            } else {
                                v5 /* !! */  = BoxedUnit.UNIT;
                            }
                        }
                        if (crcUpdateNeeded) {
                            this.buffer().position(MessageSet$.MODULE$.LogOverhead());
                            wrapperMessage = new Message(this.buffer().slice(), Message$.MODULE$.$lessinit$greater$default$2(), Message$.MODULE$.$lessinit$greater$default$3());
                            Utils.writeUnsignedInt(this.buffer(), MessageSet$.MODULE$.LogOverhead() + Message$.MODULE$.CrcOffset(), wrapperMessage.computeChecksum());
                        }
                        this.buffer().rewind();
                        v2 = new Tuple2((Object)this, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break block8;
                    }
                    if (messageFormatVersion != Message$.MODULE$.MagicValue_V0()) break block10;
                    v7 = new Some((Object)BoxesRunTime.boxToLong((long)Message$.MODULE$.NoTimestamp()));
                    break block11;
                }
                if (messageFormatVersion <= Message$.MODULE$.MagicValue_V0()) ** GOTO lbl-1000
                v8 = messageTimestampType;
                var27_24 = TimestampType.CREATE_TIME;
                if (!(v8 != null ? v8.equals((Object)var27_24) == false : var27_24 != null)) {
                    v7 = new Some((Object)BoxesRunTime.boxToLong((long)maxTimestamp.elem));
                } else lbl-1000:
                // 2 sources

                {
                    v7 = new Some((Object)BoxesRunTime.boxToLong((long)now));
                }
            }
            wrapperMessageTimestamp = v7;
            v2 = new Tuple2((Object)new ByteBufferMessageSet(targetCodec, offsetCounter, (Option<Object>)wrapperMessageTimestamp, messageTimestampType, (Seq<Message>)validatedMessages), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        return v2;
    }

    public boolean validateMessagesAndAssignOffsets$default$5() {
        return false;
    }

    public byte validateMessagesAndAssignOffsets$default$6() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    private ByteBufferMessageSet convertNonCompressedMessages(kafka.common.LongRef offsetCounter, boolean compactedTopic, long now, TimestampType timestampType2, long messageTimestampDiffMaxMs, byte toMagicValue) {
        int sizeInBytesAfterConversion = this.shallowValidBytes() + BoxesRunTime.unboxToInt((Object)this.internalIterator(true).map((Function1)new Serializable(this, toMagicValue){
            public static final long serialVersionUID = 0L;
            private final byte toMagicValue$1;

            public final int apply(MessageAndOffset messageAndOffset) {
                return Message$.MODULE$.headerSizeDiff(messageAndOffset.message().magic(), this.toMagicValue$1);
            }
            {
                this.toMagicValue$1 = toMagicValue$1;
            }
        }).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ByteBuffer newBuffer = ByteBuffer.allocate(sizeInBytesAfterConversion);
        IntRef newMessagePosition = new IntRef(0);
        this.internalIterator(true).foreach((Function1)new Serializable(this, offsetCounter, compactedTopic, now, timestampType2, messageTimestampDiffMaxMs, toMagicValue, newBuffer, newMessagePosition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteBufferMessageSet $outer;
            private final kafka.common.LongRef offsetCounter$1;
            private final boolean compactedTopic$2;
            private final long now$2;
            private final TimestampType timestampType$1;
            private final long messageTimestampDiffMaxMs$2;
            private final byte toMagicValue$1;
            private final ByteBuffer newBuffer$1;
            private final IntRef newMessagePosition$1;

            public final void apply(MessageAndOffset x0$1) {
                MessageAndOffset messageAndOffset = x0$1;
                if (messageAndOffset != null) {
                    Message message = messageAndOffset.message();
                    this.$outer.kafka$message$ByteBufferMessageSet$$validateMessageKey(message, this.compactedTopic$2);
                    this.$outer.kafka$message$ByteBufferMessageSet$$validateTimestamp(message, this.now$2, this.timestampType$1, this.messageTimestampDiffMaxMs$2);
                    this.newBuffer$1.position(this.newMessagePosition$1.elem);
                    this.newBuffer$1.putLong(this.offsetCounter$1.getAndIncrement());
                    int newMessageSize = message.size() + Message$.MODULE$.headerSizeDiff(message.magic(), this.toMagicValue$1);
                    this.newBuffer$1.putInt(newMessageSize);
                    ByteBuffer newMessageBuffer = this.newBuffer$1.slice();
                    newMessageBuffer.limit(newMessageSize);
                    message.convertToBuffer(this.toMagicValue$1, newMessageBuffer, this.now$2, this.timestampType$1);
                    this.newMessagePosition$1.elem += MessageSet$.MODULE$.LogOverhead() + newMessageSize;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)messageAndOffset);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetCounter$1 = offsetCounter$1;
                this.compactedTopic$2 = compactedTopic$2;
                this.now$2 = now$2;
                this.timestampType$1 = timestampType$1;
                this.messageTimestampDiffMaxMs$2 = messageTimestampDiffMaxMs$2;
                this.toMagicValue$1 = toMagicValue$1;
                this.newBuffer$1 = newBuffer$1;
                this.newMessagePosition$1 = newMessagePosition$1;
            }
        });
        newBuffer.rewind();
        return new ByteBufferMessageSet(newBuffer);
    }

    private ByteBufferMessageSet validateNonCompressedMessagesAndAssignOffsetInPlace(kafka.common.LongRef offsetCounter, long now, boolean compactedTopic, TimestampType timestampType2, long timestampDiffMaxMs) {
        int messageSize;
        this.buffer().mark();
        for (int messagePosition = 0; messagePosition < this.sizeInBytes() - MessageSet$.MODULE$.LogOverhead(); messagePosition += MessageSet$.MODULE$.LogOverhead() + messageSize) {
            this.buffer().position(messagePosition);
            this.buffer().putLong(offsetCounter.getAndIncrement());
            messageSize = this.buffer().getInt();
            ByteBuffer messageBuffer = this.buffer().slice();
            messageBuffer.limit(messageSize);
            Message message = new Message(messageBuffer, Message$.MODULE$.$lessinit$greater$default$2(), Message$.MODULE$.$lessinit$greater$default$3());
            this.kafka$message$ByteBufferMessageSet$$validateMessageKey(message, compactedTopic);
            if (message.magic() <= Message$.MODULE$.MagicValue_V0()) continue;
            this.kafka$message$ByteBufferMessageSet$$validateTimestamp(message, now, timestampType2, timestampDiffMaxMs);
            TimestampType timestampType3 = timestampType2;
            TimestampType timestampType4 = TimestampType.LOG_APPEND_TIME;
            if (timestampType3 != null ? !((Object)((Object)timestampType3)).equals((Object)timestampType4) : timestampType4 != null) continue;
            message.buffer().putLong(Message$.MODULE$.TimestampOffset(), now);
            message.buffer().put(Message$.MODULE$.AttributesOffset(), timestampType2.updateAttributes(message.attributes()));
            Utils.writeUnsignedInt(message.buffer(), Message$.MODULE$.CrcOffset(), message.computeChecksum());
        }
        this.buffer().reset();
        return this;
    }

    public void kafka$message$ByteBufferMessageSet$$validateMessageKey(Message message, boolean compactedTopic) {
        if (compactedTopic && !message.hasKey()) {
            throw new InvalidMessageException("Compacted topic cannot accept message without key.");
        }
    }

    public void kafka$message$ByteBufferMessageSet$$validateTimestamp(Message message, long now, TimestampType timestampType2, long timestampDiffMaxMs) {
        TimestampType timestampType3 = timestampType2;
        TimestampType timestampType4 = TimestampType.CREATE_TIME;
        if (!(timestampType3 != null ? !((Object)((Object)timestampType3)).equals((Object)timestampType4) : timestampType4 != null) && package$.MODULE$.abs(message.timestamp() - now) > timestampDiffMaxMs) {
            throw new InvalidTimestampException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamp ", " of message is out of range. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)message.timestamp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The timestamp should be within [", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now - timestampDiffMaxMs)), BoxesRunTime.boxToLong((long)(now + timestampDiffMaxMs))}))).toString());
        }
        TimestampType timestampType5 = message.timestampType();
        TimestampType timestampType6 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType5 != null ? !((Object)((Object)timestampType5)).equals((Object)timestampType6) : timestampType6 != null)) {
            throw new InvalidTimestampException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid timestamp type in message ", ". Producer should not set "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp type to LogAppendTime."})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    @Override
    public int sizeInBytes() {
        return this.buffer().limit();
    }

    public int validBytes() {
        return this.shallowValidBytes();
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof ByteBufferMessageSet) {
            ByteBufferMessageSet byteBufferMessageSet = (ByteBufferMessageSet)object;
            bl = this.buffer().equals(byteBufferMessageSet.buffer());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.buffer().hashCode();
    }

    public ByteBufferMessageSet(ByteBuffer buffer) {
        this.buffer = buffer;
        Logging$class.$init$(this);
        this.shallowValidByteCount = -1;
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, kafka.common.LongRef offsetCounter, Option<Object> wrapperMessageTimestamp, TimestampType timestampType2, Seq<Message> messages) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(OffsetAssigner$.MODULE$.apply(offsetCounter, messages.size()), compressionCodec, wrapperMessageTimestamp, timestampType2, messages));
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, kafka.common.LongRef offsetCounter, Seq<Message> messages) {
        this(compressionCodec, offsetCounter, (Option<Object>)None$.MODULE$, TimestampType.CREATE_TIME, messages);
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, Seq<Object> offsetSeq, Seq<Message> messages) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(new OffsetAssigner(offsetSeq), compressionCodec, (Option<Object>)None$.MODULE$, TimestampType.CREATE_TIME, messages));
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, Seq<Message> messages) {
        this(compressionCodec, new kafka.common.LongRef(0L), messages);
    }

    public ByteBufferMessageSet(Seq<Message> messages) {
        this(NoCompressionCodec$.MODULE$, messages);
    }
}

