/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.keytab;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.shared.kerberos.components.EncryptionKey;

class KeytabEncoder {
    KeytabEncoder() {
    }

    private short getKeytabVersion(byte[] version) {
        if (version != null && version.length == 2 && version[0] == 5) {
            switch (version[1]) {
                case 1: {
                    return 1281;
                }
                case 2: {
                    return 1282;
                }
            }
            return -1;
        }
        return -1;
    }

    ByteBuffer write(byte[] keytabVersion, List<KeytabEntry> entries) {
        ArrayList<ByteBuffer> keytabEntryBuffers = new ArrayList<ByteBuffer>();
        short version = this.getKeytabVersion(keytabVersion);
        int buffersSize = this.encodeKeytabEntries(keytabEntryBuffers, version, entries);
        ByteBuffer buffer = ByteBuffer.allocate(keytabVersion.length + buffersSize);
        buffer.put(keytabVersion);
        for (ByteBuffer keytabEntryBuffer : keytabEntryBuffers) {
            buffer.put(keytabEntryBuffer);
        }
        buffer.flip();
        return buffer;
    }

    private int encodeKeytabEntries(List<ByteBuffer> buffers, short version, List<KeytabEntry> entries) {
        int size2 = 0;
        for (KeytabEntry keytabEntry : entries) {
            ByteBuffer entryBuffer = this.encodeKeytabEntry(version, keytabEntry);
            buffers.add(entryBuffer);
            size2 += entryBuffer.limit();
        }
        return size2;
    }

    private ByteBuffer encodeKeytabEntry(short version, KeytabEntry entry2) {
        ByteBuffer principalNameBuffer = this.encodePrincipalName(version, entry2.getPrincipalName());
        ByteBuffer keyBlockBuffer = this.encodeKeyBlock(entry2.getKey());
        int bufferSize = 4 + principalNameBuffer.limit() + 4 + 1 + keyBlockBuffer.limit();
        if (version == 1282) {
            bufferSize += 4;
        }
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.putInt(bufferSize - 4);
        buffer.put(principalNameBuffer);
        if (version == 1282) {
            buffer.putInt((int)entry2.getPrincipalType());
        }
        buffer.putInt((int)(entry2.getTimeStamp().getTime() / 1000L));
        buffer.put(entry2.getKeyVersion());
        buffer.put(keyBlockBuffer);
        buffer.flip();
        return buffer;
    }

    private ByteBuffer encodePrincipalName(short version, String principalName) {
        String[] split = principalName.split("@");
        String nameComponentPart = split[0];
        String realm = split[1];
        String[] nameComponents = nameComponentPart.split("/");
        ArrayList<byte[]> strings = new ArrayList<byte[]>();
        int size2 = 2;
        size2 += this.encodeCountedString(strings, realm);
        for (String nameComponent : nameComponents) {
            size2 += this.encodeCountedString(strings, nameComponent);
        }
        ByteBuffer buffer = ByteBuffer.allocate(size2);
        if (version == 1281) {
            buffer.putShort((short)(nameComponents.length + 1));
        } else {
            buffer.putShort((short)nameComponents.length);
        }
        for (byte[] string : strings) {
            buffer.putShort((short)string.length);
            buffer.put(string);
        }
        buffer.flip();
        return buffer;
    }

    private ByteBuffer encodeKeyBlock(EncryptionKey key) {
        byte[] keyBytes = key.getKeyValue();
        int size2 = 4 + keyBytes.length;
        ByteBuffer buffer = ByteBuffer.allocate(size2);
        buffer.putShort((short)key.getKeyType().getValue());
        buffer.putShort((short)keyBytes.length);
        buffer.put(keyBytes);
        buffer.flip();
        return buffer;
    }

    private short encodeCountedString(List<byte[]> nameComponentBytes, String string) {
        try {
            byte[] data = string.getBytes("US-ASCII");
            nameComponentBytes.add(data);
            return (short)(data.length + 2);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee.getMessage(), uee);
        }
    }
}

