/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.spark-project.guava.annotations.VisibleForTesting;
import org.spark-project.guava.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class BlockListAsLongs
implements Iterable<BlockReportReplica> {
    private static final int CHUNK_SIZE = 65536;
    private static long[] EMPTY_LONGS = new long[]{0L, 0L};
    public static BlockListAsLongs EMPTY = new BlockListAsLongs(){

        @Override
        public int getNumberOfBlocks() {
            return 0;
        }

        @Override
        public ByteString getBlocksBuffer() {
            return ByteString.EMPTY;
        }

        @Override
        public long[] getBlockListAsLongs() {
            return EMPTY_LONGS;
        }

        @Override
        public Iterator<BlockReportReplica> iterator() {
            return Collections.emptyIterator();
        }
    };

    public static BlockListAsLongs decodeBuffer(int numBlocks, ByteString blocksBuf, int maxDataLength) {
        return new BufferDecoder(numBlocks, blocksBuf, maxDataLength);
    }

    @VisibleForTesting
    public static BlockListAsLongs decodeBuffers(int numBlocks, List<ByteString> blocksBufs) {
        return BlockListAsLongs.decodeBuffers(numBlocks, blocksBufs, 0x4000000);
    }

    public static BlockListAsLongs decodeBuffers(int numBlocks, List<ByteString> blocksBufs, int maxDataLength) {
        return BlockListAsLongs.decodeBuffer(numBlocks, ByteString.copyFrom(blocksBufs), maxDataLength);
    }

    public static BlockListAsLongs decodeLongs(List<Long> blocksList) {
        return BlockListAsLongs.decodeLongs(blocksList, 0x4000000);
    }

    public static BlockListAsLongs decodeLongs(List<Long> blocksList, int maxDataLength) {
        return blocksList.isEmpty() ? EMPTY : new LongsDecoder(blocksList, maxDataLength);
    }

    @VisibleForTesting
    public static BlockListAsLongs encode(Collection<? extends Replica> replicas) {
        Builder builder = BlockListAsLongs.builder(0x4000000);
        for (Replica replica : replicas) {
            builder.add(replica);
        }
        return builder.build();
    }

    public static BlockListAsLongs readFrom(InputStream is, int maxDataLength) throws IOException {
        CodedInputStream cis = CodedInputStream.newInstance((InputStream)is);
        if (maxDataLength != 0x4000000) {
            cis.setSizeLimit(maxDataLength);
        }
        int numBlocks = -1;
        ByteString blocksBuf = null;
        block5: while (!cis.isAtEnd()) {
            int tag = cis.readTag();
            int field = WireFormat.getTagFieldNumber((int)tag);
            switch (field) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    numBlocks = cis.readInt32();
                    continue block5;
                }
                case 2: {
                    blocksBuf = cis.readBytes();
                    continue block5;
                }
            }
            cis.skipField(tag);
        }
        if (numBlocks != -1 && blocksBuf != null) {
            return BlockListAsLongs.decodeBuffer(numBlocks, blocksBuf, maxDataLength);
        }
        return null;
    }

    public void writeTo(OutputStream os) throws IOException {
        CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)os);
        cos.writeInt32(1, this.getNumberOfBlocks());
        cos.writeBytes(2, this.getBlocksBuffer());
        cos.flush();
    }

    @VisibleForTesting
    public static Builder builder() {
        return BlockListAsLongs.builder(0x4000000);
    }

    public static Builder builder(int maxDataLength) {
        return new Builder(maxDataLength);
    }

    public abstract int getNumberOfBlocks();

    public abstract ByteString getBlocksBuffer();

    public List<ByteString> getBlocksBuffers() {
        List<ByteString> buffers;
        ByteString blocksBuf = this.getBlocksBuffer();
        int size2 = blocksBuf.size();
        if (size2 <= 65536) {
            buffers = Collections.singletonList(blocksBuf);
        } else {
            buffers = new ArrayList<ByteString>();
            for (int pos = 0; pos < size2; pos += 65536) {
                buffers.add(blocksBuf.substring(pos, Math.min(pos + 65536, size2)));
            }
        }
        return buffers;
    }

    public abstract long[] getBlockListAsLongs();

    @Override
    public abstract Iterator<BlockReportReplica> iterator();

    @InterfaceAudience.Private
    public static class BlockReportReplica
    extends Block
    implements Replica {
        private HdfsServerConstants.ReplicaState state;

        private BlockReportReplica() {
        }

        public BlockReportReplica(Block block) {
            super(block);
            this.state = block instanceof BlockReportReplica ? ((BlockReportReplica)block).getState() : HdfsServerConstants.ReplicaState.FINALIZED;
        }

        public void setState(HdfsServerConstants.ReplicaState state) {
            this.state = state;
        }

        @Override
        public HdfsServerConstants.ReplicaState getState() {
            return this.state;
        }

        @Override
        public long getBytesOnDisk() {
            return this.getNumBytes();
        }

        @Override
        public long getVisibleLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStorageUuid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOnTransientStorage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class LongsDecoder
    extends BlockListAsLongs {
        private final List<Long> values;
        private final int finalizedBlocks;
        private final int numBlocks;
        private final int maxDataLength;

        LongsDecoder(List<Long> values, int maxDataLength) {
            this.values = values.subList(2, values.size());
            this.finalizedBlocks = values.get(0).intValue();
            this.numBlocks = this.finalizedBlocks + values.get(1).intValue();
            this.maxDataLength = maxDataLength;
        }

        @Override
        public int getNumberOfBlocks() {
            return this.numBlocks;
        }

        @Override
        public ByteString getBlocksBuffer() {
            Builder builder = LongsDecoder.builder(this.maxDataLength);
            for (Replica replica : this) {
                builder.add(replica);
            }
            return builder.build().getBlocksBuffer();
        }

        @Override
        public long[] getBlockListAsLongs() {
            long[] longs = new long[2 + this.values.size()];
            longs[0] = this.finalizedBlocks;
            longs[1] = this.numBlocks - this.finalizedBlocks;
            for (int i = 0; i < longs.length; ++i) {
                longs[i] = this.values.get(i);
            }
            return longs;
        }

        @Override
        public Iterator<BlockReportReplica> iterator() {
            return new Iterator<BlockReportReplica>(){
                private final BlockReportReplica block = new BlockReportReplica();
                final Iterator<Long> iter = LongsDecoder.access$700(LongsDecoder.this).iterator();
                private int currentBlockIndex = 0;

                @Override
                public boolean hasNext() {
                    return this.currentBlockIndex < LongsDecoder.this.numBlocks;
                }

                @Override
                public BlockReportReplica next() {
                    if (this.currentBlockIndex == LongsDecoder.this.finalizedBlocks) {
                        this.readBlock();
                        Preconditions.checkArgument((this.block.getBlockId() == -1L && this.block.getNumBytes() == -1L && this.block.getGenerationStamp() == -1L ? 1 : 0) != 0, (Object)"Invalid delimiter block");
                    }
                    this.readBlock();
                    if (this.currentBlockIndex++ < LongsDecoder.this.finalizedBlocks) {
                        this.block.setState(HdfsServerConstants.ReplicaState.FINALIZED);
                    } else {
                        this.block.setState(HdfsServerConstants.ReplicaState.getState(this.iter.next().intValue()));
                    }
                    return this.block;
                }

                private void readBlock() {
                    this.block.setBlockId(this.iter.next());
                    this.block.setNumBytes(this.iter.next());
                    this.block.setGenerationStamp(this.iter.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        static /* synthetic */ List access$700(LongsDecoder x0) {
            return x0.values;
        }
    }

    private static class BufferDecoder
    extends BlockListAsLongs {
        private static long NUM_BYTES_MASK = 0xFFFFFFFFFFFFL;
        private static long REPLICA_STATE_MASK = 15L;
        private final ByteString buffer;
        private final int numBlocks;
        private int numFinalized;
        private final int maxDataLength;

        BufferDecoder(int numBlocks, ByteString buf, int maxDataLength) {
            this(numBlocks, -1, buf, maxDataLength);
        }

        BufferDecoder(int numBlocks, int numFinalized, ByteString buf, int maxDataLength) {
            this.numBlocks = numBlocks;
            this.numFinalized = numFinalized;
            this.buffer = buf;
            this.maxDataLength = maxDataLength;
        }

        @Override
        public int getNumberOfBlocks() {
            return this.numBlocks;
        }

        @Override
        public ByteString getBlocksBuffer() {
            return this.buffer;
        }

        @Override
        public long[] getBlockListAsLongs() {
            if (this.numFinalized == -1) {
                int n = 0;
                for (Replica replica : this) {
                    if (replica.getState() != HdfsServerConstants.ReplicaState.FINALIZED) continue;
                    ++n;
                }
                this.numFinalized = n;
            }
            int numUc = this.numBlocks - this.numFinalized;
            int size2 = 2 + 3 * (this.numFinalized + 1) + 4 * numUc;
            long[] longs = new long[size2];
            longs[0] = this.numFinalized;
            longs[1] = numUc;
            int idx = 2;
            int ucIdx = idx + 3 * this.numFinalized;
            longs[ucIdx++] = -1L;
            longs[ucIdx++] = -1L;
            longs[ucIdx++] = -1L;
            block4: for (BlockReportReplica block : this) {
                switch (block.getState()) {
                    case FINALIZED: {
                        longs[idx++] = block.getBlockId();
                        longs[idx++] = block.getNumBytes();
                        longs[idx++] = block.getGenerationStamp();
                        continue block4;
                    }
                }
                longs[ucIdx++] = block.getBlockId();
                longs[ucIdx++] = block.getNumBytes();
                longs[ucIdx++] = block.getGenerationStamp();
                longs[ucIdx++] = block.getState().getValue();
            }
            return longs;
        }

        @Override
        public Iterator<BlockReportReplica> iterator() {
            return new Iterator<BlockReportReplica>(){
                final BlockReportReplica block = new BlockReportReplica();
                final CodedInputStream cis = BufferDecoder.access$200(BufferDecoder.this).newCodedInput();
                private int currentBlockIndex = 0;
                {
                    if (BufferDecoder.this.maxDataLength != 0x4000000) {
                        this.cis.setSizeLimit(BufferDecoder.this.maxDataLength);
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.currentBlockIndex < BufferDecoder.this.numBlocks;
                }

                @Override
                public BlockReportReplica next() {
                    ++this.currentBlockIndex;
                    try {
                        this.block.setBlockId(this.cis.readSInt64());
                        this.block.setNumBytes(this.cis.readRawVarint64() & NUM_BYTES_MASK);
                        this.block.setGenerationStamp(this.cis.readRawVarint64());
                        long state = this.cis.readRawVarint64() & REPLICA_STATE_MASK;
                        this.block.setState(HdfsServerConstants.ReplicaState.getState((int)state));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                    return this.block;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        static /* synthetic */ ByteString access$200(BufferDecoder x0) {
            return x0.buffer;
        }
    }

    public static class Builder {
        private final ByteString.Output out = ByteString.newOutput((int)65536);
        private final CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)this.out);
        private int numBlocks = 0;
        private int numFinalized = 0;
        private final int maxDataLength;

        Builder(int maxDataLength) {
            this.maxDataLength = maxDataLength;
        }

        public void add(Replica replica) {
            try {
                this.cos.writeSInt64NoTag(replica.getBlockId());
                this.cos.writeRawVarint64(replica.getBytesOnDisk());
                this.cos.writeRawVarint64(replica.getGenerationStamp());
                HdfsServerConstants.ReplicaState state = replica.getState();
                this.cos.writeRawVarint64((long)state.getValue());
                if (state == HdfsServerConstants.ReplicaState.FINALIZED) {
                    ++this.numFinalized;
                }
                ++this.numBlocks;
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }

        public int getNumberOfBlocks() {
            return this.numBlocks;
        }

        public BlockListAsLongs build() {
            try {
                this.cos.flush();
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
            return new BufferDecoder(this.numBlocks, this.numFinalized, this.out.toByteString(), this.maxDataLength);
        }
    }
}

