/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.spark-project.guava.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CacheDirectiveIterator
extends BatchedRemoteIterator<Long, CacheDirectiveEntry> {
    private CacheDirectiveInfo filter;
    private final ClientProtocol namenode;
    private final Sampler<?> traceSampler;

    public CacheDirectiveIterator(ClientProtocol namenode, CacheDirectiveInfo filter, Sampler<?> traceSampler) {
        super((Object)0L);
        this.namenode = namenode;
        this.filter = filter;
        this.traceSampler = traceSampler;
    }

    private static CacheDirectiveInfo removeIdFromFilter(CacheDirectiveInfo filter) {
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder(filter);
        builder.setId(null);
        return builder.build();
    }

    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> makeRequest(Long prevKey) throws IOException {
        BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> entries = null;
        try (TraceScope scope = Trace.startSpan("listCacheDirectives", this.traceSampler);){
            entries = this.namenode.listCacheDirectives(prevKey, this.filter);
        }
        Preconditions.checkNotNull(entries);
        return entries;
    }

    public Long elementToPrevKey(CacheDirectiveEntry entry2) {
        return entry2.getInfo().getId();
    }

    private static class SingleEntry
    implements BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> {
        private final CacheDirectiveEntry entry;

        public SingleEntry(CacheDirectiveEntry entry2) {
            this.entry = entry2;
        }

        public CacheDirectiveEntry get(int i) {
            if (i > 0) {
                return null;
            }
            return this.entry;
        }

        public int size() {
            return 1;
        }

        public boolean hasMore() {
            return false;
        }
    }
}

