/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.spark-project.guava.collect.Lists;
import org.spark-project.guava.collect.Maps;

class PendingDataNodeMessages {
    final Map<Block, Queue<ReportedBlockInfo>> queueByBlockId = Maps.newHashMap();
    private int count = 0;

    PendingDataNodeMessages() {
    }

    void removeAllMessagesForDatanode(DatanodeDescriptor dn) {
        for (Map.Entry<Block, Queue<ReportedBlockInfo>> entry2 : this.queueByBlockId.entrySet()) {
            LinkedList newQueue = Lists.newLinkedList();
            Queue<ReportedBlockInfo> oldQueue = entry2.getValue();
            while (!oldQueue.isEmpty()) {
                ReportedBlockInfo rbi = oldQueue.remove();
                if (!rbi.getStorageInfo().getDatanodeDescriptor().equals(dn)) {
                    newQueue.add(rbi);
                    continue;
                }
                --this.count;
            }
            this.queueByBlockId.put(entry2.getKey(), newQueue);
        }
    }

    void enqueueReportedBlock(DatanodeStorageInfo storageInfo, Block block, HdfsServerConstants.ReplicaState reportedState) {
        block = new Block(block);
        this.getBlockQueue(block).add(new ReportedBlockInfo(storageInfo, block, reportedState));
        ++this.count;
    }

    Queue<ReportedBlockInfo> takeBlockQueue(Block block) {
        Queue<ReportedBlockInfo> queue = this.queueByBlockId.remove(block);
        if (queue != null) {
            this.count -= queue.size();
        }
        return queue;
    }

    private Queue<ReportedBlockInfo> getBlockQueue(Block block) {
        LinkedList queue = this.queueByBlockId.get(block);
        if (queue == null) {
            queue = Lists.newLinkedList();
            this.queueByBlockId.put(block, queue);
        }
        return queue;
    }

    int count() {
        return this.count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Block, Queue<ReportedBlockInfo>> entry2 : this.queueByBlockId.entrySet()) {
            sb.append("Block " + entry2.getKey() + ":\n");
            for (ReportedBlockInfo rbi : entry2.getValue()) {
                sb.append("  ").append(rbi).append("\n");
            }
        }
        return sb.toString();
    }

    Iterable<ReportedBlockInfo> takeAll() {
        ArrayList rbis = Lists.newArrayListWithCapacity((int)this.count);
        for (Queue<ReportedBlockInfo> q : this.queueByBlockId.values()) {
            rbis.addAll(q);
        }
        this.queueByBlockId.clear();
        this.count = 0;
        return rbis;
    }

    static class ReportedBlockInfo {
        private final Block block;
        private final DatanodeStorageInfo storageInfo;
        private final HdfsServerConstants.ReplicaState reportedState;

        ReportedBlockInfo(DatanodeStorageInfo storageInfo, Block block, HdfsServerConstants.ReplicaState reportedState) {
            this.storageInfo = storageInfo;
            this.block = block;
            this.reportedState = reportedState;
        }

        Block getBlock() {
            return this.block;
        }

        HdfsServerConstants.ReplicaState getReportedState() {
            return this.reportedState;
        }

        DatanodeStorageInfo getStorageInfo() {
            return this.storageInfo;
        }

        public String toString() {
            return "ReportedBlockInfo [block=" + this.block + ", dn=" + this.storageInfo.getDatanodeDescriptor() + ", reportedState=" + (Object)((Object)this.reportedState) + "]";
        }
    }
}

