/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.LightWeightLinkedSet;

class UnderReplicatedBlocks
implements Iterable<Block> {
    static final int LEVEL = 5;
    static final int QUEUE_HIGHEST_PRIORITY = 0;
    static final int QUEUE_VERY_UNDER_REPLICATED = 1;
    static final int QUEUE_UNDER_REPLICATED = 2;
    static final int QUEUE_REPLICAS_BADLY_DISTRIBUTED = 3;
    static final int QUEUE_WITH_CORRUPT_BLOCKS = 4;
    private List<LightWeightLinkedSet<Block>> priorityQueues = new ArrayList<LightWeightLinkedSet<Block>>(5);
    private int corruptReplOneBlocks = 0;

    UnderReplicatedBlocks() {
        for (int i = 0; i < 5; ++i) {
            this.priorityQueues.add(new LightWeightLinkedSet());
        }
    }

    synchronized void clear() {
        for (int i = 0; i < 5; ++i) {
            this.priorityQueues.get(i).clear();
        }
        this.corruptReplOneBlocks = 0;
    }

    synchronized int size() {
        int size2 = 0;
        for (int i = 0; i < 5; ++i) {
            size2 += this.priorityQueues.get(i).size();
        }
        return size2;
    }

    synchronized int getUnderReplicatedBlockCount() {
        int size2 = 0;
        for (int i = 0; i < 5; ++i) {
            if (i == 4) continue;
            size2 += this.priorityQueues.get(i).size();
        }
        return size2;
    }

    synchronized int getCorruptBlockSize() {
        return this.priorityQueues.get(4).size();
    }

    synchronized int getCorruptReplOneBlockSize() {
        return this.corruptReplOneBlocks;
    }

    synchronized boolean contains(Block block) {
        for (LightWeightLinkedSet<Block> set : this.priorityQueues) {
            if (!set.contains(block)) continue;
            return true;
        }
        return false;
    }

    private int getPriority(Block block, int curReplicas, int readOnlyReplicas, int decommissionedReplicas, int expectedReplicas) {
        assert (curReplicas >= 0) : "Negative replicas!";
        if (curReplicas >= expectedReplicas) {
            return 3;
        }
        if (curReplicas == 0) {
            if (decommissionedReplicas > 0) {
                return 0;
            }
            if (readOnlyReplicas > 0) {
                return 0;
            }
            return 4;
        }
        if (curReplicas == 1) {
            return 0;
        }
        if (curReplicas * 3 < expectedReplicas) {
            return 1;
        }
        return 2;
    }

    synchronized boolean add(Block block, int curReplicas, int readOnlyReplicas, int decomissionedReplicas, int expectedReplicas) {
        assert (curReplicas >= 0) : "Negative replicas!";
        int priLevel = this.getPriority(block, curReplicas, readOnlyReplicas, decomissionedReplicas, expectedReplicas);
        if (this.priorityQueues.get(priLevel).add(block)) {
            if (priLevel == 4 && expectedReplicas == 1) {
                ++this.corruptReplOneBlocks;
            }
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.UnderReplicationBlock.add: {} has only {} replicas and need {} replicas so is added to neededReplications at priority level {}", new Object[]{block, curReplicas, expectedReplicas, priLevel});
            return true;
        }
        return false;
    }

    synchronized boolean remove(Block block, int oldReplicas, int oldReadOnlyReplicas, int decommissionedReplicas, int oldExpectedReplicas) {
        int priLevel = this.getPriority(block, oldReplicas, oldReadOnlyReplicas, decommissionedReplicas, oldExpectedReplicas);
        boolean removedBlock = this.remove(block, priLevel);
        if (priLevel == 4 && oldExpectedReplicas == 1 && removedBlock) {
            --this.corruptReplOneBlocks;
            assert (this.corruptReplOneBlocks >= 0) : "Number of corrupt blocks with replication factor 1 should be non-negative";
        }
        return removedBlock;
    }

    boolean remove(Block block, int priLevel) {
        if (priLevel >= 0 && priLevel < 5 && this.priorityQueues.get(priLevel).remove(block)) {
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.UnderReplicationBlock.remove: Removing block {} from priority queue {}", (Object)block, (Object)priLevel);
            return true;
        }
        for (int i = 0; i < 5; ++i) {
            if (i == priLevel || !this.priorityQueues.get(i).remove(block)) continue;
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.UnderReplicationBlock.remove: Removing block {} from priority queue {}", (Object)block, (Object)i);
            return true;
        }
        return false;
    }

    synchronized void update(Block block, int curReplicas, int readOnlyReplicas, int decommissionedReplicas, int curExpectedReplicas, int curReplicasDelta, int expectedReplicasDelta) {
        int oldReplicas = curReplicas - curReplicasDelta;
        int oldExpectedReplicas = curExpectedReplicas - expectedReplicasDelta;
        int curPri = this.getPriority(block, curReplicas, readOnlyReplicas, decommissionedReplicas, curExpectedReplicas);
        int oldPri = this.getPriority(block, oldReplicas, readOnlyReplicas, decommissionedReplicas, oldExpectedReplicas);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("UnderReplicationBlocks.update " + block + " curReplicas " + curReplicas + " curExpectedReplicas " + curExpectedReplicas + " oldReplicas " + oldReplicas + " oldExpectedReplicas  " + oldExpectedReplicas + " curPri  " + curPri + " oldPri  " + oldPri);
        }
        if (oldPri != curPri) {
            this.remove(block, oldPri);
        }
        if (this.priorityQueues.get(curPri).add(block)) {
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.UnderReplicationBlock.update: {} has only {} replicas and needs {} replicas so is added to neededReplications at priority level {}", new Object[]{block, curReplicas, curExpectedReplicas, curPri});
        }
        if (oldPri != curPri || expectedReplicasDelta != 0) {
            if (curPri == 4 && curExpectedReplicas == 1) {
                ++this.corruptReplOneBlocks;
            } else if (oldPri == 4 && curExpectedReplicas - expectedReplicasDelta == 1) {
                --this.corruptReplOneBlocks;
            }
        }
    }

    synchronized List<List<Block>> chooseUnderReplicatedBlocks(int blocksToProcess) {
        int priority;
        StringBuilder sb;
        ArrayList<List<Block>> blocksToReplicate = new ArrayList<List<Block>>(5);
        StringBuilder stringBuilder = sb = NameNode.blockStateChangeLog.isInfoEnabled() ? new StringBuilder() : null;
        if (sb != null) {
            sb.append("chooseUnderReplicatedBlocks selected ");
        }
        int count2 = 0;
        for (priority = 0; count2 < blocksToProcess && priority < 5; ++priority) {
            if (priority == 4) continue;
            Iterator<Block> i = this.priorityQueues.get(priority).getBookmark();
            LinkedList<Block> blocks = new LinkedList<Block>();
            blocksToReplicate.add(blocks);
            int blockCountAtLevelStart = count2;
            while (count2 < blocksToProcess && i.hasNext()) {
                blocks.add(i.next());
                ++count2;
            }
            if (sb == null || count2 - blockCountAtLevelStart <= 0) continue;
            sb.append(count2 - blockCountAtLevelStart + " blocks at priority level " + priority + "; ");
        }
        if (priority == 5) {
            for (LightWeightLinkedSet<Block> q : this.priorityQueues) {
                q.resetBookmark();
            }
        }
        if (sb != null && count2 > 0) {
            sb.append(" Total=" + count2);
            sb.append(" Reset bookmarks? " + (priority == 5));
            NameNode.blockStateChangeLog.info(sb.toString());
        }
        return blocksToReplicate;
    }

    synchronized Iterator<Block> iterator(int level) {
        return this.priorityQueues.get(level).iterator();
    }

    @Override
    public synchronized Iterator<Block> iterator() {
        final Iterator<LightWeightLinkedSet<Block>> q = this.priorityQueues.iterator();
        return new Iterator<Block>(){
            private Iterator<Block> b;
            {
                this.b = ((LightWeightLinkedSet)q.next()).iterator();
            }

            @Override
            public Block next() {
                this.hasNext();
                return this.b.next();
            }

            @Override
            public boolean hasNext() {
                while (!this.b.hasNext() && q.hasNext()) {
                    this.b = ((LightWeightLinkedSet)q.next()).iterator();
                }
                return this.b.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

