/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.CloseableReferenceCount;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Timer;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;
import org.codehaus.jackson.map.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.annotations.VisibleForTesting;
import org.spark-project.guava.base.Joiner;
import org.spark-project.guava.base.Preconditions;
import org.spark-project.guava.util.concurrent.ThreadFactoryBuilder;

@InterfaceAudience.Private
@VisibleForTesting
public class FsVolumeImpl
implements FsVolumeSpi {
    public static final Logger LOG = LoggerFactory.getLogger(FsVolumeImpl.class);
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private static final ObjectReader READER = new ObjectMapper().reader(BlockIteratorState.class);
    private final FsDatasetImpl dataset;
    private final String storageID;
    private final StorageType storageType;
    private final Map<String, BlockPoolSlice> bpSlices = new ConcurrentHashMap<String, BlockPoolSlice>();
    private final File currentDir;
    private final DF usage;
    private final long reserved;
    private CloseableReferenceCount reference = new CloseableReferenceCount();
    private AtomicLong reservedForRbw;
    protected volatile long configuredCapacity;
    protected ThreadPoolExecutor cacheExecutor;

    FsVolumeImpl(FsDatasetImpl dataset, String storageID, File currentDir, Configuration conf, StorageType storageType) throws IOException {
        this.dataset = dataset;
        this.storageID = storageID;
        this.reserved = conf.getLong("dfs.datanode.du.reserved." + StringUtils.toLowerCase((String)storageType.toString()), conf.getLong("dfs.datanode.du.reserved", 0L));
        this.reservedForRbw = new AtomicLong(0L);
        this.currentDir = currentDir;
        File parent = currentDir.getParentFile();
        this.usage = new DF(parent, conf);
        this.storageType = storageType;
        this.configuredCapacity = -1L;
        this.cacheExecutor = this.initializeCacheExecutor(parent);
    }

    protected ThreadPoolExecutor initializeCacheExecutor(File parent) {
        if (this.storageType.isTransient()) {
            return null;
        }
        if (this.dataset.datanode == null) {
            return null;
        }
        int maxNumThreads = this.dataset.datanode.getConf().getInt("dfs.datanode.fsdatasetcache.max.threads.per.volume", 4);
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FsVolumeImplWorker-" + parent.toString() + "-%d").build();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, maxNumThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), workerFactory);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private void printReferenceTraceInfo(String op) {
        StackTraceElement[] stack;
        for (StackTraceElement ste : stack = Thread.currentThread().getStackTrace()) {
            switch (ste.getMethodName()) {
                case "getDfsUsed": 
                case "getBlockPoolUsed": 
                case "getAvailable": 
                case "getVolumeMap": {
                    return;
                }
            }
        }
        FsDatasetImpl.LOG.trace((Object)("Reference count: " + op + " " + this + ": " + this.reference.getReferenceCount()));
        FsDatasetImpl.LOG.trace((Object)Joiner.on((String)"\n").join((Object[])Thread.currentThread().getStackTrace()));
    }

    private void reference() throws ClosedChannelException {
        this.reference.reference();
        if (FsDatasetImpl.LOG.isTraceEnabled()) {
            this.printReferenceTraceInfo("incr");
        }
    }

    private void unreference() {
        if (FsDatasetImpl.LOG.isTraceEnabled()) {
            this.printReferenceTraceInfo("desc");
        }
        if (FsDatasetImpl.LOG.isDebugEnabled() && this.reference.getReferenceCount() <= 0) {
            FsDatasetImpl.LOG.debug((Object)("Decrease reference count <= 0 on " + this + Joiner.on((String)"\n").join((Object[])Thread.currentThread().getStackTrace())));
        }
        this.checkReference();
        this.reference.unreference();
    }

    @Override
    public FsVolumeReference obtainReference() throws ClosedChannelException {
        return new FsVolumeReferenceImpl(this);
    }

    private void checkReference() {
        Preconditions.checkState((this.reference.getReferenceCount() > 0 ? 1 : 0) != 0);
    }

    @VisibleForTesting
    int getReferenceCount() {
        return this.reference.getReferenceCount();
    }

    void closeAndWait() throws IOException {
        try {
            this.reference.setClosed();
            this.dataset.stopAllDataxceiverThreads(this);
        }
        catch (ClosedChannelException e) {
            throw new IOException("The volume has already closed.", e);
        }
        int SLEEP_MILLIS = 500;
        while (this.reference.getReferenceCount() > 0) {
            if (FsDatasetImpl.LOG.isDebugEnabled()) {
                FsDatasetImpl.LOG.debug((Object)String.format("The reference count for %s is %d, wait to be 0.", this, this.reference.getReferenceCount()));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    File getCurrentDir() {
        return this.currentDir;
    }

    File getRbwDir(String bpid) throws IOException {
        return this.getBlockPoolSlice(bpid).getRbwDir();
    }

    File getLazyPersistDir(String bpid) throws IOException {
        return this.getBlockPoolSlice(bpid).getLazypersistDir();
    }

    File getTmpDir(String bpid) throws IOException {
        return this.getBlockPoolSlice(bpid).getTmpDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decDfsUsed(String bpid, long value2) {
        FsDatasetImpl fsDatasetImpl = this.dataset;
        synchronized (fsDatasetImpl) {
            BlockPoolSlice bp = this.bpSlices.get(bpid);
            if (bp != null) {
                bp.decDfsUsed(value2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incDfsUsed(String bpid, long value2) {
        FsDatasetImpl fsDatasetImpl = this.dataset;
        synchronized (fsDatasetImpl) {
            BlockPoolSlice bp = this.bpSlices.get(bpid);
            if (bp != null) {
                bp.incDfsUsed(value2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public long getDfsUsed() throws IOException {
        long dfsUsed = 0L;
        FsDatasetImpl fsDatasetImpl = this.dataset;
        synchronized (fsDatasetImpl) {
            for (BlockPoolSlice s : this.bpSlices.values()) {
                dfsUsed += s.getDfsUsed();
            }
        }
        return dfsUsed;
    }

    long getBlockPoolUsed(String bpid) throws IOException {
        return this.getBlockPoolSlice(bpid).getDfsUsed();
    }

    @VisibleForTesting
    public long getCapacity() {
        if (this.configuredCapacity < 0L) {
            long remaining = this.usage.getCapacity() - this.reserved;
            return remaining > 0L ? remaining : 0L;
        }
        return this.configuredCapacity;
    }

    @VisibleForTesting
    public void setCapacityForTesting(long capacity) {
        this.configuredCapacity = capacity;
    }

    @Override
    public long getAvailable() throws IOException {
        long available;
        long remaining = this.getCapacity() - this.getDfsUsed() - this.reservedForRbw.get();
        if (remaining > (available = this.usage.getAvailable() - this.reserved - this.reservedForRbw.get())) {
            remaining = available;
        }
        return remaining > 0L ? remaining : 0L;
    }

    @VisibleForTesting
    public long getReservedForRbw() {
        return this.reservedForRbw.get();
    }

    long getReserved() {
        return this.reserved;
    }

    BlockPoolSlice getBlockPoolSlice(String bpid) throws IOException {
        BlockPoolSlice bp = this.bpSlices.get(bpid);
        if (bp == null) {
            throw new IOException("block pool " + bpid + " is not found");
        }
        return bp;
    }

    @Override
    public String getBasePath() {
        return this.currentDir.getParent();
    }

    @Override
    public boolean isTransientStorage() {
        return this.storageType.isTransient();
    }

    @Override
    public String getPath(String bpid) throws IOException {
        return this.getBlockPoolSlice(bpid).getDirectory().getAbsolutePath();
    }

    @Override
    public File getFinalizedDir(String bpid) throws IOException {
        return this.getBlockPoolSlice(bpid).getFinalizedDir();
    }

    @Override
    public String[] getBlockPoolList() {
        return this.bpSlices.keySet().toArray(new String[this.bpSlices.keySet().size()]);
    }

    File createTmpFile(String bpid, Block b) throws IOException {
        this.checkReference();
        return this.getBlockPoolSlice(bpid).createTmpFile(b);
    }

    @Override
    public void reserveSpaceForRbw(long bytesToReserve) {
        if (bytesToReserve != 0L) {
            this.reservedForRbw.addAndGet(bytesToReserve);
        }
    }

    @Override
    public void releaseReservedSpace(long bytesToRelease) {
        if (bytesToRelease != 0L) {
            long newReservation;
            long oldReservation;
            do {
                if ((newReservation = (oldReservation = this.reservedForRbw.get()) - bytesToRelease) >= 0L) continue;
                newReservation = 0L;
            } while (!this.reservedForRbw.compareAndSet(oldReservation, newReservation));
        }
    }

    @VisibleForTesting
    public static String nextSorted(List<String> arr, String prev) {
        int res = 0;
        if (prev != null) {
            res = Collections.binarySearch(arr, prev);
            res = res < 0 ? -1 - res : ++res;
        }
        if (res >= arr.size()) {
            return null;
        }
        return arr.get(res);
    }

    @Override
    public FsVolumeSpi.BlockIterator newBlockIterator(String bpid, String name) {
        return new BlockIteratorImpl(bpid, name);
    }

    @Override
    public FsVolumeSpi.BlockIterator loadBlockIterator(String bpid, String name) throws IOException {
        BlockIteratorImpl iter = new BlockIteratorImpl(bpid, name);
        iter.load();
        return iter;
    }

    @Override
    public FsDatasetSpi getDataset() {
        return this.dataset;
    }

    File createRbwFile(String bpid, Block b) throws IOException {
        this.checkReference();
        this.reserveSpaceForRbw(b.getNumBytes());
        try {
            return this.getBlockPoolSlice(bpid).createRbwFile(b);
        }
        catch (IOException exception) {
            this.releaseReservedSpace(b.getNumBytes());
            throw exception;
        }
    }

    File addFinalizedBlock(String bpid, Block b, File f, long bytesReservedForRbw) throws IOException {
        this.releaseReservedSpace(bytesReservedForRbw);
        return this.getBlockPoolSlice(bpid).addBlock(b, f);
    }

    Executor getCacheExecutor() {
        return this.cacheExecutor;
    }

    void checkDirs() throws DiskChecker.DiskErrorException {
        for (BlockPoolSlice s : this.bpSlices.values()) {
            s.checkDirs();
        }
    }

    void getVolumeMap(ReplicaMap volumeMap, RamDiskReplicaTracker ramDiskReplicaMap) throws IOException {
        for (BlockPoolSlice s : this.bpSlices.values()) {
            s.getVolumeMap(volumeMap, ramDiskReplicaMap);
        }
    }

    void getVolumeMap(String bpid, ReplicaMap volumeMap, RamDiskReplicaTracker ramDiskReplicaMap) throws IOException {
        this.getBlockPoolSlice(bpid).getVolumeMap(volumeMap, ramDiskReplicaMap);
    }

    public String toString() {
        return this.currentDir.getAbsolutePath();
    }

    void shutdown() {
        if (this.cacheExecutor != null) {
            this.cacheExecutor.shutdown();
        }
        Set<Map.Entry<String, BlockPoolSlice>> set = this.bpSlices.entrySet();
        for (Map.Entry<String, BlockPoolSlice> entry2 : set) {
            entry2.getValue().shutdown(null);
        }
    }

    void addBlockPool(String bpid, Configuration conf) throws IOException {
        this.addBlockPool(bpid, conf, null);
    }

    void addBlockPool(String bpid, Configuration conf, Timer timer) throws IOException {
        File bpdir = new File(this.currentDir, bpid);
        BlockPoolSlice bp = timer == null ? new BlockPoolSlice(bpid, this, bpdir, conf, new Timer()) : new BlockPoolSlice(bpid, this, bpdir, conf, timer);
        this.bpSlices.put(bpid, bp);
    }

    void shutdownBlockPool(String bpid, BlockListAsLongs blocksListsAsLongs) {
        BlockPoolSlice bp = this.bpSlices.get(bpid);
        if (bp != null) {
            bp.shutdown(blocksListsAsLongs);
        }
        this.bpSlices.remove(bpid);
    }

    boolean isBPDirEmpty(String bpid) throws IOException {
        File volumeCurrentDir = this.getCurrentDir();
        File bpDir = new File(volumeCurrentDir, bpid);
        File bpCurrentDir = new File(bpDir, "current");
        File finalizedDir = new File(bpCurrentDir, "finalized");
        File rbwDir = new File(bpCurrentDir, "rbw");
        if (finalizedDir.exists() && !DatanodeUtil.dirNoFilesRecursive(finalizedDir)) {
            return false;
        }
        return !rbwDir.exists() || FileUtil.list((File)rbwDir).length == 0;
    }

    void deleteBPDirectories(String bpid, boolean force) throws IOException {
        File volumeCurrentDir = this.getCurrentDir();
        File bpDir = new File(volumeCurrentDir, bpid);
        if (!bpDir.isDirectory()) {
            return;
        }
        File tmpDir = new File(bpDir, "tmp");
        File bpCurrentDir = new File(bpDir, "current");
        File finalizedDir = new File(bpCurrentDir, "finalized");
        File lazypersistDir = new File(bpCurrentDir, "lazypersist");
        File rbwDir = new File(bpCurrentDir, "rbw");
        if (force) {
            FileUtil.fullyDelete((File)bpDir);
        } else {
            if (!rbwDir.delete()) {
                throw new IOException("Failed to delete " + rbwDir);
            }
            if (!DatanodeUtil.dirNoFilesRecursive(finalizedDir) || !FileUtil.fullyDelete((File)finalizedDir)) {
                throw new IOException("Failed to delete " + finalizedDir);
            }
            if (!(!lazypersistDir.exists() || DatanodeUtil.dirNoFilesRecursive(lazypersistDir) && FileUtil.fullyDelete((File)lazypersistDir))) {
                throw new IOException("Failed to delete " + lazypersistDir);
            }
            FileUtil.fullyDelete((File)tmpDir);
            for (File f : FileUtil.listFiles((File)bpCurrentDir)) {
                if (f.delete()) continue;
                throw new IOException("Failed to delete " + f);
            }
            if (!bpCurrentDir.delete()) {
                throw new IOException("Failed to delete " + bpCurrentDir);
            }
            for (File f : FileUtil.listFiles((File)bpDir)) {
                if (f.delete()) continue;
                throw new IOException("Failed to delete " + f);
            }
            if (!bpDir.delete()) {
                throw new IOException("Failed to delete " + bpDir);
            }
        }
    }

    @Override
    public String getStorageID() {
        return this.storageID;
    }

    @Override
    public StorageType getStorageType() {
        return this.storageType;
    }

    DatanodeStorage toDatanodeStorage() {
        return new DatanodeStorage(this.storageID, DatanodeStorage.State.NORMAL, this.storageType);
    }

    private class BlockIteratorImpl
    implements FsVolumeSpi.BlockIterator {
        private final File bpidDir;
        private final String name;
        private final String bpid;
        private long maxStalenessMs = 0L;
        private List<String> cache;
        private long cacheMs;
        private BlockIteratorState state;

        BlockIteratorImpl(String bpid, String name) {
            this.bpidDir = new File(FsVolumeImpl.this.currentDir, bpid);
            this.name = name;
            this.bpid = bpid;
            this.rewind();
        }

        private String getNextSubDir(String prev, File dir) throws IOException {
            List children = IOUtils.listDirectory((File)dir, (FilenameFilter)SubdirFilter.INSTANCE);
            this.cache = null;
            this.cacheMs = 0L;
            if (children.size() == 0) {
                LOG.trace("getNextSubDir({}, {}): no subdirectories found in {}", new Object[]{FsVolumeImpl.this.storageID, this.bpid, dir.getAbsolutePath()});
                return null;
            }
            Collections.sort(children);
            String nextSubDir = FsVolumeImpl.nextSorted(children, prev);
            if (nextSubDir == null) {
                LOG.trace("getNextSubDir({}, {}): no more subdirectories found in {}", new Object[]{FsVolumeImpl.this.storageID, this.bpid, dir.getAbsolutePath()});
            } else {
                LOG.trace("getNextSubDir({}, {}): picking next subdirectory {} within {}", new Object[]{FsVolumeImpl.this.storageID, this.bpid, nextSubDir, dir.getAbsolutePath()});
            }
            return nextSubDir;
        }

        private String getNextFinalizedDir() throws IOException {
            File dir = Paths.get(this.bpidDir.getAbsolutePath(), "current", "finalized").toFile();
            return this.getNextSubDir(this.state.curFinalizedDir, dir);
        }

        private String getNextFinalizedSubDir() throws IOException {
            if (this.state.curFinalizedDir == null) {
                return null;
            }
            File dir = Paths.get(this.bpidDir.getAbsolutePath(), "current", "finalized", this.state.curFinalizedDir).toFile();
            return this.getNextSubDir(this.state.curFinalizedSubDir, dir);
        }

        private List<String> getSubdirEntries() throws IOException {
            File dir;
            List entries;
            if (this.state.curFinalizedSubDir == null) {
                return null;
            }
            long now = Time.monotonicNow();
            if (this.cache != null) {
                long delta = now - this.cacheMs;
                if (delta < this.maxStalenessMs) {
                    return this.cache;
                }
                LOG.trace("getSubdirEntries({}, {}): purging entries cache for {} after {} ms.", new Object[]{FsVolumeImpl.this.storageID, this.bpid, this.state.curFinalizedSubDir, delta});
                this.cache = null;
            }
            if ((entries = IOUtils.listDirectory((File)(dir = Paths.get(this.bpidDir.getAbsolutePath(), "current", "finalized", this.state.curFinalizedDir, this.state.curFinalizedSubDir).toFile()), (FilenameFilter)BlockFileFilter.INSTANCE)).size() == 0) {
                entries = null;
            } else {
                Collections.sort(entries);
            }
            if (entries == null) {
                LOG.trace("getSubdirEntries({}, {}): no entries found in {}", new Object[]{FsVolumeImpl.this.storageID, this.bpid, dir.getAbsolutePath()});
            } else {
                LOG.trace("getSubdirEntries({}, {}): listed {} entries in {}", new Object[]{FsVolumeImpl.this.storageID, this.bpid, entries.size(), dir.getAbsolutePath()});
            }
            this.cache = entries;
            this.cacheMs = now;
            return this.cache;
        }

        @Override
        public ExtendedBlock nextBlock() throws IOException {
            if (this.state.atEnd) {
                return null;
            }
            try {
                while (true) {
                    List<String> entries;
                    if ((entries = this.getSubdirEntries()) != null) {
                        this.state.curEntry = FsVolumeImpl.nextSorted(entries, this.state.curEntry);
                        if (this.state.curEntry == null) {
                            LOG.trace("nextBlock({}, {}): advancing from {} to next subdirectory.", new Object[]{FsVolumeImpl.this.storageID, this.bpid, this.state.curFinalizedSubDir});
                        } else {
                            ExtendedBlock block = new ExtendedBlock(this.bpid, Block.filename2id(this.state.curEntry));
                            LOG.trace("nextBlock({}, {}): advancing to {}", new Object[]{FsVolumeImpl.this.storageID, this.bpid, block});
                            return block;
                        }
                    }
                    this.state.curFinalizedSubDir = this.getNextFinalizedSubDir();
                    if (this.state.curFinalizedSubDir != null) continue;
                    this.state.curFinalizedDir = this.getNextFinalizedDir();
                    if (this.state.curFinalizedDir == null) break;
                }
                this.state.atEnd = true;
                return null;
            }
            catch (IOException e) {
                this.state.atEnd = true;
                LOG.error("nextBlock({}, {}): I/O error", new Object[]{FsVolumeImpl.this.storageID, this.bpid, e});
                throw e;
            }
        }

        @Override
        public boolean atEnd() {
            return this.state.atEnd;
        }

        @Override
        public void rewind() {
            this.cache = null;
            this.cacheMs = 0L;
            this.state = new BlockIteratorState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void save() throws IOException {
            this.state.lastSavedMs = Time.now();
            boolean success = false;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getTempSaveFile(), false), "UTF-8"));){
                WRITER.writeValue(writer, (Object)this.state);
                success = true;
            }
            finally {
                if (!success && this.getTempSaveFile().delete()) {
                    LOG.debug("save({}, {}): error deleting temporary file.", (Object)FsVolumeImpl.this.storageID, (Object)this.bpid);
                }
            }
            Files.move(this.getTempSaveFile().toPath(), this.getSaveFile().toPath(), StandardCopyOption.ATOMIC_MOVE);
            if (LOG.isTraceEnabled()) {
                LOG.trace("save({}, {}): saved {}", new Object[]{FsVolumeImpl.this.storageID, this.bpid, WRITER.writeValueAsString(this.state)});
            }
        }

        public void load() throws IOException {
            File file = this.getSaveFile();
            this.state = (BlockIteratorState)READER.readValue(file);
            LOG.trace("load({}, {}): loaded iterator {} from {}: {}", new Object[]{FsVolumeImpl.this.storageID, this.bpid, this.name, file.getAbsoluteFile(), WRITER.writeValueAsString(this.state)});
        }

        File getSaveFile() {
            return new File(this.bpidDir, this.name + ".cursor");
        }

        File getTempSaveFile() {
            return new File(this.bpidDir, this.name + ".cursor.tmp");
        }

        @Override
        public void setMaxStalenessMs(long maxStalenessMs) {
            this.maxStalenessMs = maxStalenessMs;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public long getIterStartMs() {
            return this.state.iterStartMs;
        }

        @Override
        public long getLastSavedMs() {
            return this.state.lastSavedMs;
        }

        @Override
        public String getBlockPoolId() {
            return this.bpid;
        }
    }

    private static class BlockIteratorState {
        @JsonProperty
        private long lastSavedMs;
        @JsonProperty
        private long iterStartMs;
        @JsonProperty
        private String curFinalizedDir;
        @JsonProperty
        private String curFinalizedSubDir;
        @JsonProperty
        private String curEntry;
        @JsonProperty
        private boolean atEnd;

        BlockIteratorState() {
            this.lastSavedMs = this.iterStartMs = Time.now();
            this.curFinalizedDir = null;
            this.curFinalizedSubDir = null;
            this.curEntry = null;
            this.atEnd = false;
        }
    }

    private static enum BlockFileFilter implements FilenameFilter
    {
        INSTANCE;


        @Override
        public boolean accept(File dir, String name) {
            return !name.endsWith(".meta") && name.startsWith("blk_");
        }
    }

    private static enum SubdirFilter implements FilenameFilter
    {
        INSTANCE;


        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("subdir");
        }
    }

    private static class FsVolumeReferenceImpl
    implements FsVolumeReference {
        private final FsVolumeImpl volume;

        FsVolumeReferenceImpl(FsVolumeImpl volume) throws ClosedChannelException {
            this.volume = volume;
            volume.reference();
        }

        @Override
        public void close() throws IOException {
            this.volume.unreference();
        }

        @Override
        public FsVolumeSpi getVolume() {
            return this.volume;
        }
    }
}

