/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.ScopedAclEntries;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.spark-project.guava.base.Objects;
import org.spark-project.guava.collect.ComparisonChain;
import org.spark-project.guava.collect.Lists;
import org.spark-project.guava.collect.Maps;
import org.spark-project.guava.collect.Ordering;

@InterfaceAudience.Private
final class AclTransformation {
    private static final int MAX_ENTRIES = 32;
    static final Comparator<AclEntry> ACL_ENTRY_COMPARATOR = new Comparator<AclEntry>(){

        @Override
        public int compare(AclEntry entry1, AclEntry entry2) {
            return ComparisonChain.start().compare((Object)entry1.getScope(), (Object)entry2.getScope(), (Comparator)Ordering.explicit((Object)AclEntryScope.ACCESS, (Object[])new AclEntryScope[]{AclEntryScope.DEFAULT})).compare((Object)entry1.getType(), (Object)entry2.getType(), (Comparator)Ordering.explicit((Object)AclEntryType.USER, (Object[])new AclEntryType[]{AclEntryType.GROUP, AclEntryType.MASK, AclEntryType.OTHER})).compare((Object)entry1.getName(), (Object)entry2.getName(), (Comparator)Ordering.natural().nullsFirst()).result();
        }
    };

    public static List<AclEntry> filterAclEntriesByAclSpec(List<AclEntry> existingAcl, List<AclEntry> inAclSpec) throws AclException {
        ValidatedAclSpec aclSpec = new ValidatedAclSpec(inAclSpec);
        ArrayList aclBuilder = Lists.newArrayListWithCapacity((int)32);
        EnumMap providedMask = Maps.newEnumMap(AclEntryScope.class);
        EnumSet<AclEntryScope> maskDirty = EnumSet.noneOf(AclEntryScope.class);
        EnumSet<AclEntryScope> scopeDirty = EnumSet.noneOf(AclEntryScope.class);
        for (AclEntry existingEntry : existingAcl) {
            if (aclSpec.containsKey(existingEntry)) {
                scopeDirty.add(existingEntry.getScope());
                if (existingEntry.getType() != AclEntryType.MASK) continue;
                maskDirty.add(existingEntry.getScope());
                continue;
            }
            if (existingEntry.getType() == AclEntryType.MASK) {
                providedMask.put(existingEntry.getScope(), existingEntry);
                continue;
            }
            aclBuilder.add(existingEntry);
        }
        AclTransformation.copyDefaultsIfNeeded(aclBuilder);
        AclTransformation.calculateMasks(aclBuilder, providedMask, maskDirty, scopeDirty);
        return AclTransformation.buildAndValidateAcl(aclBuilder);
    }

    public static List<AclEntry> filterDefaultAclEntries(List<AclEntry> existingAcl) throws AclException {
        ArrayList aclBuilder = Lists.newArrayListWithCapacity((int)32);
        for (AclEntry existingEntry : existingAcl) {
            if (existingEntry.getScope() == AclEntryScope.DEFAULT) break;
            aclBuilder.add(existingEntry);
        }
        return AclTransformation.buildAndValidateAcl(aclBuilder);
    }

    public static List<AclEntry> mergeAclEntries(List<AclEntry> existingAcl, List<AclEntry> inAclSpec) throws AclException {
        ValidatedAclSpec aclSpec = new ValidatedAclSpec(inAclSpec);
        ArrayList aclBuilder = Lists.newArrayListWithCapacity((int)32);
        ArrayList foundAclSpecEntries = Lists.newArrayListWithCapacity((int)32);
        EnumMap providedMask = Maps.newEnumMap(AclEntryScope.class);
        EnumSet<AclEntryScope> maskDirty = EnumSet.noneOf(AclEntryScope.class);
        EnumSet<AclEntryScope> scopeDirty = EnumSet.noneOf(AclEntryScope.class);
        for (AclEntry existingEntry : existingAcl) {
            AclEntry aclSpecEntry = aclSpec.findByKey(existingEntry);
            if (aclSpecEntry != null) {
                foundAclSpecEntries.add(aclSpecEntry);
                scopeDirty.add(aclSpecEntry.getScope());
                if (aclSpecEntry.getType() == AclEntryType.MASK) {
                    providedMask.put(aclSpecEntry.getScope(), aclSpecEntry);
                    maskDirty.add(aclSpecEntry.getScope());
                    continue;
                }
                aclBuilder.add(aclSpecEntry);
                continue;
            }
            if (existingEntry.getType() == AclEntryType.MASK) {
                providedMask.put(existingEntry.getScope(), existingEntry);
                continue;
            }
            aclBuilder.add(existingEntry);
        }
        for (AclEntry newEntry : aclSpec) {
            if (Collections.binarySearch(foundAclSpecEntries, newEntry, ACL_ENTRY_COMPARATOR) >= 0) continue;
            scopeDirty.add(newEntry.getScope());
            if (newEntry.getType() == AclEntryType.MASK) {
                providedMask.put(newEntry.getScope(), newEntry);
                maskDirty.add(newEntry.getScope());
                continue;
            }
            aclBuilder.add(newEntry);
        }
        AclTransformation.copyDefaultsIfNeeded(aclBuilder);
        AclTransformation.calculateMasks(aclBuilder, providedMask, maskDirty, scopeDirty);
        return AclTransformation.buildAndValidateAcl(aclBuilder);
    }

    public static List<AclEntry> replaceAclEntries(List<AclEntry> existingAcl, List<AclEntry> inAclSpec) throws AclException {
        ValidatedAclSpec aclSpec = new ValidatedAclSpec(inAclSpec);
        ArrayList aclBuilder = Lists.newArrayListWithCapacity((int)32);
        EnumMap providedMask = Maps.newEnumMap(AclEntryScope.class);
        EnumSet<AclEntryScope> maskDirty = EnumSet.noneOf(AclEntryScope.class);
        EnumSet<AclEntryScope> scopeDirty = EnumSet.noneOf(AclEntryScope.class);
        for (AclEntry aclSpecEntry : aclSpec) {
            scopeDirty.add(aclSpecEntry.getScope());
            if (aclSpecEntry.getType() == AclEntryType.MASK) {
                providedMask.put(aclSpecEntry.getScope(), aclSpecEntry);
                maskDirty.add(aclSpecEntry.getScope());
                continue;
            }
            aclBuilder.add(aclSpecEntry);
        }
        for (AclEntry existingEntry : existingAcl) {
            if (scopeDirty.contains(existingEntry.getScope())) continue;
            if (existingEntry.getType() == AclEntryType.MASK) {
                providedMask.put(existingEntry.getScope(), existingEntry);
                continue;
            }
            aclBuilder.add(existingEntry);
        }
        AclTransformation.copyDefaultsIfNeeded(aclBuilder);
        AclTransformation.calculateMasks(aclBuilder, providedMask, maskDirty, scopeDirty);
        return AclTransformation.buildAndValidateAcl(aclBuilder);
    }

    private AclTransformation() {
    }

    private static List<AclEntry> buildAndValidateAcl(ArrayList<AclEntry> aclBuilder) throws AclException {
        if (aclBuilder.size() > 32) {
            throw new AclException("Invalid ACL: ACL has " + aclBuilder.size() + " entries, which exceeds maximum of " + 32 + ".");
        }
        aclBuilder.trimToSize();
        Collections.sort(aclBuilder, ACL_ENTRY_COMPARATOR);
        AclEntry prevEntry = null;
        for (AclEntry entry2 : aclBuilder) {
            if (prevEntry != null && ACL_ENTRY_COMPARATOR.compare(prevEntry, entry2) == 0) {
                throw new AclException("Invalid ACL: multiple entries with same scope, type and name.");
            }
            if (entry2.getName() != null && (entry2.getType() == AclEntryType.MASK || entry2.getType() == AclEntryType.OTHER)) {
                throw new AclException("Invalid ACL: this entry type must not have a name: " + entry2 + ".");
            }
            prevEntry = entry2;
        }
        ScopedAclEntries scopedEntries = new ScopedAclEntries(aclBuilder);
        for (AclEntryType type : EnumSet.of(AclEntryType.USER, AclEntryType.GROUP, AclEntryType.OTHER)) {
            AclEntry accessEntryKey = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(type).build();
            if (Collections.binarySearch(scopedEntries.getAccessEntries(), accessEntryKey, ACL_ENTRY_COMPARATOR) < 0) {
                throw new AclException("Invalid ACL: the user, group and other entries are required.");
            }
            if (scopedEntries.getDefaultEntries().isEmpty()) continue;
            AclEntry defaultEntryKey = new AclEntry.Builder().setScope(AclEntryScope.DEFAULT).setType(type).build();
            if (Collections.binarySearch(scopedEntries.getDefaultEntries(), defaultEntryKey, ACL_ENTRY_COMPARATOR) >= 0) continue;
            throw new AclException("Invalid default ACL: the user, group and other entries are required.");
        }
        return Collections.unmodifiableList(aclBuilder);
    }

    private static void calculateMasks(List<AclEntry> aclBuilder, EnumMap<AclEntryScope, AclEntry> providedMask, EnumSet<AclEntryScope> maskDirty, EnumSet<AclEntryScope> scopeDirty) throws AclException {
        EnumSet<AclEntryScope> scopeFound = EnumSet.noneOf(AclEntryScope.class);
        EnumMap unionPerms = Maps.newEnumMap(AclEntryScope.class);
        EnumSet<AclEntryScope> maskNeeded = EnumSet.noneOf(AclEntryScope.class);
        for (AclEntry entry2 : aclBuilder) {
            scopeFound.add(entry2.getScope());
            if (entry2.getType() == AclEntryType.GROUP || entry2.getName() != null) {
                FsAction scopeUnionPerms = (FsAction)Objects.firstNonNull(unionPerms.get(entry2.getScope()), (Object)FsAction.NONE);
                unionPerms.put(entry2.getScope(), scopeUnionPerms.or(entry2.getPermission()));
            }
            if (entry2.getName() == null) continue;
            maskNeeded.add(entry2.getScope());
        }
        for (AclEntryScope scope : scopeFound) {
            if (!providedMask.containsKey(scope) && maskNeeded.contains(scope) && maskDirty.contains(scope)) {
                throw new AclException("Invalid ACL: mask is required and cannot be deleted.");
            }
            if (providedMask.containsKey(scope) && (!scopeDirty.contains(scope) || maskDirty.contains(scope))) {
                aclBuilder.add(providedMask.get(scope));
                continue;
            }
            if (!maskNeeded.contains(scope) && !providedMask.containsKey(scope)) continue;
            aclBuilder.add(new AclEntry.Builder().setScope(scope).setType(AclEntryType.MASK).setPermission((FsAction)unionPerms.get(scope)).build());
        }
    }

    private static void copyDefaultsIfNeeded(List<AclEntry> aclBuilder) {
        Collections.sort(aclBuilder, ACL_ENTRY_COMPARATOR);
        ScopedAclEntries scopedEntries = new ScopedAclEntries(aclBuilder);
        if (!scopedEntries.getDefaultEntries().isEmpty()) {
            List accessEntries = scopedEntries.getAccessEntries();
            List defaultEntries = scopedEntries.getDefaultEntries();
            ArrayList copiedEntries = Lists.newArrayListWithCapacity((int)3);
            for (AclEntryType type : EnumSet.of(AclEntryType.USER, AclEntryType.GROUP, AclEntryType.OTHER)) {
                AclEntry accessEntryKey;
                int accessEntryIndex;
                AclEntry defaultEntryKey = new AclEntry.Builder().setScope(AclEntryScope.DEFAULT).setType(type).build();
                int defaultEntryIndex = Collections.binarySearch(defaultEntries, defaultEntryKey, ACL_ENTRY_COMPARATOR);
                if (defaultEntryIndex >= 0 || (accessEntryIndex = Collections.binarySearch(accessEntries, accessEntryKey = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(type).build(), ACL_ENTRY_COMPARATOR)) < 0) continue;
                copiedEntries.add(new AclEntry.Builder().setScope(AclEntryScope.DEFAULT).setType(type).setPermission(((AclEntry)accessEntries.get(accessEntryIndex)).getPermission()).build());
            }
            aclBuilder.addAll(copiedEntries);
        }
    }

    private static final class ValidatedAclSpec
    implements Iterable<AclEntry> {
        private final List<AclEntry> aclSpec;

        public ValidatedAclSpec(List<AclEntry> aclSpec) throws AclException {
            if (aclSpec.size() > 32) {
                throw new AclException("Invalid ACL: ACL spec has " + aclSpec.size() + " entries, which exceeds maximum of " + 32 + ".");
            }
            Collections.sort(aclSpec, ACL_ENTRY_COMPARATOR);
            this.aclSpec = aclSpec;
        }

        public boolean containsKey(AclEntry key) {
            return Collections.binarySearch(this.aclSpec, key, ACL_ENTRY_COMPARATOR) >= 0;
        }

        public AclEntry findByKey(AclEntry key) {
            int index = Collections.binarySearch(this.aclSpec, key, ACL_ENTRY_COMPARATOR);
            if (index >= 0) {
                return this.aclSpec.get(index);
            }
            return null;
        }

        @Override
        public Iterator<AclEntry> iterator() {
            return this.aclSpec.iterator();
        }
    }
}

