/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class EditLogInputStream
implements Closeable {
    private FSEditLogOp cachedOp = null;

    public String getCurrentStreamName() {
        return this.getName();
    }

    public abstract String getName();

    public abstract long getFirstTxId();

    public abstract long getLastTxId();

    @Override
    public abstract void close() throws IOException;

    public FSEditLogOp readOp() throws IOException {
        if (this.cachedOp != null) {
            FSEditLogOp ret = this.cachedOp;
            this.cachedOp = null;
            return ret;
        }
        return this.nextOp();
    }

    public void resync() {
        if (this.cachedOp != null) {
            return;
        }
        this.cachedOp = this.nextValidOp();
    }

    protected abstract FSEditLogOp nextOp() throws IOException;

    protected long scanNextOp() throws IOException {
        FSEditLogOp next2 = this.readOp();
        return next2 != null ? next2.txid : -12345L;
    }

    protected FSEditLogOp nextValidOp() {
        try {
            return this.nextOp();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public boolean skipUntil(long txid) throws IOException {
        FSEditLogOp op;
        do {
            if ((op = this.readOp()) != null) continue;
            return false;
        } while (op.getTransactionId() < txid);
        this.cachedOp = op;
        return true;
    }

    FSEditLogOp getCachedOp() {
        FSEditLogOp op = this.cachedOp;
        this.cachedOp = null;
        return op;
    }

    public abstract int getVersion(boolean var1) throws IOException;

    public abstract long getPosition();

    public abstract long length() throws IOException;

    public abstract boolean isInProgress();

    public abstract void setMaxOpSize(int var1);

    public abstract boolean isLocalLog();
}

