/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.GeneratedMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.FSImageCompression;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatPBINode;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceContext;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FSImageFormatPBSnapshot;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.util.LimitInputStream;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.collect.Lists;
import org.spark-project.guava.collect.Maps;

@InterfaceAudience.Private
public final class FSImageFormatProtobuf {
    private static final Logger LOG = LoggerFactory.getLogger(FSImageFormatProtobuf.class);

    private static int getOndiskTrunkSize(GeneratedMessage s) {
        return CodedOutputStream.computeRawVarint32Size((int)s.getSerializedSize()) + s.getSerializedSize();
    }

    private FSImageFormatProtobuf() {
    }

    public static enum SectionName {
        NS_INFO("NS_INFO"),
        STRING_TABLE("STRING_TABLE"),
        EXTENDED_ACL("EXTENDED_ACL"),
        INODE("INODE"),
        INODE_REFERENCE("INODE_REFERENCE"),
        SNAPSHOT("SNAPSHOT"),
        INODE_DIR("INODE_DIR"),
        FILES_UNDERCONSTRUCTION("FILES_UNDERCONSTRUCTION"),
        SNAPSHOT_DIFF("SNAPSHOT_DIFF"),
        SECRET_MANAGER("SECRET_MANAGER"),
        CACHE_MANAGER("CACHE_MANAGER");

        private static final SectionName[] values;
        private final String name;

        public static SectionName fromString(String name) {
            for (SectionName n : values) {
                if (!n.name.equals(name)) continue;
                return n;
            }
            return null;
        }

        private SectionName(String name) {
            this.name = name;
        }

        static {
            values = SectionName.values();
        }
    }

    public static final class Saver {
        public static final int CHECK_CANCEL_INTERVAL = 4096;
        private final SaveNamespaceContext context;
        private final SaverContext saverContext;
        private long currentOffset = FSImageUtil.MAGIC_HEADER.length;
        private MD5Hash savedDigest;
        private FileChannel fileChannel;
        private OutputStream sectionOutputStream;
        private CompressionCodec codec;
        private OutputStream underlyingOutputStream;

        Saver(SaveNamespaceContext context) {
            this.context = context;
            this.saverContext = new SaverContext();
        }

        public MD5Hash getSavedDigest() {
            return this.savedDigest;
        }

        public SaveNamespaceContext getContext() {
            return this.context;
        }

        public SaverContext getSaverContext() {
            return this.saverContext;
        }

        public void commitSection(FsImageProto.FileSummary.Builder summary, SectionName name) throws IOException {
            long oldOffset = this.currentOffset;
            this.flushSectionOutputStream();
            this.sectionOutputStream = this.codec != null ? this.codec.createOutputStream(this.underlyingOutputStream) : this.underlyingOutputStream;
            long length = this.fileChannel.position() - oldOffset;
            summary.addSections(FsImageProto.FileSummary.Section.newBuilder().setName(name.name).setLength(length).setOffset(this.currentOffset));
            this.currentOffset += length;
        }

        private void flushSectionOutputStream() throws IOException {
            if (this.codec != null) {
                ((CompressorStream)this.sectionOutputStream).finish();
            }
            this.sectionOutputStream.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save(File file, FSImageCompression compression) throws IOException {
            FileOutputStream fout = new FileOutputStream(file);
            this.fileChannel = fout.getChannel();
            try {
                LOG.info("Saving image file {} using {}", (Object)file, (Object)compression);
                long startTime = Time.monotonicNow();
                this.saveInternal(fout, compression, file.getAbsolutePath());
                LOG.info("Image file {} of size {} bytes saved in {} seconds.", new Object[]{file, file.length(), (Time.monotonicNow() - startTime) / 1000L});
            }
            finally {
                fout.close();
            }
        }

        private static void saveFileSummary(OutputStream out, FsImageProto.FileSummary summary) throws IOException {
            summary.writeDelimitedTo(out);
            int length = FSImageFormatProtobuf.getOndiskTrunkSize(summary);
            byte[] lengthBytes = new byte[4];
            ByteBuffer.wrap(lengthBytes).asIntBuffer().put(length);
            out.write(lengthBytes);
        }

        private void saveInodes(FsImageProto.FileSummary.Builder summary) throws IOException {
            FSImageFormatPBINode.Saver saver = new FSImageFormatPBINode.Saver(this, summary);
            saver.serializeINodeSection(this.sectionOutputStream);
            saver.serializeINodeDirectorySection(this.sectionOutputStream);
            saver.serializeFilesUCSection(this.sectionOutputStream);
        }

        private void saveSnapshots(FsImageProto.FileSummary.Builder summary) throws IOException {
            FSImageFormatPBSnapshot.Saver snapshotSaver = new FSImageFormatPBSnapshot.Saver(this, summary, this.context, this.context.getSourceNamesystem());
            snapshotSaver.serializeSnapshotSection(this.sectionOutputStream);
            snapshotSaver.serializeSnapshotDiffSection(this.sectionOutputStream);
            snapshotSaver.serializeINodeReferenceSection(this.sectionOutputStream);
        }

        private void saveInternal(FileOutputStream fout, FSImageCompression compression, String filePath) throws IOException {
            StartupProgress prog = NameNode.getStartupProgress();
            MessageDigest digester = MD5Hash.getDigester();
            this.underlyingOutputStream = new DigestOutputStream(new BufferedOutputStream(fout), digester);
            this.underlyingOutputStream.write(FSImageUtil.MAGIC_HEADER);
            this.fileChannel = fout.getChannel();
            FsImageProto.FileSummary.Builder b = FsImageProto.FileSummary.newBuilder().setOndiskVersion(1).setLayoutVersion(this.context.getSourceNamesystem().getEffectiveLayoutVersion());
            this.codec = compression.getImageCodec();
            if (this.codec != null) {
                b.setCodec(this.codec.getClass().getCanonicalName());
                this.sectionOutputStream = this.codec.createOutputStream(this.underlyingOutputStream);
            } else {
                this.sectionOutputStream = this.underlyingOutputStream;
            }
            this.saveNameSystemSection(b);
            this.context.checkCancelled();
            Step step = new Step(StepType.INODES, filePath);
            prog.beginStep(Phase.SAVING_CHECKPOINT, step);
            this.saveInodes(b);
            this.saveSnapshots(b);
            prog.endStep(Phase.SAVING_CHECKPOINT, step);
            step = new Step(StepType.DELEGATION_TOKENS, filePath);
            prog.beginStep(Phase.SAVING_CHECKPOINT, step);
            this.saveSecretManagerSection(b);
            prog.endStep(Phase.SAVING_CHECKPOINT, step);
            step = new Step(StepType.CACHE_POOLS, filePath);
            prog.beginStep(Phase.SAVING_CHECKPOINT, step);
            this.saveCacheManagerSection(b);
            prog.endStep(Phase.SAVING_CHECKPOINT, step);
            this.saveStringTableSection(b);
            this.flushSectionOutputStream();
            FsImageProto.FileSummary summary = b.build();
            Saver.saveFileSummary(this.underlyingOutputStream, summary);
            this.underlyingOutputStream.close();
            this.savedDigest = new MD5Hash(digester.digest());
        }

        private void saveSecretManagerSection(FsImageProto.FileSummary.Builder summary) throws IOException {
            FSNamesystem fsn = this.context.getSourceNamesystem();
            DelegationTokenSecretManager.SecretManagerState state = fsn.saveSecretManagerState();
            state.section.writeDelimitedTo(this.sectionOutputStream);
            for (FsImageProto.SecretManagerSection.DelegationKey k : state.keys) {
                k.writeDelimitedTo(this.sectionOutputStream);
            }
            for (FsImageProto.SecretManagerSection.PersistToken t : state.tokens) {
                t.writeDelimitedTo(this.sectionOutputStream);
            }
            this.commitSection(summary, SectionName.SECRET_MANAGER);
        }

        private void saveCacheManagerSection(FsImageProto.FileSummary.Builder summary) throws IOException {
            FSNamesystem fsn = this.context.getSourceNamesystem();
            CacheManager.PersistState state = fsn.getCacheManager().saveState();
            state.section.writeDelimitedTo(this.sectionOutputStream);
            for (ClientNamenodeProtocolProtos.CachePoolInfoProto cachePoolInfoProto : state.pools) {
                cachePoolInfoProto.writeDelimitedTo(this.sectionOutputStream);
            }
            for (ClientNamenodeProtocolProtos.CacheDirectiveInfoProto cacheDirectiveInfoProto : state.directives) {
                cacheDirectiveInfoProto.writeDelimitedTo(this.sectionOutputStream);
            }
            this.commitSection(summary, SectionName.CACHE_MANAGER);
        }

        private void saveNameSystemSection(FsImageProto.FileSummary.Builder summary) throws IOException {
            FSNamesystem fsn = this.context.getSourceNamesystem();
            OutputStream out = this.sectionOutputStream;
            BlockIdManager blockIdManager = fsn.getBlockIdManager();
            FsImageProto.NameSystemSection.Builder b = FsImageProto.NameSystemSection.newBuilder().setGenstampV1(blockIdManager.getGenerationStampV1()).setGenstampV1Limit(blockIdManager.getGenerationStampV1Limit()).setGenstampV2(blockIdManager.getGenerationStampV2()).setLastAllocatedBlockId(blockIdManager.getLastAllocatedBlockId()).setTransactionId(this.context.getTxId());
            b.setNamespaceId(fsn.unprotectedGetNamespaceInfo().getNamespaceID());
            if (fsn.isRollingUpgrade()) {
                b.setRollingUpgradeStartTime(fsn.getRollingUpgradeInfo().getStartTime());
            }
            FsImageProto.NameSystemSection s = b.build();
            s.writeDelimitedTo(out);
            this.commitSection(summary, SectionName.NS_INFO);
        }

        private void saveStringTableSection(FsImageProto.FileSummary.Builder summary) throws IOException {
            OutputStream out = this.sectionOutputStream;
            FsImageProto.StringTableSection.Builder b = FsImageProto.StringTableSection.newBuilder().setNumEntry(this.saverContext.stringMap.size());
            b.build().writeDelimitedTo(out);
            for (Map.Entry e : this.saverContext.stringMap.entrySet()) {
                FsImageProto.StringTableSection.Entry.Builder eb = FsImageProto.StringTableSection.Entry.newBuilder().setId(e.getValue()).setStr((String)e.getKey());
                eb.build().writeDelimitedTo(out);
            }
            this.commitSection(summary, SectionName.STRING_TABLE);
        }
    }

    public static final class Loader
    implements FSImageFormat.AbstractLoader {
        static final int MINIMUM_FILE_LENGTH = 8;
        private final Configuration conf;
        private final FSNamesystem fsn;
        private final LoaderContext ctx;
        private MD5Hash imgDigest;
        private long imgTxId;
        private final boolean requireSameLayoutVersion;

        Loader(Configuration conf, FSNamesystem fsn, boolean requireSameLayoutVersion) {
            this.conf = conf;
            this.fsn = fsn;
            this.ctx = new LoaderContext();
            this.requireSameLayoutVersion = requireSameLayoutVersion;
        }

        @Override
        public MD5Hash getLoadedImageMd5() {
            return this.imgDigest;
        }

        @Override
        public long getLoadedImageTxId() {
            return this.imgTxId;
        }

        public LoaderContext getLoaderContext() {
            return this.ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void load(File file) throws IOException {
            long start2 = Time.monotonicNow();
            this.imgDigest = MD5FileUtils.computeMd5ForFile(file);
            RandomAccessFile raFile = new RandomAccessFile(file, "r");
            FileInputStream fin = new FileInputStream(file);
            try {
                this.loadInternal(raFile, fin);
                long end = Time.monotonicNow();
                LOG.info("Loaded FSImage in {} seconds.", (Object)((end - start2) / 1000L));
            }
            finally {
                fin.close();
                raFile.close();
            }
        }

        private void loadInternal(RandomAccessFile raFile, FileInputStream fin) throws IOException {
            if (!FSImageUtil.checkFileFormat(raFile)) {
                throw new IOException("Unrecognized file format");
            }
            FsImageProto.FileSummary summary = FSImageUtil.loadSummary(raFile);
            if (this.requireSameLayoutVersion && summary.getLayoutVersion() != HdfsConstants.NAMENODE_LAYOUT_VERSION) {
                throw new IOException("Image version " + summary.getLayoutVersion() + " is not equal to the software version " + HdfsConstants.NAMENODE_LAYOUT_VERSION);
            }
            FileChannel channel = fin.getChannel();
            FSImageFormatPBINode.Loader inodeLoader = new FSImageFormatPBINode.Loader(this.fsn, this);
            FSImageFormatPBSnapshot.Loader snapshotLoader = new FSImageFormatPBSnapshot.Loader(this.fsn, this);
            ArrayList sections = Lists.newArrayList(summary.getSectionsList());
            Collections.sort(sections, new Comparator<FsImageProto.FileSummary.Section>(){

                @Override
                public int compare(FsImageProto.FileSummary.Section s1, FsImageProto.FileSummary.Section s2) {
                    SectionName n1 = SectionName.fromString(s1.getName());
                    SectionName n2 = SectionName.fromString(s2.getName());
                    if (n1 == null) {
                        return n2 == null ? 0 : -1;
                    }
                    if (n2 == null) {
                        return -1;
                    }
                    return n1.ordinal() - n2.ordinal();
                }
            });
            StartupProgress prog = NameNode.getStartupProgress();
            Step currentStep = null;
            block12: for (FsImageProto.FileSummary.Section s : sections) {
                channel.position(s.getOffset());
                InputStream in = new BufferedInputStream((InputStream)new LimitInputStream((InputStream)fin, s.getLength()));
                in = FSImageUtil.wrapInputStreamForCompression(this.conf, summary.getCodec(), in);
                String n = s.getName();
                switch (SectionName.fromString(n)) {
                    case NS_INFO: {
                        this.loadNameSystemSection(in);
                        continue block12;
                    }
                    case STRING_TABLE: {
                        this.loadStringTableSection(in);
                        continue block12;
                    }
                    case INODE: {
                        currentStep = new Step(StepType.INODES);
                        prog.beginStep(Phase.LOADING_FSIMAGE, currentStep);
                        inodeLoader.loadINodeSection(in);
                        continue block12;
                    }
                    case INODE_REFERENCE: {
                        snapshotLoader.loadINodeReferenceSection(in);
                        continue block12;
                    }
                    case INODE_DIR: {
                        inodeLoader.loadINodeDirectorySection(in);
                        continue block12;
                    }
                    case FILES_UNDERCONSTRUCTION: {
                        inodeLoader.loadFilesUnderConstructionSection(in);
                        continue block12;
                    }
                    case SNAPSHOT: {
                        snapshotLoader.loadSnapshotSection(in);
                        continue block12;
                    }
                    case SNAPSHOT_DIFF: {
                        snapshotLoader.loadSnapshotDiffSection(in);
                        continue block12;
                    }
                    case SECRET_MANAGER: {
                        prog.endStep(Phase.LOADING_FSIMAGE, currentStep);
                        Step step = new Step(StepType.DELEGATION_TOKENS);
                        prog.beginStep(Phase.LOADING_FSIMAGE, step);
                        this.loadSecretManagerSection(in);
                        prog.endStep(Phase.LOADING_FSIMAGE, step);
                        continue block12;
                    }
                    case CACHE_MANAGER: {
                        Step step = new Step(StepType.CACHE_POOLS);
                        prog.beginStep(Phase.LOADING_FSIMAGE, step);
                        this.loadCacheManagerSection(in);
                        prog.endStep(Phase.LOADING_FSIMAGE, step);
                        continue block12;
                    }
                }
                LOG.warn("Unrecognized section {}", (Object)n);
            }
        }

        private void loadNameSystemSection(InputStream in) throws IOException {
            FsImageProto.NameSystemSection s = FsImageProto.NameSystemSection.parseDelimitedFrom(in);
            BlockIdManager blockIdManager = this.fsn.getBlockIdManager();
            blockIdManager.setGenerationStampV1(s.getGenstampV1());
            blockIdManager.setGenerationStampV2(s.getGenstampV2());
            blockIdManager.setGenerationStampV1Limit(s.getGenstampV1Limit());
            blockIdManager.setLastAllocatedBlockId(s.getLastAllocatedBlockId());
            this.imgTxId = s.getTransactionId();
            if (s.hasRollingUpgradeStartTime() && this.fsn.getFSImage().hasRollbackFSImage()) {
                this.fsn.setRollingUpgradeInfo(true, s.getRollingUpgradeStartTime());
            }
        }

        private void loadStringTableSection(InputStream in) throws IOException {
            FsImageProto.StringTableSection s = FsImageProto.StringTableSection.parseDelimitedFrom(in);
            LoaderContext.access$102(this.ctx, new String[s.getNumEntry() + 1]);
            for (int i = 0; i < s.getNumEntry(); ++i) {
                FsImageProto.StringTableSection.Entry e = FsImageProto.StringTableSection.Entry.parseDelimitedFrom(in);
                ((LoaderContext)this.ctx).stringTable[e.getId()] = e.getStr();
            }
        }

        private void loadSecretManagerSection(InputStream in) throws IOException {
            int i;
            FsImageProto.SecretManagerSection s = FsImageProto.SecretManagerSection.parseDelimitedFrom(in);
            int numKeys = s.getNumKeys();
            int numTokens = s.getNumTokens();
            ArrayList keys = Lists.newArrayListWithCapacity((int)numKeys);
            ArrayList tokens = Lists.newArrayListWithCapacity((int)numTokens);
            for (i = 0; i < numKeys; ++i) {
                keys.add(FsImageProto.SecretManagerSection.DelegationKey.parseDelimitedFrom(in));
            }
            for (i = 0; i < numTokens; ++i) {
                tokens.add(FsImageProto.SecretManagerSection.PersistToken.parseDelimitedFrom(in));
            }
            this.fsn.loadSecretManagerState(s, keys, tokens);
        }

        private void loadCacheManagerSection(InputStream in) throws IOException {
            int i;
            FsImageProto.CacheManagerSection s = FsImageProto.CacheManagerSection.parseDelimitedFrom(in);
            ArrayList pools = Lists.newArrayListWithCapacity((int)s.getNumPools());
            ArrayList directives = Lists.newArrayListWithCapacity((int)s.getNumDirectives());
            for (i = 0; i < s.getNumPools(); ++i) {
                pools.add(ClientNamenodeProtocolProtos.CachePoolInfoProto.parseDelimitedFrom(in));
            }
            for (i = 0; i < s.getNumDirectives(); ++i) {
                directives.add(ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.parseDelimitedFrom(in));
            }
            this.fsn.getCacheManager().loadState(new CacheManager.PersistState(s, pools, directives));
        }
    }

    public static final class SaverContext {
        private final ArrayList<INodeReference> refList = Lists.newArrayList();
        private final DeduplicationMap<String> stringMap = DeduplicationMap.newMap();

        public DeduplicationMap<String> getStringMap() {
            return this.stringMap;
        }

        public ArrayList<INodeReference> getRefList() {
            return this.refList;
        }

        public static class DeduplicationMap<E> {
            private final Map<E, Integer> map = Maps.newHashMap();

            private DeduplicationMap() {
            }

            static <T> DeduplicationMap<T> newMap() {
                return new DeduplicationMap();
            }

            int getId(E value2) {
                if (value2 == null) {
                    return 0;
                }
                Integer v = this.map.get(value2);
                if (v == null) {
                    int nv = this.map.size() + 1;
                    this.map.put(value2, nv);
                    return nv;
                }
                return v;
            }

            int size() {
                return this.map.size();
            }

            Set<Map.Entry<E, Integer>> entrySet() {
                return this.map.entrySet();
            }
        }
    }

    public static final class LoaderContext {
        private String[] stringTable;
        private final ArrayList<INodeReference> refList = Lists.newArrayList();

        public String[] getStringTable() {
            return this.stringTable;
        }

        public ArrayList<INodeReference> getRefList() {
            return this.refList;
        }

        static /* synthetic */ String[] access$102(LoaderContext x0, String[] x1) {
            x0.stringTable = x1;
            return x1;
        }
    }
}

