/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.spark-project.guava.base.Preconditions;

@InterfaceAudience.Private
public interface INodeDirectoryAttributes
extends INodeAttributes {
    public QuotaCounts getQuotaCounts();

    public boolean metadataEquals(INodeDirectoryAttributes var1);

    public static class CopyWithQuota
    extends SnapshotCopy {
        private QuotaCounts quota;

        public CopyWithQuota(byte[] name, PermissionStatus permissions, AclFeature aclFeature, long modificationTime, long nsQuota, long dsQuota, EnumCounters<StorageType> typeQuotas, XAttrFeature xAttrsFeature) {
            super(name, permissions, aclFeature, modificationTime, xAttrsFeature);
            this.quota = new QuotaCounts.Builder().nameSpace(nsQuota).storageSpace(dsQuota).typeSpaces(typeQuotas).build();
        }

        public CopyWithQuota(INodeDirectory dir) {
            super(dir);
            Preconditions.checkArgument((boolean)dir.isQuotaSet());
            QuotaCounts q = dir.getQuotaCounts();
            this.quota = new QuotaCounts.Builder().quotaCount(q).build();
        }

        @Override
        public QuotaCounts getQuotaCounts() {
            return new QuotaCounts.Builder().quotaCount(this.quota).build();
        }
    }

    public static class SnapshotCopy
    extends INodeAttributes.SnapshotCopy
    implements INodeDirectoryAttributes {
        public SnapshotCopy(byte[] name, PermissionStatus permissions, AclFeature aclFeature, long modificationTime, XAttrFeature xAttrsFeature) {
            super(name, permissions, aclFeature, modificationTime, 0L, xAttrsFeature);
        }

        public SnapshotCopy(INodeDirectory dir) {
            super(dir);
        }

        @Override
        public QuotaCounts getQuotaCounts() {
            return new QuotaCounts.Builder().nameSpace(-1L).storageSpace(-1L).typeSpaces(-1L).build();
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean metadataEquals(INodeDirectoryAttributes other) {
            return other != null && this.getQuotaCounts().equals(other.getQuotaCounts()) && this.getPermissionLong() == other.getPermissionLong() && this.getAclFeature() == other.getAclFeature() && this.getXAttrFeature() == other.getXAttrFeature();
        }
    }
}

