/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshotFeature;
import org.apache.hadoop.hdfs.util.LongBitFormat;
import org.spark-project.guava.annotations.VisibleForTesting;
import org.spark-project.guava.base.Preconditions;

@InterfaceAudience.Private
public class INodeFile
extends INodeWithAdditionalFields
implements INodeFileAttributes,
BlockCollection {
    private long header = 0L;
    private BlockInfoContiguous[] blocks;

    public static INodeFile valueOf(INode inode, String path) throws FileNotFoundException {
        return INodeFile.valueOf(inode, path, false);
    }

    public static INodeFile valueOf(INode inode, String path, boolean acceptNull) throws FileNotFoundException {
        if (inode == null) {
            if (acceptNull) {
                return null;
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!inode.isFile()) {
            throw new FileNotFoundException("Path is not a file: " + path);
        }
        return inode.asFile();
    }

    INodeFile(long id, byte[] name, PermissionStatus permissions, long mtime, long atime, BlockInfoContiguous[] blklist, short replication, long preferredBlockSize) {
        this(id, name, permissions, mtime, atime, blklist, replication, preferredBlockSize, 0);
    }

    INodeFile(long id, byte[] name, PermissionStatus permissions, long mtime, long atime, BlockInfoContiguous[] blklist, short replication, long preferredBlockSize, byte storagePolicyID) {
        super(id, name, permissions, mtime, atime);
        this.header = HeaderFormat.toLong(preferredBlockSize, replication, storagePolicyID);
        this.blocks = blklist;
    }

    public INodeFile(INodeFile that) {
        super(that);
        this.header = that.header;
        this.blocks = that.blocks;
        this.features = that.features;
    }

    public INodeFile(INodeFile that, FileDiffList diffs) {
        this(that);
        Preconditions.checkArgument((!that.isWithSnapshot() ? 1 : 0) != 0);
        this.addSnapshotFeature(diffs);
    }

    @Override
    public final boolean isFile() {
        return true;
    }

    @Override
    public final INodeFile asFile() {
        return this;
    }

    @Override
    public boolean metadataEquals(INodeFileAttributes other) {
        return other != null && this.getHeaderLong() == other.getHeaderLong() && this.getPermissionLong() == other.getPermissionLong() && this.getAclFeature() == other.getAclFeature() && this.getXAttrFeature() == other.getXAttrFeature();
    }

    public final FileUnderConstructionFeature getFileUnderConstructionFeature() {
        return (FileUnderConstructionFeature)this.getFeature(FileUnderConstructionFeature.class);
    }

    @Override
    public boolean isUnderConstruction() {
        return this.getFileUnderConstructionFeature() != null;
    }

    INodeFile toUnderConstruction(String clientName, String clientMachine) {
        Preconditions.checkState((!this.isUnderConstruction() ? 1 : 0) != 0, (Object)"file is already under construction");
        FileUnderConstructionFeature uc = new FileUnderConstructionFeature(clientName, clientMachine);
        this.addFeature(uc);
        return this;
    }

    public INodeFile toCompleteFile(long mtime) {
        Preconditions.checkState((boolean)this.isUnderConstruction(), (Object)"file is no longer under construction");
        FileUnderConstructionFeature uc = this.getFileUnderConstructionFeature();
        if (uc != null) {
            this.assertAllBlocksComplete();
            this.removeFeature(uc);
            this.setModificationTime(mtime);
        }
        return this;
    }

    private void assertAllBlocksComplete() {
        if (this.blocks == null) {
            return;
        }
        for (int i = 0; i < this.blocks.length; ++i) {
            Preconditions.checkState((boolean)this.blocks[i].isComplete(), (String)"Failed to finalize %s %s since blocks[%s] is non-complete, where blocks=%s.", (Object[])new Object[]{this.getClass().getSimpleName(), this, i, Arrays.asList(this.blocks)});
        }
    }

    @Override
    public void setBlock(int index, BlockInfoContiguous blk) {
        this.blocks[index] = blk;
    }

    @Override
    public BlockInfoContiguousUnderConstruction setLastBlock(BlockInfoContiguous lastBlock, DatanodeStorageInfo[] locations) throws IOException {
        Preconditions.checkState((boolean)this.isUnderConstruction(), (Object)"file is no longer under construction");
        if (this.numBlocks() == 0) {
            throw new IOException("Failed to set last block: File is empty.");
        }
        BlockInfoContiguousUnderConstruction ucBlock = lastBlock.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, locations);
        this.setBlock(this.numBlocks() - 1, ucBlock);
        return ucBlock;
    }

    boolean removeLastBlock(Block oldblock) {
        Preconditions.checkState((boolean)this.isUnderConstruction(), (Object)"file is no longer under construction");
        if (this.blocks == null || this.blocks.length == 0) {
            return false;
        }
        int size_1 = this.blocks.length - 1;
        if (!this.blocks[size_1].equals(oldblock)) {
            return false;
        }
        BlockInfoContiguous[] newlist = new BlockInfoContiguous[size_1];
        System.arraycopy(this.blocks, 0, newlist, 0, size_1);
        this.setBlocks(newlist);
        return true;
    }

    public FileWithSnapshotFeature addSnapshotFeature(FileDiffList diffs) {
        Preconditions.checkState((!this.isWithSnapshot() ? 1 : 0) != 0, (Object)"File is already with snapshot");
        FileWithSnapshotFeature sf = new FileWithSnapshotFeature(diffs);
        this.addFeature(sf);
        return sf;
    }

    public final FileWithSnapshotFeature getFileWithSnapshotFeature() {
        return (FileWithSnapshotFeature)this.getFeature(FileWithSnapshotFeature.class);
    }

    public final boolean isWithSnapshot() {
        return this.getFileWithSnapshotFeature() != null;
    }

    @Override
    public String toDetailString() {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        return super.toDetailString() + (sf == null ? "" : sf.getDetailedString());
    }

    @Override
    public INodeFileAttributes getSnapshotINode(int snapshotId) {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            return sf.getDiffs().getSnapshotINode(snapshotId, this);
        }
        return this;
    }

    @Override
    public void recordModification(int latestSnapshotId) {
        this.recordModification(latestSnapshotId, false);
    }

    public void recordModification(int latestSnapshotId, boolean withBlocks) {
        if (this.isInLatestSnapshot(latestSnapshotId) && !this.shouldRecordInSrcSnapshot(latestSnapshotId)) {
            FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
            if (sf == null) {
                sf = this.addSnapshotFeature(null);
            }
            sf.getDiffs().saveSelf2Snapshot(latestSnapshotId, this, null, withBlocks);
        }
    }

    public FileDiffList getDiffs() {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            return sf.getDiffs();
        }
        return null;
    }

    public final short getFileReplication(int snapshot) {
        if (snapshot != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshot).getFileReplication();
        }
        return HeaderFormat.getReplication(this.header);
    }

    @Override
    public final short getFileReplication() {
        return this.getFileReplication(0x7FFFFFFE);
    }

    @Override
    public short getBlockReplication() {
        short max = this.getFileReplication(0x7FFFFFFE);
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            short maxInSnapshot = sf.getMaxBlockRepInDiffs();
            if (sf.isCurrentFileDeleted()) {
                return maxInSnapshot;
            }
            max = maxInSnapshot > max ? maxInSnapshot : max;
        }
        return max;
    }

    public final void setFileReplication(short replication) {
        this.header = HeaderFormat.REPLICATION.BITS.combine(replication, this.header);
    }

    public final INodeFile setFileReplication(short replication, int latestSnapshotId) throws QuotaExceededException {
        this.recordModification(latestSnapshotId);
        this.setFileReplication(replication);
        return this;
    }

    @Override
    public long getPreferredBlockSize() {
        return HeaderFormat.getPreferredBlockSize(this.header);
    }

    @Override
    public byte getLocalStoragePolicyID() {
        return HeaderFormat.getStoragePolicyID(this.header);
    }

    @Override
    public byte getStoragePolicyID() {
        byte id = this.getLocalStoragePolicyID();
        if (id == 0) {
            return this.getParent() != null ? this.getParent().getStoragePolicyID() : id;
        }
        return id;
    }

    private void setStoragePolicyID(byte storagePolicyId) {
        this.header = HeaderFormat.STORAGE_POLICY_ID.BITS.combine(storagePolicyId, this.header);
    }

    public final void setStoragePolicyID(byte storagePolicyId, int latestSnapshotId) throws QuotaExceededException {
        this.recordModification(latestSnapshotId);
        this.setStoragePolicyID(storagePolicyId);
    }

    @Override
    public long getHeaderLong() {
        return this.header;
    }

    final long getPreferredBlockStoragespace() {
        return this.getPreferredBlockSize() * (long)this.getBlockReplication();
    }

    @Override
    public BlockInfoContiguous[] getBlocks() {
        return this.blocks;
    }

    public BlockInfoContiguous[] getBlocks(int snapshot) {
        BlockInfoContiguous[] snapshotBlocks;
        if (snapshot == 0x7FFFFFFE || this.getDiffs() == null) {
            return this.getBlocks();
        }
        FileDiff diff = (FileDiff)this.getDiffs().getDiffById(snapshot);
        BlockInfoContiguous[] blockInfoContiguousArray = snapshotBlocks = diff == null ? this.getBlocks() : diff.getBlocks();
        if (snapshotBlocks != null) {
            return snapshotBlocks;
        }
        snapshotBlocks = this.getDiffs().findLaterSnapshotBlocks(snapshot);
        return snapshotBlocks == null ? this.getBlocks() : snapshotBlocks;
    }

    void updateBlockCollection() {
        if (this.blocks != null) {
            for (BlockInfoContiguous b : this.blocks) {
                b.setBlockCollection(this);
            }
        }
    }

    void concatBlocks(INodeFile[] inodes) {
        int size2 = this.blocks.length;
        int totalAddedBlocks = 0;
        for (INodeFile f : inodes) {
            totalAddedBlocks += f.blocks.length;
        }
        BlockInfoContiguous[] newlist = new BlockInfoContiguous[size2 + totalAddedBlocks];
        System.arraycopy(this.blocks, 0, newlist, 0, size2);
        for (INodeFile in : inodes) {
            System.arraycopy(in.blocks, 0, newlist, size2, in.blocks.length);
            size2 += in.blocks.length;
        }
        this.setBlocks(newlist);
        this.updateBlockCollection();
    }

    void addBlock(BlockInfoContiguous newblock) {
        if (this.blocks == null) {
            this.setBlocks(new BlockInfoContiguous[]{newblock});
        } else {
            int size2 = this.blocks.length;
            BlockInfoContiguous[] newlist = new BlockInfoContiguous[size2 + 1];
            System.arraycopy(this.blocks, 0, newlist, 0, size2);
            newlist[size2] = newblock;
            this.setBlocks(newlist);
        }
    }

    public void setBlocks(BlockInfoContiguous[] blocks) {
        this.blocks = blocks;
    }

    @Override
    public QuotaCounts cleanSubtree(BlockStoragePolicySuite bsps, int snapshot, int priorSnapshotId, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            return sf.cleanFile(bsps, this, snapshot, priorSnapshotId, collectedBlocks, removedINodes);
        }
        QuotaCounts counts = new QuotaCounts.Builder().build();
        if (snapshot == 0x7FFFFFFE) {
            if (priorSnapshotId == -1) {
                this.computeQuotaUsage(bsps, counts, false);
                this.destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
            } else {
                FileUnderConstructionFeature uc = this.getFileUnderConstructionFeature();
                if (uc != null) {
                    uc.cleanZeroSizeBlock(this, collectedBlocks);
                }
            }
        }
        return counts;
    }

    @Override
    public void destroyAndCollectBlocks(BlockStoragePolicySuite bsps, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        if (this.blocks != null && collectedBlocks != null) {
            for (BlockInfoContiguous blk : this.blocks) {
                collectedBlocks.addDeleteBlock(blk);
                blk.setBlockCollection(null);
            }
        }
        this.setBlocks(BlockInfoContiguous.EMPTY_ARRAY);
        if (this.getAclFeature() != null) {
            AclStorage.removeAclFeature(this.getAclFeature());
        }
        this.clear();
        removedINodes.add(this);
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            sf.getDiffs().destroyAndCollectSnapshotBlocks(collectedBlocks);
            sf.clearDiffs();
        }
    }

    @Override
    public String getName() {
        return this.getFullPathName();
    }

    @Override
    public final QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, QuotaCounts counts, boolean useCache, int lastSnapshotId) {
        short replication;
        long ssDeltaNoReplication;
        long nsDelta = 1L;
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            FileDiffList fileDiffList = sf.getDiffs();
            int last = fileDiffList.getLastSnapshotId();
            if (lastSnapshotId == 0x7FFFFFFE || last == 0x7FFFFFFE) {
                ssDeltaNoReplication = this.storagespaceConsumedNoReplication();
                replication = this.getBlockReplication();
            } else if (last < lastSnapshotId) {
                ssDeltaNoReplication = this.computeFileSize(true, false);
                replication = this.getFileReplication();
            } else {
                int sid = fileDiffList.getSnapshotById(lastSnapshotId);
                ssDeltaNoReplication = this.storagespaceConsumedNoReplication(sid);
                replication = this.getReplication(sid);
            }
        } else {
            ssDeltaNoReplication = this.storagespaceConsumedNoReplication();
            replication = this.getBlockReplication();
        }
        counts.addNameSpace(nsDelta);
        counts.addStorageSpace(ssDeltaNoReplication * (long)replication);
        if (blockStoragePolicyId != 0) {
            BlockStoragePolicy bsp = bsps.getPolicy(blockStoragePolicyId);
            List<StorageType> storageTypes = bsp.chooseStorageTypes(replication);
            for (StorageType t : storageTypes) {
                if (!t.supportTypeQuota()) continue;
                counts.addTypeSpace(t, ssDeltaNoReplication);
            }
        }
        return counts;
    }

    @Override
    public final ContentSummaryComputationContext computeContentSummary(int snapshotId, ContentSummaryComputationContext summary) {
        ContentCounts counts = summary.getCounts();
        counts.addContent(Content.FILE, 1L);
        long fileLen = this.computeFileSize(snapshotId);
        counts.addContent(Content.LENGTH, fileLen);
        counts.addContent(Content.DISKSPACE, this.storagespaceConsumed());
        if (this.getStoragePolicyID() != 0) {
            BlockStoragePolicy bsp = summary.getBlockStoragePolicySuite().getPolicy(this.getStoragePolicyID());
            List<StorageType> storageTypes = bsp.chooseStorageTypes(this.getFileReplication());
            for (StorageType t : storageTypes) {
                if (!t.supportTypeQuota()) continue;
                counts.addTypeSpace(t, fileLen);
            }
        }
        return summary;
    }

    public final long computeFileSize() {
        return this.computeFileSize(0x7FFFFFFE);
    }

    public final long computeFileSize(int snapshotId) {
        FileDiff d;
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (snapshotId != 0x7FFFFFFE && sf != null && (d = (FileDiff)sf.getDiffs().getDiffById(snapshotId)) != null) {
            return d.getFileSize();
        }
        return this.computeFileSize(true, false);
    }

    public final long computeFileSizeNotIncludingLastUcBlock() {
        return this.computeFileSize(false, false);
    }

    public final long computeFileSize(boolean includesLastUcBlock, boolean usePreferredBlockSize4LastUcBlock) {
        if (this.blocks == null || this.blocks.length == 0) {
            return 0L;
        }
        int last = this.blocks.length - 1;
        long size2 = this.blocks[last].getNumBytes();
        if (this.blocks[last] instanceof BlockInfoContiguousUnderConstruction) {
            if (!includesLastUcBlock) {
                size2 = 0L;
            } else if (usePreferredBlockSize4LastUcBlock) {
                size2 = this.getPreferredBlockSize();
            }
        }
        for (int i = 0; i < last; ++i) {
            size2 += this.blocks[i].getNumBytes();
        }
        return size2;
    }

    public final long storagespaceConsumed() {
        return this.storagespaceConsumedNoReplication() * (long)this.getBlockReplication();
    }

    public final long storagespaceConsumedNoReplication() {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf == null) {
            return this.computeFileSize(true, true);
        }
        long size2 = 0L;
        HashSet<BlockInfoContiguous> allBlocks = new HashSet<BlockInfoContiguous>(Arrays.asList(this.getBlocks()));
        List diffs = sf.getDiffs().asList();
        for (FileDiff fileDiff : diffs) {
            BlockInfoContiguous[] diffBlocks = fileDiff.getBlocks();
            if (diffBlocks == null) continue;
            allBlocks.addAll(Arrays.asList(diffBlocks));
        }
        for (Block block : allBlocks) {
            size2 += block.getNumBytes();
        }
        BlockInfoContiguous lastBlock = this.getLastBlock();
        if (lastBlock != null && lastBlock instanceof BlockInfoContiguousUnderConstruction) {
            size2 += this.getPreferredBlockSize() - lastBlock.getNumBytes();
        }
        return size2;
    }

    public final long storagespaceConsumed(int lastSnapshotId) {
        if (lastSnapshotId != 0x7FFFFFFE) {
            return this.computeFileSize(lastSnapshotId) * (long)this.getFileReplication(lastSnapshotId);
        }
        return this.storagespaceConsumed();
    }

    public final short getReplication(int lastSnapshotId) {
        if (lastSnapshotId != 0x7FFFFFFE) {
            return this.getFileReplication(lastSnapshotId);
        }
        return this.getBlockReplication();
    }

    public final long storagespaceConsumedNoReplication(int lastSnapshotId) {
        if (lastSnapshotId != 0x7FFFFFFE) {
            return this.computeFileSize(lastSnapshotId);
        }
        return this.storagespaceConsumedNoReplication();
    }

    BlockInfoContiguous getPenultimateBlock() {
        if (this.blocks == null || this.blocks.length <= 1) {
            return null;
        }
        return this.blocks[this.blocks.length - 2];
    }

    @Override
    public BlockInfoContiguous getLastBlock() {
        return this.blocks == null || this.blocks.length == 0 ? null : this.blocks[this.blocks.length - 1];
    }

    @Override
    public int numBlocks() {
        return this.blocks == null ? 0 : this.blocks.length;
    }

    @Override
    @VisibleForTesting
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, int snapshotId) {
        super.dumpTreeRecursively(out, prefix, snapshotId);
        out.print(", fileSize=" + this.computeFileSize(snapshotId));
        out.print(", blocks=");
        out.print(this.blocks == null || this.blocks.length == 0 ? null : this.blocks[0]);
        out.println();
    }

    public long collectBlocksBeyondMax(long max, INode.BlocksMapUpdateInfo collectedBlocks) {
        long size2;
        BlockInfoContiguous[] oldBlocks = this.getBlocks();
        if (oldBlocks == null) {
            return 0L;
        }
        int n = 0;
        for (size2 = 0L; n < oldBlocks.length && max > size2; size2 += oldBlocks[n].getNumBytes(), ++n) {
        }
        if (n >= oldBlocks.length) {
            return size2;
        }
        this.truncateBlocksTo(n);
        if (collectedBlocks != null) {
            while (n < oldBlocks.length) {
                collectedBlocks.addDeleteBlock(oldBlocks[n]);
                ++n;
            }
        }
        return size2;
    }

    long computeQuotaDeltaForTruncate(long newLength) {
        int i;
        long size2;
        BlockInfoContiguous[] blocks = this.getBlocks();
        if (blocks == null || blocks.length == 0) {
            return 0L;
        }
        int n = 0;
        for (size2 = 0L; n < blocks.length && newLength > size2; size2 += blocks[n].getNumBytes(), ++n) {
        }
        boolean onBoundary = size2 == newLength;
        long truncateSize = 0L;
        int n2 = i = onBoundary ? n : n - 1;
        while (i < blocks.length) {
            truncateSize += blocks[i].getNumBytes();
            ++i;
        }
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            BlockInfoContiguous[] sblocks;
            FileDiff diff = (FileDiff)sf.getDiffs().getLast();
            BlockInfoContiguous[] blockInfoContiguousArray = sblocks = diff != null ? diff.getBlocks() : null;
            if (sblocks != null) {
                int i2;
                int n3 = i2 = onBoundary ? n : n - 1;
                while (i2 < blocks.length && i2 < sblocks.length && blocks[i2].equals(sblocks[i2])) {
                    truncateSize -= blocks[i2].getNumBytes();
                    ++i2;
                }
            }
        }
        return onBoundary ? -truncateSize : this.getPreferredBlockSize() - truncateSize;
    }

    void truncateBlocksTo(int n) {
        BlockInfoContiguous[] newBlocks;
        if (n == 0) {
            newBlocks = BlockInfoContiguous.EMPTY_ARRAY;
        } else {
            newBlocks = new BlockInfoContiguous[n];
            System.arraycopy(this.getBlocks(), 0, newBlocks, 0, n);
        }
        this.setBlocks(newBlocks);
    }

    public void collectBlocksBeyondSnapshot(BlockInfoContiguous[] snapshotBlocks, INode.BlocksMapUpdateInfo collectedBlocks) {
        int n;
        BlockInfoContiguous[] oldBlocks = this.getBlocks();
        if (snapshotBlocks == null || oldBlocks == null) {
            return;
        }
        for (n = 0; n < oldBlocks.length && n < snapshotBlocks.length && oldBlocks[n] == snapshotBlocks[n]; ++n) {
        }
        this.truncateBlocksTo(n);
        while (n < oldBlocks.length) {
            collectedBlocks.addDeleteBlock(oldBlocks[n++]);
        }
    }

    void excludeSnapshotBlocks(int snapshotId, INode.BlocksMapUpdateInfo collectedBlocks) {
        if (collectedBlocks == null || collectedBlocks.getToDeleteList().isEmpty()) {
            return;
        }
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf == null) {
            return;
        }
        BlockInfoContiguous[] snapshotBlocks = this.getDiffs().findEarlierSnapshotBlocks(snapshotId);
        if (snapshotBlocks == null) {
            return;
        }
        List<Block> toDelete = collectedBlocks.getToDeleteList();
        for (BlockInfoContiguous blk : snapshotBlocks) {
            if (!toDelete.contains(blk)) continue;
            collectedBlocks.removeDeleteBlock(blk);
        }
    }

    boolean isBlockInLatestSnapshot(BlockInfoContiguous block) {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf == null || sf.getDiffs() == null) {
            return false;
        }
        BlockInfoContiguous[] snapshotBlocks = this.getDiffs().findEarlierSnapshotBlocks(this.getDiffs().getLastSnapshotId());
        return snapshotBlocks != null && Arrays.asList(snapshotBlocks).contains(block);
    }

    static enum HeaderFormat {
        PREFERRED_BLOCK_SIZE(null, 48, 1L),
        REPLICATION(HeaderFormat.PREFERRED_BLOCK_SIZE.BITS, 12, 1L),
        STORAGE_POLICY_ID(HeaderFormat.REPLICATION.BITS, 4, 0L);

        private final LongBitFormat BITS;

        private HeaderFormat(LongBitFormat previous, int length, long min) {
            this.BITS = new LongBitFormat(this.name(), previous, length, min);
        }

        static short getReplication(long header) {
            return (short)HeaderFormat.REPLICATION.BITS.retrieve(header);
        }

        static long getPreferredBlockSize(long header) {
            return HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.retrieve(header);
        }

        static byte getStoragePolicyID(long header) {
            return (byte)HeaderFormat.STORAGE_POLICY_ID.BITS.retrieve(header);
        }

        static long toLong(long preferredBlockSize, short replication, byte storagePolicyID) {
            long h = 0L;
            if (preferredBlockSize == 0L) {
                preferredBlockSize = HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.getMin();
            }
            h = HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.combine(preferredBlockSize, h);
            h = HeaderFormat.REPLICATION.BITS.combine(replication, h);
            h = HeaderFormat.STORAGE_POLICY_ID.BITS.combine(storagePolicyID, h);
            return h;
        }
    }
}

