/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.io.IOUtils;
import org.spark-project.guava.base.Preconditions;

public abstract class NNUpgradeUtil {
    private static final Log LOG = LogFactory.getLog(NNUpgradeUtil.class);

    static boolean canRollBack(Storage.StorageDirectory sd, StorageInfo storage, StorageInfo prevStorage, int targetLayoutVersion) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            LOG.info((Object)("Storage directory " + sd.getRoot() + " does not contain previous fs state."));
            storage.readProperties(sd);
            return false;
        }
        prevStorage.readPreviousVersionProperties(sd);
        if (prevStorage.getLayoutVersion() != targetLayoutVersion) {
            throw new IOException("Cannot rollback to storage version " + prevStorage.getLayoutVersion() + " using this version of the NameNode, which uses storage version " + targetLayoutVersion + ". " + "Please use the previous version of HDFS to perform the rollback.");
        }
        return true;
    }

    static void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            LOG.info((Object)("Directory " + prevDir + " does not exist."));
            LOG.info((Object)("Finalize upgrade for " + sd.getRoot() + " is not required."));
            return;
        }
        LOG.info((Object)("Finalizing upgrade of storage directory " + sd.getRoot()));
        Preconditions.checkState((boolean)sd.getCurrentDir().exists(), (Object)"Current directory must exist.");
        File tmpDir = sd.getFinalizedTmp();
        NNStorage.rename(prevDir, tmpDir);
        NNStorage.deleteDir(tmpDir);
        LOG.info((Object)("Finalize upgrade for " + sd.getRoot() + " is complete."));
    }

    static void doPreUpgrade(Configuration conf, Storage.StorageDirectory sd) throws IOException {
        LOG.info((Object)("Starting upgrade of storage directory " + sd.getRoot()));
        NNUpgradeUtil.renameCurToTmp(sd);
        File curDir = sd.getCurrentDir();
        final File tmpDir = sd.getPreviousTmp();
        List fileNameList = IOUtils.listDirectory((File)tmpDir, (FilenameFilter)new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.equals(tmpDir) && name.startsWith(NNStorage.NameNodeFile.EDITS.getName());
            }
        });
        for (String s : fileNameList) {
            File prevFile = new File(tmpDir, s);
            File newFile = new File(curDir, prevFile.getName());
            Files.createLink(newFile.toPath(), prevFile.toPath());
        }
    }

    public static void renameCurToTmp(Storage.StorageDirectory sd) throws IOException {
        File curDir = sd.getCurrentDir();
        File prevDir = sd.getPreviousDir();
        File tmpDir = sd.getPreviousTmp();
        Preconditions.checkState((boolean)curDir.exists(), (Object)"Current directory must exist for preupgrade.");
        Preconditions.checkState((!prevDir.exists() ? 1 : 0) != 0, (Object)"Previous directory must not exist for preupgrade.");
        Preconditions.checkState((!tmpDir.exists() ? 1 : 0) != 0, (Object)"Previous.tmp directory must not exist for preupgrade.Consider restarting for recovery.");
        NNStorage.rename(curDir, tmpDir);
        if (!curDir.mkdir()) {
            throw new IOException("Cannot create directory " + curDir);
        }
    }

    public static void doUpgrade(Storage.StorageDirectory sd, Storage storage) throws IOException {
        LOG.info((Object)("Performing upgrade of storage directory " + sd.getRoot()));
        try {
            storage.writeProperties(sd);
            File prevDir = sd.getPreviousDir();
            File tmpDir = sd.getPreviousTmp();
            Preconditions.checkState((!prevDir.exists() ? 1 : 0) != 0, (Object)"previous directory must not exist for upgrade.");
            Preconditions.checkState((boolean)tmpDir.exists(), (Object)"previous.tmp directory must exist for upgrade.");
            NNStorage.rename(tmpDir, prevDir);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Unable to rename temp to previous for " + sd.getRoot()), (Throwable)ioe);
            throw ioe;
        }
    }

    static void doRollBack(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        File tmpDir = sd.getRemovedTmp();
        Preconditions.checkState((!tmpDir.exists() ? 1 : 0) != 0, (Object)"removed.tmp directory must not exist for rollback.Consider restarting for recovery.");
        File curDir = sd.getCurrentDir();
        Preconditions.checkState((boolean)curDir.exists(), (Object)"Current directory must exist for rollback.");
        NNStorage.rename(curDir, tmpDir);
        NNStorage.rename(prevDir, curDir);
        NNStorage.deleteDir(tmpDir);
        LOG.info((Object)("Rollback of " + sd.getRoot() + " is complete."));
    }
}

