/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.Diff;
import org.spark-project.guava.base.Preconditions;
import org.spark-project.guava.primitives.SignedBytes;

class SnapshotDiffInfo {
    public static final Comparator<INode> INODE_COMPARATOR = new Comparator<INode>(){

        @Override
        public int compare(INode left, INode right) {
            if (left == null) {
                return right == null ? 0 : -1;
            }
            if (right == null) {
                return 1;
            }
            int cmp = this.compare(left.getParent(), right.getParent());
            return cmp == 0 ? SignedBytes.lexicographicalComparator().compare(left.getLocalNameBytes(), right.getLocalNameBytes()) : cmp;
        }
    };
    private final INodeDirectory snapshotRoot;
    private final Snapshot from;
    private final Snapshot to;
    private final SortedMap<INode, byte[][]> diffMap = new TreeMap<INode, byte[][]>(INODE_COMPARATOR);
    private final Map<INodeDirectory, DirectoryWithSnapshotFeature.ChildrenDiff> dirDiffMap = new HashMap<INodeDirectory, DirectoryWithSnapshotFeature.ChildrenDiff>();
    private final Map<Long, RenameEntry> renameMap = new HashMap<Long, RenameEntry>();

    SnapshotDiffInfo(INodeDirectory snapshotRoot, Snapshot start2, Snapshot end) {
        Preconditions.checkArgument((boolean)snapshotRoot.isSnapshottable());
        this.snapshotRoot = snapshotRoot;
        this.from = start2;
        this.to = end;
    }

    void addDirDiff(INodeDirectory dir, byte[][] relativePath, DirectoryWithSnapshotFeature.ChildrenDiff diff) {
        RenameEntry entry2;
        this.dirDiffMap.put(dir, diff);
        this.diffMap.put(dir, relativePath);
        for (INode created : diff.getList(Diff.ListType.CREATED)) {
            if (!created.isReference() || (entry2 = this.getEntry(created.getId())).getTargetPath() != null) continue;
            entry2.setTarget(created, relativePath);
        }
        for (INode deleted : diff.getList(Diff.ListType.DELETED)) {
            if (!(deleted instanceof INodeReference.WithName)) continue;
            entry2 = this.getEntry(deleted.getId());
            entry2.setSource(deleted, relativePath);
        }
    }

    Snapshot getFrom() {
        return this.from;
    }

    Snapshot getTo() {
        return this.to;
    }

    private RenameEntry getEntry(long inodeId) {
        RenameEntry entry2 = this.renameMap.get(inodeId);
        if (entry2 == null) {
            entry2 = new RenameEntry();
            this.renameMap.put(inodeId, entry2);
        }
        return entry2;
    }

    void setRenameTarget(long inodeId, byte[][] path) {
        this.getEntry(inodeId).setTarget(path);
    }

    void addFileDiff(INodeFile file, byte[][] relativePath) {
        this.diffMap.put(file, relativePath);
    }

    boolean isFromEarlier() {
        return Snapshot.ID_COMPARATOR.compare(this.from, this.to) < 0;
    }

    public SnapshotDiffReport generateReport() {
        ArrayList<SnapshotDiffReport.DiffReportEntry> diffReportList = new ArrayList<SnapshotDiffReport.DiffReportEntry>();
        for (Map.Entry<INode, byte[][]> drEntry : this.diffMap.entrySet()) {
            INode node = drEntry.getKey();
            byte[][] path = drEntry.getValue();
            diffReportList.add(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, path, (byte[][])null));
            if (!node.isDirectory()) continue;
            List<SnapshotDiffReport.DiffReportEntry> subList = this.generateReport(this.dirDiffMap.get(node), path, this.isFromEarlier(), this.renameMap);
            diffReportList.addAll(subList);
        }
        return new SnapshotDiffReport(this.snapshotRoot.getFullPathName(), Snapshot.getSnapshotName(this.from), Snapshot.getSnapshotName(this.to), diffReportList);
    }

    private List<SnapshotDiffReport.DiffReportEntry> generateReport(DirectoryWithSnapshotFeature.ChildrenDiff dirDiff, byte[][] parentPath, boolean fromEarlier, Map<Long, RenameEntry> renameMap) {
        RenameEntry entry2;
        ArrayList<SnapshotDiffReport.DiffReportEntry> list2 = new ArrayList<SnapshotDiffReport.DiffReportEntry>();
        List created = dirDiff.getList(Diff.ListType.CREATED);
        List deleted = dirDiff.getList(Diff.ListType.DELETED);
        byte[][] fullPath = new byte[parentPath.length + 1][];
        System.arraycopy(parentPath, 0, fullPath, 0, parentPath.length);
        for (INode cnode : created) {
            entry2 = renameMap.get(cnode.getId());
            if (entry2 != null && entry2.isRename()) continue;
            fullPath[fullPath.length - 1] = cnode.getLocalNameBytes();
            list2.add(new SnapshotDiffReport.DiffReportEntry(fromEarlier ? SnapshotDiffReport.DiffType.CREATE : SnapshotDiffReport.DiffType.DELETE, fullPath));
        }
        for (INode dnode : deleted) {
            entry2 = renameMap.get(dnode.getId());
            if (entry2 != null && entry2.isRename()) {
                list2.add(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, fromEarlier ? entry2.getSourcePath() : entry2.getTargetPath(), fromEarlier ? entry2.getTargetPath() : entry2.getSourcePath()));
                continue;
            }
            fullPath[fullPath.length - 1] = dnode.getLocalNameBytes();
            list2.add(new SnapshotDiffReport.DiffReportEntry(fromEarlier ? SnapshotDiffReport.DiffType.DELETE : SnapshotDiffReport.DiffType.CREATE, fullPath));
        }
        return list2;
    }

    static class RenameEntry {
        private byte[][] sourcePath;
        private byte[][] targetPath;

        RenameEntry() {
        }

        void setSource(INode source, byte[][] sourceParentPath) {
            Preconditions.checkState((this.sourcePath == null ? 1 : 0) != 0);
            this.sourcePath = new byte[sourceParentPath.length + 1][];
            System.arraycopy(sourceParentPath, 0, this.sourcePath, 0, sourceParentPath.length);
            this.sourcePath[this.sourcePath.length - 1] = source.getLocalNameBytes();
        }

        void setTarget(INode target, byte[][] targetParentPath) {
            this.targetPath = new byte[targetParentPath.length + 1][];
            System.arraycopy(targetParentPath, 0, this.targetPath, 0, targetParentPath.length);
            this.targetPath[this.targetPath.length - 1] = target.getLocalNameBytes();
        }

        void setTarget(byte[][] targetPath) {
            this.targetPath = targetPath;
        }

        boolean isRename() {
            return this.sourcePath != null && this.targetPath != null;
        }

        byte[][] getSourcePath() {
            return this.sourcePath;
        }

        byte[][] getTargetPath() {
            return this.targetPath;
        }
    }
}

