/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.startupprogress;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressView;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;

@InterfaceAudience.Private
public class StartupProgressMetrics
implements MetricsSource {
    private static final MetricsInfo STARTUP_PROGRESS_METRICS_INFO = Interns.info((String)"StartupProgress", (String)"NameNode startup progress");
    private final StartupProgress startupProgress;

    public static void register(StartupProgress prog) {
        new StartupProgressMetrics(prog);
    }

    public StartupProgressMetrics(StartupProgress startupProgress) {
        this.startupProgress = startupProgress;
        DefaultMetricsSystem.instance().register(STARTUP_PROGRESS_METRICS_INFO.name(), STARTUP_PROGRESS_METRICS_INFO.description(), (Object)this);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        StartupProgressView prog = this.startupProgress.createView();
        MetricsRecordBuilder builder = collector.addRecord(STARTUP_PROGRESS_METRICS_INFO);
        builder.addCounter(Interns.info((String)"ElapsedTime", (String)"overall elapsed time"), prog.getElapsedTime());
        builder.addGauge(Interns.info((String)"PercentComplete", (String)"overall percent complete"), prog.getPercentComplete());
        for (Phase phase : prog.getPhases()) {
            StartupProgressMetrics.addCounter(builder, phase, "Count", " count", prog.getCount(phase));
            StartupProgressMetrics.addCounter(builder, phase, "ElapsedTime", " elapsed time", prog.getElapsedTime(phase));
            StartupProgressMetrics.addCounter(builder, phase, "Total", " total", prog.getTotal(phase));
            StartupProgressMetrics.addGauge(builder, phase, "PercentComplete", " percent complete", prog.getPercentComplete(phase));
        }
    }

    private static void addCounter(MetricsRecordBuilder builder, Phase phase, String nameSuffix, String descSuffix, long value2) {
        MetricsInfo metricsInfo = Interns.info((String)(phase.getName() + nameSuffix), (String)(phase.getDescription() + descSuffix));
        builder.addCounter(metricsInfo, value2);
    }

    private static void addGauge(MetricsRecordBuilder builder, Phase phase, String nameSuffix, String descSuffix, float value2) {
        MetricsInfo metricsInfo = Interns.info((String)(phase.getName() + nameSuffix), (String)(phase.getDescription() + descSuffix));
        builder.addGauge(metricsInfo, value2);
    }
}

