/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.spark-project.guava.base.Joiner;
import org.spark-project.guava.base.Preconditions;

public class RemoteEditLogManifest {
    private List<RemoteEditLog> logs;

    public RemoteEditLogManifest() {
    }

    public RemoteEditLogManifest(List<RemoteEditLog> logs) {
        this.logs = logs;
        this.checkState();
    }

    private void checkState() {
        Preconditions.checkNotNull(this.logs);
        RemoteEditLog prev = null;
        for (RemoteEditLog log : this.logs) {
            if (prev != null && log.getStartTxId() <= prev.getEndTxId()) {
                throw new IllegalStateException("Invalid log manifest (log " + log + " overlaps " + prev + ")\n" + this);
            }
            prev = log;
        }
    }

    public List<RemoteEditLog> getLogs() {
        return Collections.unmodifiableList(this.logs);
    }

    public String toString() {
        return "[" + Joiner.on((String)", ").join(this.logs) + "]";
    }
}

