/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.Serializable;

public class LongBitFormat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String NAME;
    private final int OFFSET;
    private final int LENGTH;
    private final long MIN;
    private final long MAX;
    private final long MASK;

    public LongBitFormat(String name, LongBitFormat previous, int length, long min) {
        this.NAME = name;
        this.OFFSET = previous == null ? 0 : previous.OFFSET + previous.LENGTH;
        this.LENGTH = length;
        this.MIN = min;
        this.MAX = -1L >>> 64 - this.LENGTH;
        this.MASK = this.MAX << this.OFFSET;
    }

    public long retrieve(long record) {
        return (record & this.MASK) >>> this.OFFSET;
    }

    public long combine(long value2, long record) {
        if (value2 < this.MIN) {
            throw new IllegalArgumentException("Illagal value: " + this.NAME + " = " + value2 + " < MIN = " + this.MIN);
        }
        if (value2 > this.MAX) {
            throw new IllegalArgumentException("Illagal value: " + this.NAME + " = " + value2 + " > MAX = " + this.MAX);
        }
        return record & (this.MASK ^ 0xFFFFFFFFFFFFFFFFL) | value2 << this.OFFSET;
    }

    public long getMin() {
        return this.MIN;
    }
}

