/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public interface ReadOnlyList<E>
extends Iterable<E> {
    public boolean isEmpty();

    public int size();

    public E get(int var1);

    public static class Util {
        public static <E> ReadOnlyList<E> emptyList() {
            return Util.asReadOnlyList(Collections.emptyList());
        }

        public static <K, E extends Comparable<K>> int binarySearch(ReadOnlyList<E> list2, K key) {
            int lower = 0;
            int upper = list2.size() - 1;
            while (lower <= upper) {
                int mid = upper + lower >>> 1;
                int d = ((Comparable)list2.get(mid)).compareTo(key);
                if (d == 0) {
                    return mid;
                }
                if (d > 0) {
                    upper = mid - 1;
                    continue;
                }
                lower = mid + 1;
            }
            return -(lower + 1);
        }

        public static <E> ReadOnlyList<E> asReadOnlyList(final List<E> list2) {
            return new ReadOnlyList<E>(){

                @Override
                public Iterator<E> iterator() {
                    return list2.iterator();
                }

                @Override
                public boolean isEmpty() {
                    return list2.isEmpty();
                }

                @Override
                public int size() {
                    return list2.size();
                }

                @Override
                public E get(int i) {
                    return list2.get(i);
                }
            };
        }

        public static <E> List<E> asList(final ReadOnlyList<E> list2) {
            return new List<E>(){

                @Override
                public Iterator<E> iterator() {
                    return list2.iterator();
                }

                @Override
                public boolean isEmpty() {
                    return list2.isEmpty();
                }

                @Override
                public int size() {
                    return list2.size();
                }

                @Override
                public E get(int i) {
                    return list2.get(i);
                }

                @Override
                public Object[] toArray() {
                    Object[] a = new Object[this.size()];
                    for (int i = 0; i < a.length; ++i) {
                        a[i] = this.get(i);
                    }
                    return a;
                }

                @Override
                public boolean add(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(int index, E element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends E> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(int index, Collection<? extends E> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean contains(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int indexOf(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int lastIndexOf(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ListIterator<E> listIterator() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ListIterator<E> listIterator(int index) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public E remove(int index) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public E set(int index, E element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public List<E> subList(int fromIndex, int toIndex) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

