/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.spark-project.guava.annotations.VisibleForTesting;
import org.spark-project.guava.collect.ImmutableList;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReferenceCountMap<E extends ReferenceCounter> {
    private Map<E, E> referenceMap = new HashMap<E, E>();

    public E put(E key) {
        ReferenceCounter value2 = (ReferenceCounter)this.referenceMap.get(key);
        if (value2 == null) {
            value2 = key;
            this.referenceMap.put(key, value2);
        }
        value2.incrementAndGetRefCount();
        return (E)value2;
    }

    public void remove(E key) {
        ReferenceCounter value2 = (ReferenceCounter)this.referenceMap.get(key);
        if (value2 != null && value2.decrementAndGetRefCount() == 0) {
            this.referenceMap.remove(key);
        }
    }

    @VisibleForTesting
    public ImmutableList<E> getEntries() {
        return new ImmutableList.Builder().addAll(this.referenceMap.keySet()).build();
    }

    public long getReferenceCount(E key) {
        ReferenceCounter counter = (ReferenceCounter)this.referenceMap.get(key);
        if (counter != null) {
            return counter.getRefCount();
        }
        return 0L;
    }

    public int getUniqueElementsSize() {
        return this.referenceMap.size();
    }

    @VisibleForTesting
    public void clear() {
        this.referenceMap.clear();
    }

    public static interface ReferenceCounter {
        public int getRefCount();

        public int incrementAndGetRefCount();

        public int decrementAndGetRefCount();
    }
}

