/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
@InterfaceStability.Evolving
final class Utils {
    private Utils() {
    }

    public static String notNull(Configuration conf, String key) {
        String value2 = conf.get(key);
        if (value2 == null) {
            throw new IllegalArgumentException("No value for " + key + " found in conf file.");
        }
        return value2;
    }

    public static String postBody(String ... kv) throws UnsupportedEncodingException {
        if (kv.length % 2 != 0) {
            throw new IllegalArgumentException("Arguments must be key value pairs");
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < kv.length) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append(URLEncoder.encode(kv[i++], "UTF-8"));
            sb.append("=");
            sb.append(URLEncoder.encode(kv[i++], "UTF-8"));
        }
        return sb.toString();
    }
}

