/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import org.apache.hadoop.hdfs.web.resources.Param;

abstract class ShortParam
extends Param<Short, Domain> {
    ShortParam(Domain domain, Short value2, Short min, Short max) {
        super(domain, value2);
        this.checkRange(min, max);
    }

    private void checkRange(Short min, Short max) {
        if (this.value == null) {
            return;
        }
        if (min != null && (Short)this.value < min) {
            throw new IllegalArgumentException("Invalid parameter range: " + this.getName() + " = " + ((Domain)this.domain).toString((Short)this.value) + " < " + ((Domain)this.domain).toString(min));
        }
        if (max != null && (Short)this.value > max) {
            throw new IllegalArgumentException("Invalid parameter range: " + this.getName() + " = " + ((Domain)this.domain).toString((Short)this.value) + " > " + ((Domain)this.domain).toString(max));
        }
    }

    @Override
    public String toString() {
        return this.getName() + "=" + ((Domain)this.domain).toString((Short)this.getValue());
    }

    @Override
    public final String getValueString() {
        return ((Domain)this.domain).toString((Short)this.getValue());
    }

    static final class Domain
    extends Param.Domain<Short> {
        final int radix;

        Domain(String paramName) {
            this(paramName, 10);
        }

        Domain(String paramName, int radix) {
            super(paramName);
            this.radix = radix;
        }

        @Override
        public String getDomain() {
            return "<null | short in radix " + this.radix + ">";
        }

        @Override
        Short parse(String str) {
            try {
                return "null".equals(str) || str == null ? null : Short.valueOf(Short.parseShort(str, this.radix));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse \"" + str + "\" as a radix-" + this.radix + " short integer.", e);
            }
        }

        String toString(Short n) {
            return n == null ? "null" : Integer.toString(n.shortValue(), this.radix);
        }
    }
}

