/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceBlacklistRequestPBImpl
extends ResourceBlacklistRequest {
    YarnProtos.ResourceBlacklistRequestProto proto = null;
    YarnProtos.ResourceBlacklistRequestProto.Builder builder = null;
    boolean viaProto = false;
    List<String> blacklistAdditions = null;
    List<String> blacklistRemovals = null;

    public ResourceBlacklistRequestPBImpl() {
        this.builder = YarnProtos.ResourceBlacklistRequestProto.newBuilder();
    }

    public ResourceBlacklistRequestPBImpl(YarnProtos.ResourceBlacklistRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ResourceBlacklistRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceBlacklistRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.blacklistAdditions != null) {
            this.addBlacklistAdditionsToProto();
        }
        if (this.blacklistRemovals != null) {
            this.addBlacklistRemovalsToProto();
        }
    }

    private void addBlacklistAdditionsToProto() {
        this.maybeInitBuilder();
        this.builder.clearBlacklistAdditions();
        if (this.blacklistAdditions == null) {
            return;
        }
        this.builder.addAllBlacklistAdditions(this.blacklistAdditions);
    }

    private void addBlacklistRemovalsToProto() {
        this.maybeInitBuilder();
        this.builder.clearBlacklistRemovals();
        if (this.blacklistRemovals == null) {
            return;
        }
        this.builder.addAllBlacklistRemovals(this.blacklistRemovals);
    }

    private void initBlacklistAdditions() {
        if (this.blacklistAdditions != null) {
            return;
        }
        YarnProtos.ResourceBlacklistRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<String> list2 = p.getBlacklistAdditionsList();
        this.blacklistAdditions = new ArrayList<String>();
        this.blacklistAdditions.addAll(list2);
    }

    private void initBlacklistRemovals() {
        if (this.blacklistRemovals != null) {
            return;
        }
        YarnProtos.ResourceBlacklistRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<String> list2 = p.getBlacklistRemovalsList();
        this.blacklistRemovals = new ArrayList<String>();
        this.blacklistRemovals.addAll(list2);
    }

    @Override
    public List<String> getBlacklistAdditions() {
        this.initBlacklistAdditions();
        return this.blacklistAdditions;
    }

    @Override
    public void setBlacklistAdditions(List<String> resourceNames) {
        if (resourceNames == null || resourceNames.isEmpty()) {
            if (this.blacklistAdditions != null) {
                this.blacklistAdditions.clear();
            }
            return;
        }
        this.initBlacklistAdditions();
        this.blacklistAdditions.clear();
        this.blacklistAdditions.addAll(resourceNames);
    }

    @Override
    public List<String> getBlacklistRemovals() {
        this.initBlacklistRemovals();
        return this.blacklistRemovals;
    }

    @Override
    public void setBlacklistRemovals(List<String> resourceNames) {
        if (resourceNames == null || resourceNames.isEmpty()) {
            if (this.blacklistRemovals != null) {
                this.blacklistRemovals.clear();
            }
            return;
        }
        this.initBlacklistRemovals();
        this.blacklistRemovals.clear();
        this.blacklistRemovals.addAll(resourceNames);
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ResourceBlacklistRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }
}

