/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.spark-project.guava.base.Joiner;
import org.spark-project.guava.base.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ClientRMProxy<T>
extends RMProxy<T> {
    private static final Log LOG = LogFactory.getLog(ClientRMProxy.class);
    private static final ClientRMProxy INSTANCE = new ClientRMProxy();

    private ClientRMProxy() {
    }

    public static <T> T createRMProxy(Configuration configuration, Class<T> protocol) throws IOException {
        return ClientRMProxy.createRMProxy(configuration, protocol, INSTANCE);
    }

    private static void setAMRMTokenService(Configuration conf) throws IOException {
        for (Token token : UserGroupInformation.getCurrentUser().getTokens()) {
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            token.setService(ClientRMProxy.getAMRMTokenService(conf));
        }
    }

    @Override
    @InterfaceAudience.Private
    protected InetSocketAddress getRMAddress(YarnConfiguration conf, Class<?> protocol) throws IOException {
        if (protocol == ApplicationClientProtocol.class) {
            return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
        }
        if (protocol == ResourceManagerAdministrationProtocol.class) {
            return conf.getSocketAddr("yarn.resourcemanager.admin.address", "0.0.0.0:8033", 8033);
        }
        if (protocol == ApplicationMasterProtocol.class) {
            ClientRMProxy.setAMRMTokenService(conf);
            return conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
        }
        String message = "Unsupported protocol found when creating the proxy connection to ResourceManager: " + (protocol != null ? protocol.getClass().getName() : "null");
        LOG.error((Object)message);
        throw new IllegalStateException(message);
    }

    @Override
    @InterfaceAudience.Private
    protected void checkAllowedProtocols(Class<?> protocol) {
        Preconditions.checkArgument((boolean)protocol.isAssignableFrom(ClientRMProtocols.class), (Object)"RM does not support this client protocol");
    }

    @InterfaceStability.Unstable
    public static Text getRMDelegationTokenService(Configuration conf) {
        return ClientRMProxy.getTokenService(conf, "yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    @InterfaceStability.Unstable
    public static Text getAMRMTokenService(Configuration conf) {
        return ClientRMProxy.getTokenService(conf, "yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
    }

    @InterfaceStability.Unstable
    public static Text getTokenService(Configuration conf, String address, String defaultAddr, int defaultPort) {
        if (HAUtil.isHAEnabled(conf)) {
            ArrayList<String> services = new ArrayList<String>();
            YarnConfiguration yarnConf = new YarnConfiguration(conf);
            for (String rmId : HAUtil.getRMHAIds(conf)) {
                yarnConf.set("yarn.resourcemanager.ha.id", rmId);
                services.add(SecurityUtil.buildTokenService((InetSocketAddress)yarnConf.getSocketAddr(address, defaultAddr, defaultPort)).toString());
            }
            return new Text(Joiner.on((char)',').join(services));
        }
        return SecurityUtil.buildTokenService((InetSocketAddress)conf.getSocketAddr(address, defaultAddr, defaultPort));
    }

    private static interface ClientRMProtocols
    extends ApplicationClientProtocol,
    ApplicationMasterProtocol,
    ResourceManagerAdministrationProtocol {
    }
}

