/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.apache.htrace.fasterxml.jackson.core.JsonParser;
import org.apache.htrace.fasterxml.jackson.core.JsonProcessingException;
import org.apache.htrace.fasterxml.jackson.core.JsonToken;
import org.apache.htrace.fasterxml.jackson.databind.DeserializationContext;
import org.apache.htrace.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.htrace.fasterxml.jackson.databind.PropertyName;
import org.apache.htrace.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.htrace.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.htrace.fasterxml.jackson.databind.util.ClassUtil;

public final class InnerClassProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final SettableBeanProperty _delegate;
    protected final Constructor<?> _creator;

    public InnerClassProperty(SettableBeanProperty delegate, Constructor<?> ctor) {
        super(delegate);
        this._delegate = delegate;
        this._creator = ctor;
    }

    protected InnerClassProperty(InnerClassProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._delegate = src._delegate.withValueDeserializer(deser);
        this._creator = src._creator;
    }

    protected InnerClassProperty(InnerClassProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._delegate = src._delegate.withName(newName);
        this._creator = src._creator;
    }

    @Override
    public InnerClassProperty withName(PropertyName newName) {
        return new InnerClassProperty(this, newName);
    }

    @Override
    public InnerClassProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new InnerClassProperty(this, deser);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._delegate.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._delegate.getMember();
    }

    @Override
    public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
        Object value2;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            value2 = this._nullProvider == null ? null : this._nullProvider.nullValue(ctxt);
        } else if (this._valueTypeDeserializer != null) {
            value2 = this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
        } else {
            try {
                value2 = this._creator.newInstance(bean);
            }
            catch (Exception e) {
                ClassUtil.unwrapAndThrowAsIAE(e, "Failed to instantiate class " + this._creator.getDeclaringClass().getName() + ", problem: " + e.getMessage());
                value2 = null;
            }
            this._valueDeserializer.deserialize(jp, ctxt, value2);
        }
        this.set(bean, value2);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
        return this.setAndReturn(instance, this.deserialize(jp, ctxt));
    }

    @Override
    public final void set(Object instance, Object value2) throws IOException {
        this._delegate.set(instance, value2);
    }

    @Override
    public Object setAndReturn(Object instance, Object value2) throws IOException {
        return this._delegate.setAndReturn(instance, value2);
    }
}

