/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.fasterxml.jackson.databind.jsontype.impl;

import java.io.IOException;
import org.apache.htrace.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.fasterxml.jackson.databind.BeanProperty;
import org.apache.htrace.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import org.apache.htrace.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeSerializer;

public class AsPropertyTypeSerializer
extends AsArrayTypeSerializer {
    protected final String _typePropertyName;

    public AsPropertyTypeSerializer(TypeIdResolver idRes, BeanProperty property, String propName) {
        super(idRes, property);
        this._typePropertyName = propName;
    }

    @Override
    public AsPropertyTypeSerializer forProperty(BeanProperty prop) {
        return this._property == prop ? this : new AsPropertyTypeSerializer(this._idResolver, prop, this._typePropertyName);
    }

    @Override
    public String getPropertyName() {
        return this._typePropertyName;
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.PROPERTY;
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator jgen) throws IOException {
        String typeId = this.idFromValue(value2);
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
            jgen.writeStartObject();
        } else {
            jgen.writeStartObject();
            jgen.writeStringField(this._typePropertyName, typeId);
        }
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator jgen, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
            jgen.writeStartObject();
        } else {
            jgen.writeStartObject();
            jgen.writeStringField(this._typePropertyName, typeId);
        }
    }

    @Override
    public void writeTypeSuffixForObject(Object value2, JsonGenerator jgen) throws IOException {
        jgen.writeEndObject();
    }

    @Override
    public void writeCustomTypePrefixForObject(Object value2, JsonGenerator jgen, String typeId) throws IOException {
        if (jgen.canWriteTypeId()) {
            jgen.writeTypeId(typeId);
            jgen.writeStartObject();
        } else {
            jgen.writeStartObject();
            jgen.writeStringField(this._typePropertyName, typeId);
        }
    }

    @Override
    public void writeCustomTypeSuffixForObject(Object value2, JsonGenerator jgen, String typeId) throws IOException {
        jgen.writeEndObject();
    }
}

