/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import org.apache.htrace.fasterxml.jackson.core.JsonGenerationException;
import org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.fasterxml.jackson.databind.SerializerProvider;
import org.apache.htrace.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.htrace.fasterxml.jackson.databind.ser.std.DateTimeSerializerBase;

@JacksonStdImpl
public class CalendarSerializer
extends DateTimeSerializerBase<Calendar> {
    public static final CalendarSerializer instance = new CalendarSerializer();

    public CalendarSerializer() {
        this(null, null);
    }

    public CalendarSerializer(Boolean useTimestamp, DateFormat customFormat) {
        super(Calendar.class, useTimestamp, customFormat);
    }

    public CalendarSerializer withFormat(Boolean timestamp2, DateFormat customFormat) {
        return new CalendarSerializer(timestamp2, customFormat);
    }

    @Override
    protected long _timestamp(Calendar value2) {
        return value2 == null ? 0L : value2.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Calendar value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._asTimestamp(provider)) {
            jgen.writeNumber(this._timestamp(value2));
        } else if (this._customFormat != null) {
            DateFormat dateFormat = this._customFormat;
            synchronized (dateFormat) {
                jgen.writeString(this._customFormat.format(value2.getTime()));
            }
        } else {
            provider.defaultSerializeDateValue(value2.getTime(), jgen);
        }
    }
}

