/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingPlaintextTransportLayer
implements TransportLayer {
    private static final Logger log = LoggerFactory.getLogger(BlockingPlaintextTransportLayer.class);
    private final SocketChannel socketChannel;
    private final Principal principal = KafkaPrincipal.ANONYMOUS;

    public BlockingPlaintextTransportLayer(SocketChannel socketChannel) throws IOException {
        this.socketChannel = socketChannel;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    @Override
    public void disconnect() {
    }

    @Override
    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public void close() throws IOException {
        this.socketChannel.socket().close();
        this.socketChannel.close();
    }

    @Override
    public void handshake() throws IOException {
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.socketChannel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.socketChannel.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.socketChannel.read(dsts, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.socketChannel.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.socketChannel.write(srcs);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.socketChannel.write(srcs, offset, length);
    }

    @Override
    public boolean hasPendingWrites() {
        return false;
    }

    @Override
    public Principal peerPrincipal() throws IOException {
        return this.principal;
    }

    @Override
    public void addInterestOps(int ops) {
    }

    @Override
    public void removeInterestOps(int ops) {
    }

    @Override
    public boolean isMute() {
        return false;
    }

    @Override
    public long transferFrom(FileChannel fileChannel, long position, long count2) throws IOException {
        return fileChannel.transferTo(position, count2, this.socketChannel);
    }
}

