/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.validation;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XMLSchemaDescription;

final class SoftReferenceGrammarPool
implements XMLGrammarPool {
    protected static final int TABLE_SIZE = 11;
    protected static final Grammar[] ZERO_LENGTH_GRAMMAR_ARRAY = new Grammar[0];
    protected Entry[] fGrammars = null;
    protected boolean fPoolIsLocked;
    protected int fGrammarCount = 0;
    protected final ReferenceQueue fReferenceQueue = new ReferenceQueue();

    public SoftReferenceGrammarPool() {
        this.fGrammars = new Entry[11];
        this.fPoolIsLocked = false;
    }

    public SoftReferenceGrammarPool(int n) {
        this.fGrammars = new Entry[n];
        this.fPoolIsLocked = false;
    }

    public Grammar[] retrieveInitialGrammarSet(String string) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            this.clean();
            Grammar[] grammarArray = ZERO_LENGTH_GRAMMAR_ARRAY;
            return grammarArray;
        }
    }

    public void cacheGrammars(String string, Grammar[] grammarArray) {
        if (!this.fPoolIsLocked) {
            int n = 0;
            while (n < grammarArray.length) {
                this.putGrammar(grammarArray[n]);
                ++n;
            }
        }
    }

    public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
        return this.getGrammar(xMLGrammarDescription);
    }

    public void putGrammar(Grammar grammar) {
        if (!this.fPoolIsLocked) {
            Entry[] entryArray = this.fGrammars;
            synchronized (entryArray) {
                Entry entry2;
                this.clean();
                XMLGrammarDescription xMLGrammarDescription = grammar.getGrammarDescription();
                int n = this.hashCode(xMLGrammarDescription);
                int n2 = (n & Integer.MAX_VALUE) % this.fGrammars.length;
                Entry entry3 = this.fGrammars[n2];
                while (entry3 != null) {
                    if (entry3.hash == n && this.equals(entry3.desc, xMLGrammarDescription)) {
                        if (entry3.grammar.get() != grammar) {
                            entry3.grammar = new SoftGrammarReference(entry3, grammar, this.fReferenceQueue);
                        }
                        return;
                    }
                    entry3 = entry3.next;
                }
                this.fGrammars[n2] = entry2 = new Entry(n, n2, xMLGrammarDescription, grammar, this.fGrammars[n2], this.fReferenceQueue);
                ++this.fGrammarCount;
            }
        }
    }

    public Grammar getGrammar(XMLGrammarDescription xMLGrammarDescription) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            Grammar grammar;
            this.clean();
            int n = this.hashCode(xMLGrammarDescription);
            int n2 = (n & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry2 = this.fGrammars[n2];
            while (entry2 != null) {
                grammar = (Grammar)entry2.grammar.get();
                if (grammar == null) {
                    this.removeEntry(entry2);
                } else if (entry2.hash == n && this.equals(entry2.desc, xMLGrammarDescription)) {
                    Grammar grammar2 = grammar;
                    return grammar2;
                }
                entry2 = entry2.next;
            }
            grammar = null;
            return grammar;
        }
    }

    public Grammar removeGrammar(XMLGrammarDescription xMLGrammarDescription) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            this.clean();
            int n = this.hashCode(xMLGrammarDescription);
            int n2 = (n & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry2 = this.fGrammars[n2];
            while (entry2 != null) {
                if (entry2.hash == n && this.equals(entry2.desc, xMLGrammarDescription)) {
                    Grammar grammar = this.removeEntry(entry2);
                    return grammar;
                }
                entry2 = entry2.next;
            }
            Grammar grammar = null;
            return grammar;
        }
    }

    public boolean containsGrammar(XMLGrammarDescription xMLGrammarDescription) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            this.clean();
            int n = this.hashCode(xMLGrammarDescription);
            int n2 = (n & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry2 = this.fGrammars[n2];
            while (entry2 != null) {
                Grammar grammar = (Grammar)entry2.grammar.get();
                if (grammar == null) {
                    this.removeEntry(entry2);
                } else if (entry2.hash == n && this.equals(entry2.desc, xMLGrammarDescription)) {
                    boolean bl = true;
                    return bl;
                }
                entry2 = entry2.next;
            }
            boolean bl = false;
            return bl;
        }
    }

    public void lockPool() {
        this.fPoolIsLocked = true;
    }

    public void unlockPool() {
        this.fPoolIsLocked = false;
    }

    public void clear() {
        int n = 0;
        while (n < this.fGrammars.length) {
            if (this.fGrammars[n] != null) {
                this.fGrammars[n].clear();
                this.fGrammars[n] = null;
            }
            ++n;
        }
        this.fGrammarCount = 0;
    }

    public boolean equals(XMLGrammarDescription xMLGrammarDescription, XMLGrammarDescription xMLGrammarDescription2) {
        if (xMLGrammarDescription instanceof XMLSchemaDescription) {
            if (!(xMLGrammarDescription2 instanceof XMLSchemaDescription)) {
                return false;
            }
            XMLSchemaDescription xMLSchemaDescription = (XMLSchemaDescription)xMLGrammarDescription;
            XMLSchemaDescription xMLSchemaDescription2 = (XMLSchemaDescription)xMLGrammarDescription2;
            String string = xMLSchemaDescription.getTargetNamespace();
            if (string != null ? !string.equals(xMLSchemaDescription2.getTargetNamespace()) : xMLSchemaDescription2.getTargetNamespace() != null) {
                return false;
            }
            String string2 = xMLSchemaDescription.getExpandedSystemId();
            return !(string2 != null ? !string2.equals(xMLSchemaDescription2.getExpandedSystemId()) : xMLSchemaDescription2.getExpandedSystemId() != null);
        }
        return xMLGrammarDescription.equals(xMLGrammarDescription2);
    }

    public int hashCode(XMLGrammarDescription xMLGrammarDescription) {
        if (xMLGrammarDescription instanceof XMLSchemaDescription) {
            XMLSchemaDescription xMLSchemaDescription = (XMLSchemaDescription)xMLGrammarDescription;
            String string = xMLSchemaDescription.getTargetNamespace();
            String string2 = xMLSchemaDescription.getExpandedSystemId();
            int n = string != null ? string.hashCode() : 0;
            return n ^= string2 != null ? string2.hashCode() : 0;
        }
        return xMLGrammarDescription.hashCode();
    }

    private Grammar removeEntry(Entry entry2) {
        if (entry2.prev != null) {
            entry2.prev.next = entry2.next;
        } else {
            this.fGrammars[entry2.bucket] = entry2.next;
        }
        if (entry2.next != null) {
            entry2.next.prev = entry2.prev;
        }
        --this.fGrammarCount;
        entry2.grammar.entry = null;
        return (Grammar)entry2.grammar.get();
    }

    private void clean() {
        Reference reference = this.fReferenceQueue.poll();
        while (reference != null) {
            Entry entry2 = ((SoftGrammarReference)reference).entry;
            if (entry2 != null) {
                this.removeEntry(entry2);
            }
            reference = this.fReferenceQueue.poll();
        }
    }

    static final class SoftGrammarReference
    extends SoftReference {
        public Entry entry;

        protected SoftGrammarReference(Entry entry2, Grammar grammar, ReferenceQueue referenceQueue) {
            super(grammar, referenceQueue);
            this.entry = entry2;
        }
    }

    static final class Entry {
        public int hash;
        public int bucket;
        public Entry prev;
        public Entry next;
        public XMLGrammarDescription desc;
        public SoftGrammarReference grammar;

        protected Entry(int n, int n2, XMLGrammarDescription xMLGrammarDescription, Grammar grammar, Entry entry2, ReferenceQueue referenceQueue) {
            this.hash = n;
            this.bucket = n2;
            this.prev = null;
            this.next = entry2;
            if (entry2 != null) {
                entry2.prev = this;
            }
            this.desc = xMLGrammarDescription;
            this.grammar = new SoftGrammarReference(this, grammar, referenceQueue);
        }

        protected void clear() {
            this.desc = null;
            this.grammar = null;
            if (this.next != null) {
                this.next.clear();
                this.next = null;
            }
        }
    }
}

