/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.leveldbjni.internal;

import java.io.File;
import java.io.IOException;
import org.fusesource.hawtjni.runtime.ArgFlag;
import org.fusesource.hawtjni.runtime.ClassFlag;
import org.fusesource.hawtjni.runtime.JniArg;
import org.fusesource.hawtjni.runtime.JniClass;
import org.fusesource.hawtjni.runtime.JniMethod;
import org.fusesource.hawtjni.runtime.Library;
import org.fusesource.hawtjni.runtime.MethodFlag;
import org.fusesource.leveldbjni.internal.NativeBuffer;
import org.fusesource.leveldbjni.internal.NativeIterator;
import org.fusesource.leveldbjni.internal.NativeObject;
import org.fusesource.leveldbjni.internal.NativeOptions;
import org.fusesource.leveldbjni.internal.NativeRange;
import org.fusesource.leveldbjni.internal.NativeReadOptions;
import org.fusesource.leveldbjni.internal.NativeSlice;
import org.fusesource.leveldbjni.internal.NativeSnapshot;
import org.fusesource.leveldbjni.internal.NativeStatus;
import org.fusesource.leveldbjni.internal.NativeStdString;
import org.fusesource.leveldbjni.internal.NativeWriteBatch;
import org.fusesource.leveldbjni.internal.NativeWriteOptions;

public class NativeDB
extends NativeObject {
    public static final Library LIBRARY = new Library("leveldbjni", NativeDB.class);

    public void delete() {
        this.assertAllocated();
        DBJNI.delete(this.self);
        this.self = 0L;
    }

    private NativeDB(long self) {
        super(self);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkStatus(long s) throws DBException {
        NativeStatus status = new NativeStatus(s);
        try {
            if (!status.isOk()) {
                throw new DBException(status.toString(), status.isNotFound());
            }
        }
        finally {
            status.delete();
        }
    }

    static void checkArgNotNull(Object value2, String name) {
        if (value2 == null) {
            throw new IllegalArgumentException("The " + name + " argument cannot be null");
        }
    }

    public static NativeDB open(NativeOptions options, File path) throws IOException, DBException {
        NativeDB.checkArgNotNull(options, "options");
        NativeDB.checkArgNotNull(path, "path");
        long[] rc = new long[1];
        try {
            NativeDB.checkStatus(DBJNI.Open(options, path.getCanonicalPath(), rc));
        }
        catch (IOException e) {
            if (rc[0] != 0L) {
                DBJNI.delete(rc[0]);
            }
            throw e;
        }
        return new NativeDB(rc[0]);
    }

    public void suspendCompactions() {
        DBJNI.SuspendCompactions(this.self);
    }

    public void resumeCompactions() {
        DBJNI.ResumeCompactions(this.self);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(NativeWriteOptions options, byte[] key, byte[] value2) throws DBException {
        NativeDB.checkArgNotNull(options, "options");
        NativeDB.checkArgNotNull(key, "key");
        NativeDB.checkArgNotNull(value2, "value");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            NativeBuffer valueBuffer = NativeBuffer.create(value2);
            try {
                this.put(options, keyBuffer, valueBuffer);
            }
            finally {
                valueBuffer.delete();
            }
        }
        finally {
            keyBuffer.delete();
        }
    }

    private void put(NativeWriteOptions options, NativeBuffer keyBuffer, NativeBuffer valueBuffer) throws DBException {
        this.put(options, new NativeSlice(keyBuffer), new NativeSlice(valueBuffer));
    }

    private void put(NativeWriteOptions options, NativeSlice keySlice, NativeSlice valueSlice) throws DBException {
        this.assertAllocated();
        NativeDB.checkStatus(DBJNI.Put(this.self, options, keySlice, valueSlice));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NativeWriteOptions options, byte[] key) throws DBException {
        NativeDB.checkArgNotNull(options, "options");
        NativeDB.checkArgNotNull(key, "key");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            this.delete(options, keyBuffer);
        }
        finally {
            keyBuffer.delete();
        }
    }

    private void delete(NativeWriteOptions options, NativeBuffer keyBuffer) throws DBException {
        this.delete(options, new NativeSlice(keyBuffer));
    }

    private void delete(NativeWriteOptions options, NativeSlice keySlice) throws DBException {
        this.assertAllocated();
        NativeDB.checkStatus(DBJNI.Delete(this.self, options, keySlice));
    }

    public void write(NativeWriteOptions options, NativeWriteBatch updates) throws DBException {
        NativeDB.checkArgNotNull(options, "options");
        NativeDB.checkArgNotNull(updates, "updates");
        NativeDB.checkStatus(DBJNI.Write(this.self, options, updates.pointer()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(NativeReadOptions options, byte[] key) throws DBException {
        NativeDB.checkArgNotNull(options, "options");
        NativeDB.checkArgNotNull(key, "key");
        NativeBuffer keyBuffer = NativeBuffer.create(key);
        try {
            byte[] byArray = this.get(options, keyBuffer);
            return byArray;
        }
        finally {
            keyBuffer.delete();
        }
    }

    private byte[] get(NativeReadOptions options, NativeBuffer keyBuffer) throws DBException {
        return this.get(options, new NativeSlice(keyBuffer));
    }

    private byte[] get(NativeReadOptions options, NativeSlice keySlice) throws DBException {
        this.assertAllocated();
        NativeStdString result = new NativeStdString();
        try {
            long s = DBJNI.Get(this.self, options, keySlice, result.pointer());
            NativeStatus status = new NativeStatus(s);
            try {
                if (status.isOk()) {
                    byte[] byArray = result.toByteArray();
                    return byArray;
                }
                if (status.isNotFound()) {
                    byte[] byArray = null;
                    return byArray;
                }
                throw new DBException(status.toString(), status.isNotFound());
            }
            finally {
                status.delete();
            }
        }
        finally {
            result.delete();
        }
    }

    public NativeSnapshot getSnapshot() {
        return new NativeSnapshot(DBJNI.GetSnapshot(this.self));
    }

    public void releaseSnapshot(NativeSnapshot snapshot) {
        NativeDB.checkArgNotNull(snapshot, "snapshot");
        DBJNI.ReleaseSnapshot(this.self, snapshot.pointer());
    }

    public NativeIterator iterator(NativeReadOptions options) {
        NativeDB.checkArgNotNull(options, "options");
        return new NativeIterator(DBJNI.NewIterator(this.self, options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getApproximateSizes(NativeRange ... ranges) {
        if (ranges == null) {
            return null;
        }
        long[] rc = new long[ranges.length];
        NativeRange.RangeJNI[] structs = new NativeRange.RangeJNI[ranges.length];
        if (rc.length > 0) {
            int i;
            NativeBuffer range_array = NativeRange.RangeJNI.arrayCreate(ranges.length);
            try {
                for (i = 0; i < ranges.length; ++i) {
                    structs[i] = new NativeRange.RangeJNI(ranges[i]);
                    structs[i].arrayWrite(range_array.pointer(), i);
                }
                DBJNI.GetApproximateSizes(this.self, range_array.pointer(), ranges.length, rc);
            }
            finally {
                for (i = 0; i < ranges.length; ++i) {
                    if (structs[i] == null) continue;
                    structs[i].delete();
                }
                range_array.delete();
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String name) {
        NativeDB.checkArgNotNull(name, "name");
        NativeBuffer keyBuffer = NativeBuffer.create(name.getBytes());
        try {
            byte[] property = this.getProperty(keyBuffer);
            if (property == null) {
                String string = null;
                return string;
            }
            String string = new String(property);
            return string;
        }
        finally {
            keyBuffer.delete();
        }
    }

    private byte[] getProperty(NativeBuffer nameBuffer) {
        return this.getProperty(new NativeSlice(nameBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getProperty(NativeSlice nameSlice) {
        this.assertAllocated();
        NativeStdString result = new NativeStdString();
        try {
            if (DBJNI.GetProperty(this.self, nameSlice, result.pointer())) {
                byte[] byArray = result.toByteArray();
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            result.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactRange(byte[] begin, byte[] end) {
        NativeBuffer keyBuffer = NativeBuffer.create(begin);
        try {
            NativeBuffer valueBuffer = NativeBuffer.create(end);
            try {
                this.compactRange(keyBuffer, valueBuffer);
            }
            finally {
                if (valueBuffer != null) {
                    valueBuffer.delete();
                }
            }
        }
        finally {
            if (keyBuffer != null) {
                keyBuffer.delete();
            }
        }
    }

    private void compactRange(NativeBuffer beginBuffer, NativeBuffer endBuffer) {
        this.compactRange(NativeSlice.create(beginBuffer), NativeSlice.create(endBuffer));
    }

    private void compactRange(NativeSlice beginSlice, NativeSlice endSlice) {
        this.assertAllocated();
        DBJNI.CompactRange(this.self, beginSlice, endSlice);
    }

    public static void destroy(File path, NativeOptions options) throws IOException, DBException {
        NativeDB.checkArgNotNull(options, "options");
        NativeDB.checkArgNotNull(path, "path");
        NativeDB.checkStatus(DBJNI.DestroyDB(path.getCanonicalPath(), options));
    }

    public static void repair(File path, NativeOptions options) throws IOException, DBException {
        NativeDB.checkArgNotNull(options, "options");
        NativeDB.checkArgNotNull(path, "path");
        NativeDB.checkStatus(DBJNI.RepairDB(path.getCanonicalPath(), options));
    }

    public static class DBException
    extends IOException {
        private final boolean notFound;

        DBException(String s, boolean notFound) {
            super(s);
            this.notFound = notFound;
        }

        public boolean isNotFound() {
            return this.notFound;
        }
    }

    @JniClass(name="leveldb::DB", flags={ClassFlag.CPP})
    static class DBJNI {
        DBJNI() {
        }

        @JniMethod(flags={MethodFlag.JNI, MethodFlag.POINTER_RETURN}, cast="jobject")
        public static final native long NewGlobalRef(Object var0);

        @JniMethod(flags={MethodFlag.JNI}, cast="jobject")
        public static final native void DeleteGlobalRef(@JniArg(cast="jobject", flags={ArgFlag.POINTER_ARG}) long var0);

        @JniMethod(flags={MethodFlag.JNI, MethodFlag.POINTER_RETURN}, cast="jmethodID")
        public static final native long GetMethodID(@JniArg(cast="jclass", flags={ArgFlag.POINTER_ARG}) Class var0, String var1, String var2);

        @JniMethod(flags={MethodFlag.CPP_DELETE})
        static final native void delete(long var0);

        @JniMethod(copy="leveldb::Status", accessor="leveldb::DB::Open")
        static final native long Open(@JniArg(flags={ArgFlag.BY_VALUE, ArgFlag.NO_OUT}) NativeOptions var0, @JniArg(cast="const char*") String var1, @JniArg(cast="leveldb::DB**") long[] var2);

        @JniMethod(copy="leveldb::Status", flags={MethodFlag.CPP_METHOD})
        static final native long Put(long var0, @JniArg(flags={ArgFlag.BY_VALUE, ArgFlag.NO_OUT}) NativeWriteOptions var2, @JniArg(flags={ArgFlag.BY_VALUE, ArgFlag.NO_OUT}) NativeSlice var3, @JniArg(flags={ArgFlag.BY_VALUE, ArgFlag.NO_OUT}) NativeSlice var4);

        @JniMethod(copy="leveldb::Status", flags={MethodFlag.CPP_METHOD})
        static final native long Delete(long var0, @JniArg(flags={ArgFlag.BY_VALUE, ArgFlag.NO_OUT}) NativeWriteOptions var2, @JniArg(flags={ArgFlag.BY_VALUE, ArgFlag.NO_OUT}) NativeSlice var3);

        @JniMethod(copy="leveldb::Status", flags={MethodFlag.CPP_METHOD})
        static final native long Write(long var0, @JniArg(flags={ArgFlag.BY_VALUE}) NativeWriteOptions var2, @JniArg(cast="leveldb::WriteBatch *") long var3);

        @JniMethod(copy="leveldb::Status", flags={MethodFlag.CPP_METHOD})
        static final native long Get(long var0, @JniArg(flags={ArgFlag.NO_OUT, ArgFlag.BY_VALUE}) NativeReadOptions var2, @JniArg(flags={ArgFlag.BY_VALUE, ArgFlag.NO_OUT}) NativeSlice var3, @JniArg(cast="std::string *") long var4);

        @JniMethod(cast="leveldb::Iterator *", flags={MethodFlag.CPP_METHOD})
        static final native long NewIterator(long var0, @JniArg(flags={ArgFlag.NO_OUT, ArgFlag.BY_VALUE}) NativeReadOptions var2);

        @JniMethod(cast="leveldb::Snapshot *", flags={MethodFlag.CPP_METHOD})
        static final native long GetSnapshot(long var0);

        @JniMethod(flags={MethodFlag.CPP_METHOD})
        static final native void ReleaseSnapshot(long var0, @JniArg(cast="const leveldb::Snapshot *") long var2);

        @JniMethod(flags={MethodFlag.CPP_METHOD})
        static final native void GetApproximateSizes(long var0, @JniArg(cast="const leveldb::Range *") long var2, int var4, @JniArg(cast="uint64_t*") long[] var5);

        @JniMethod(flags={MethodFlag.CPP_METHOD})
        static final native boolean GetProperty(long var0, @JniArg(flags={ArgFlag.BY_VALUE, ArgFlag.NO_OUT}) NativeSlice var2, @JniArg(cast="std::string *") long var3);

        @JniMethod(copy="leveldb::Status", accessor="leveldb::DestroyDB")
        static final native long DestroyDB(@JniArg(cast="const char*") String var0, @JniArg(flags={ArgFlag.BY_VALUE, ArgFlag.NO_OUT}) NativeOptions var1);

        @JniMethod(copy="leveldb::Status", accessor="leveldb::RepairDB")
        static final native long RepairDB(@JniArg(cast="const char*") String var0, @JniArg(flags={ArgFlag.BY_VALUE, ArgFlag.NO_OUT}) NativeOptions var1);

        @JniMethod(flags={MethodFlag.CPP_METHOD})
        static final native void CompactRange(long var0, @JniArg(flags={ArgFlag.NO_OUT}) NativeSlice var2, @JniArg(flags={ArgFlag.NO_OUT}) NativeSlice var3);

        @JniMethod(flags={MethodFlag.CPP_METHOD})
        static final native void SuspendCompactions(long var0);

        @JniMethod(flags={MethodFlag.CPP_METHOD})
        static final native void ResumeCompactions(long var0);

        static {
            LIBRARY.load();
        }
    }
}

