/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mortbay.util.LazyList;

public class MultiMap
extends HashMap
implements Cloneable {
    public MultiMap() {
    }

    public MultiMap(int size2) {
        super(size2);
    }

    public MultiMap(Map map) {
        super(map.size() * 3 / 2);
        this.putAll(map);
    }

    public List getValues(Object name) {
        return LazyList.getList(super.get(name), true);
    }

    public Object getValue(Object name, int i) {
        Object l = super.get(name);
        if (i == 0 && LazyList.size(l) == 0) {
            return null;
        }
        return LazyList.get(l, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(Object name) {
        StringBuffer values;
        Object l = super.get(name);
        switch (LazyList.size(l)) {
            case 0: {
                return null;
            }
            case 1: {
                Object o = LazyList.get(l, 0);
                return o == null ? null : o.toString();
            }
        }
        StringBuffer stringBuffer = values = new StringBuffer(128);
        synchronized (stringBuffer) {
            for (int i = 0; i < LazyList.size(l); ++i) {
                Object e = LazyList.get(l, i);
                if (e == null) continue;
                if (values.length() > 0) {
                    values.append(',');
                }
                values.append(e.toString());
            }
            return values.toString();
        }
    }

    public Object get(Object name) {
        Object l = super.get(name);
        switch (LazyList.size(l)) {
            case 0: {
                return null;
            }
            case 1: {
                Object o = LazyList.get(l, 0);
                return o;
            }
        }
        return LazyList.getList(l, true);
    }

    public Object put(Object name, Object value2) {
        return super.put(name, LazyList.add(null, value2));
    }

    public Object putValues(Object name, List values) {
        return super.put(name, values);
    }

    public Object putValues(Object name, String[] values) {
        Object list2 = null;
        for (int i = 0; i < values.length; ++i) {
            list2 = LazyList.add(list2, values[i]);
        }
        return this.put(name, list2);
    }

    public void add(Object name, Object value2) {
        Object ln;
        Object lo = super.get(name);
        if (lo != (ln = LazyList.add(lo, value2))) {
            super.put(name, ln);
        }
    }

    public void addValues(Object name, List values) {
        Object ln;
        Object lo = super.get(name);
        if (lo != (ln = LazyList.addCollection(lo, values))) {
            super.put(name, ln);
        }
    }

    public void addValues(Object name, String[] values) {
        Object ln;
        Object lo = super.get(name);
        if (lo != (ln = LazyList.addCollection(lo, Arrays.asList(values)))) {
            super.put(name, ln);
        }
    }

    public boolean removeValue(Object name, Object value2) {
        Object lo;
        Object ln = lo = super.get(name);
        int s = LazyList.size(lo);
        if (s > 0) {
            ln = LazyList.remove(lo, value2);
            if (ln == null) {
                super.remove(name);
            } else {
                super.put(name, ln);
            }
        }
        return LazyList.size(ln) != s;
    }

    public void putAll(Map m) {
        Iterator i = m.entrySet().iterator();
        boolean multi = m instanceof MultiMap;
        while (i.hasNext()) {
            Map.Entry entry2 = i.next();
            if (multi) {
                super.put(entry2.getKey(), LazyList.clone(entry2.getValue()));
                continue;
            }
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    public Map toStringArrayMap() {
        HashMap map = new HashMap(this.size() * 3 / 2);
        Iterator i = super.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry2 = i.next();
            Object l = entry2.getValue();
            String[] a = LazyList.toStringArray(l);
            map.put(entry2.getKey(), a);
        }
        return map;
    }

    public Object clone() {
        MultiMap mm = (MultiMap)super.clone();
        Iterator iter = mm.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry2 = iter.next();
            entry2.setValue(LazyList.clone(entry2.getValue()));
        }
        return mm;
    }
}

