/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.launcher.YarnCommandBuilderUtils$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005me!B\u0001\u0003\u0001\ta!\u0001E#yK\u000e,Ho\u001c:Sk:t\u0017M\u00197f\u0015\t\u0019A!\u0001\u0003zCJt'BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001eD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\nG>tG/Y5oKJ\u001c\u0001\u0001\u0005\u0002\u001eK5\taD\u0003\u0002 A\u00059!/Z2pe\u0012\u001c(BA\u0011#\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\rR!\u0001\n\u0005\u0002\r!\fGm\\8q\u0013\t1cDA\u0005D_:$\u0018-\u001b8fe\"A\u0001\u0006\u0001B\u0001B\u0003%\u0011&\u0001\u0003d_:4\u0007C\u0001\u0016-\u001b\u0005Y#B\u0001\u0015$\u0013\ti3FA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005I1\u000f]1sW\u000e{gN\u001a\t\u0003cIj\u0011AB\u0005\u0003g\u0019\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011U\u0002!\u0011!Q\u0001\nY\nQ\"\\1ti\u0016\u0014\u0018\t\u001a3sKN\u001c\bCA\u001c;\u001d\tq\u0001(\u0003\u0002:\u001f\u00051\u0001K]3eK\u001aL!a\u000f\u001f\u0003\rM#(/\u001b8h\u0015\tIt\u0002\u0003\u0005?\u0001\t\u0005\t\u0015!\u00037\u0003\u001d\u0019H.\u0019<f\u0013\u0012D\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006IAN\u0001\tQ>\u001cHO\\1nK\"A!\t\u0001B\u0001B\u0003%1)\u0001\bfq\u0016\u001cW\u000f^8s\u001b\u0016lwN]=\u0011\u00059!\u0015BA#\u0010\u0005\rIe\u000e\u001e\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0007\u0006iQ\r_3dkR|'oQ8sKND\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IAN\u0001\u0006CB\u0004\u0018\n\u001a\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\u0006Y1/Z2ve&$\u00180T4s!\t\tT*\u0003\u0002O\r\ty1+Z2ve&$\u00180T1oC\u001e,'\u000f\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u00039awnY1m%\u0016\u001cx.\u001e:dKN\u0004Ba\u000e*7)&\u00111\u000b\u0010\u0002\u0004\u001b\u0006\u0004\bCA\u000fV\u0013\t1fDA\u0007M_\u000e\fGNU3t_V\u00148-\u001a\u0005\u00061\u0002!\t!W\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019icVLX0aC\n\u001cG-\u001a4\u0011\u0005m\u0003Q\"\u0001\u0002\t\u000bi9\u0006\u0019\u0001\u000f\t\u000b!:\u0006\u0019A\u0015\t\u000b=:\u0006\u0019\u0001\u0019\t\u000bU:\u0006\u0019\u0001\u001c\t\u000by:\u0006\u0019\u0001\u001c\t\u000b\u0001;\u0006\u0019\u0001\u001c\t\u000b\t;\u0006\u0019A\"\t\u000b\u001d;\u0006\u0019A\"\t\u000b%;\u0006\u0019\u0001\u001c\t\u000b-;\u0006\u0019\u0001'\t\u000bA;\u0006\u0019A)\t\u000f!\u0004\u0001\u0019!C\u0001S\u0006\u0019!\u000f]2\u0016\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c\u0012\u0002\u0007%\u00048-\u0003\u0002pY\n9\u0011,\u0019:o%B\u001b\u0005bB9\u0001\u0001\u0004%\tA]\u0001\beB\u001cw\fJ3r)\t\u0019h\u000f\u0005\u0002\u000fi&\u0011Qo\u0004\u0002\u0005+:LG\u000fC\u0004xa\u0006\u0005\t\u0019\u00016\u0002\u0007a$\u0013\u0007\u0003\u0004z\u0001\u0001\u0006KA[\u0001\u0005eB\u001c\u0007\u0005C\u0005|\u0001\u0001\u0007\t\u0019!C\u0001y\u0006Aa.\\\"mS\u0016tG/F\u0001~!\rq\u0018QA\u0007\u0002\u007f*\u0019\u0011%!\u0001\u000b\u0007\u0005\r!%\u0001\u0004dY&,g\u000e^\u0005\u0004\u0003\u000fy(\u0001\u0003(N\u00072LWM\u001c;\t\u0017\u0005-\u0001\u00011AA\u0002\u0013\u0005\u0011QB\u0001\r]6\u001cE.[3oi~#S-\u001d\u000b\u0004g\u0006=\u0001\u0002C<\u0002\n\u0005\u0005\t\u0019A?\t\u000f\u0005M\u0001\u0001)Q\u0005{\u0006Ia.\\\"mS\u0016tG\u000f\t\u0005\n\u0003/\u0001!\u0019!C\u0001\u00033\t\u0001\"_1s]\u000e{gNZ\u000b\u0003\u00037\u0001B!!\b\u0002\"5\u0011\u0011q\u0004\u0006\u0003Q\tJA!a\t\u0002 \t\t\u0012,\u0019:o\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u00037\t\u0011\"_1s]\u000e{gN\u001a\u0011\t\u0015\u0005-\u0002\u0001#b\u0001\n\u0003\ti#A\u0002f]Z,\"!a\f\u0011\r\u0005E\u00121\b\u001c7\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003sy\u0011AC2pY2,7\r^5p]&!\u0011QHA\u001a\u0005\u001dA\u0015m\u001d5NCBD!\"!\u0011\u0001\u0011\u0003\u0005\u000b\u0015BA\u0018\u0003\u0011)gN\u001e\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u0005\u0019!/\u001e8\u0015\u0003MDq!a\u0013\u0001\t\u0003\ti%\u0001\bti\u0006\u0014HoQ8oi\u0006Lg.\u001a:\u0015\u0005\u0005=\u0003cBA)\u000372\u0014QL\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005!Q\u000f^5m\u0015\t\tI&\u0001\u0003kCZ\f\u0017bA*\u0002TA!\u0011qLA3\u001b\t\t\tG\u0003\u0003\u0002d\u0005]\u0013a\u00018j_&!\u0011qMA1\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0003W\u0002A\u0011BA7\u00039\u0001(/\u001a9be\u0016\u001cu.\\7b]\u0012$b\"a\u001c\u0002\b\u0006%\u00151RAG\u0003\u001f\u000b\t\nE\u0003\u0002r\u0005\u0005eG\u0004\u0003\u0002t\u0005ud\u0002BA;\u0003wj!!a\u001e\u000b\u0007\u0005e4$\u0001\u0004=e>|GOP\u0005\u0002!%\u0019\u0011qP\b\u0002\u000fA\f7m[1hK&!\u00111QAC\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005}t\u0002\u0003\u00046\u0003S\u0002\rA\u000e\u0005\u0007}\u0005%\u0004\u0019\u0001\u001c\t\r\u0001\u000bI\u00071\u00017\u0011\u0019\u0011\u0015\u0011\u000ea\u0001\u0007\"1q)!\u001bA\u0002\rCa!SA5\u0001\u00041\u0004bBAK\u0001\u0011%\u0011qS\u0001\u0013aJ,\u0007/\u0019:f\u000b:4\u0018N]8o[\u0016tG\u000f\u0006\u0003\u00020\u0005e\u0005B\u0002\u000e\u0002\u0014\u0002\u0007A\u0004")
public class ExecutorRunnable
implements Logging {
    private final Container container;
    public final SparkConf org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf;
    private final String masterAddress;
    private final String slaveId;
    private final String hostname;
    private final int executorMemory;
    private final int executorCores;
    private final String appId;
    private final SecurityManager securityMgr;
    private final scala.collection.immutable.Map<String, LocalResource> localResources;
    private YarnRPC rpc;
    private NMClient nmClient;
    private final YarnConfiguration yarnConf;
    private HashMap<String, String> env;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    private HashMap env$lzycompute() {
        ExecutorRunnable executorRunnable = this;
        synchronized (executorRunnable) {
            if (!this.bitmap$0) {
                this.env = this.prepareEnvironment(this.container);
                this.bitmap$0 = true;
            }
            return this.env;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    public NMClient nmClient() {
        return this.nmClient;
    }

    public void nmClient_$eq(NMClient x$1) {
        this.nmClient = x$1;
    }

    public YarnConfiguration yarnConf() {
        return this.yarnConf;
    }

    public HashMap<String, String> env() {
        return this.bitmap$0 ? this.env : this.env$lzycompute();
    }

    public void run() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting Executor Container";
            }
        });
        this.nmClient_$eq(NMClient.createNMClient());
        this.nmClient().init((Configuration)this.yarnConf());
        this.nmClient().start();
        this.startContainer();
    }

    public Map<String, ByteBuffer> startContainer() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up ContainerLaunchContext";
            }
        });
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        ctx.setLocalResources((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.localResources).asJava());
        ctx.setEnvironment((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(this.env()).asJava());
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ctx.setTokens(ByteBuffer.wrap(dob.getData()));
        List<String> commands = this.prepareCommand(this.masterAddress, this.slaveId, this.hostname, this.executorMemory, this.executorCores, this.appId);
        this.logInfo((Function0<String>)new Serializable(this, commands){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorRunnable $outer;
            private final List commands$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |===============================================================================\n      |YARN executor launch context:\n      |  env:\n      |", "\n      |  command:\n      |    ", "\n      |===============================================================================\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.$outer.env().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    ", " -> ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                            return string;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString(), this.commands$1.mkString(" ")})))).stripMargin();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commands$1 = commands$1;
            }
        });
        ctx.setCommands((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(commands).asJava());
        ctx.setApplicationACLs((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(YarnSparkHadoopUtil$.MODULE$.getApplicationAclsForYarn(this.securityMgr)).asJava());
        if (BoxesRunTime.unboxToBoolean((Object)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) {
            String secretString = this.securityMgr.getSecretKey();
            ByteBuffer secretBytes = secretString == null ? ByteBuffer.allocate(0) : JavaUtils.stringToBytes((String)secretString);
            ctx.setServiceData(Collections.singletonMap("spark_shuffle", secretBytes));
        }
        try {
            return this.nmClient().startContainer(this.container, ctx);
        }
        catch (Exception exception) {
            throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while starting container ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.container.getId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" on host ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname}))).toString(), (Throwable)exception);
        }
    }

    private List<String> prepareCommand(String masterAddress, String slaveId, String hostname, int executorMemory, int executorCores, String appId) {
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef prefixEnv = ObjectRef.create((Object)None$.MODULE$);
        String executorMemoryString = new StringBuilder().append(executorMemory).append((Object)"m").toString();
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Xmx").append((Object)executorMemoryString).toString());
        ((Option)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(String opts) {
                return this.javaOpts$1.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(opts).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String arg) {
                        return YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        scala.sys.package$.MODULE$.env().get((Object)"SPARK_JAVA_OPTS").foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(String opts) {
                return this.javaOpts$1.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(opts).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String arg) {
                        return YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        ((Option)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_LIBRARY_PATH())).foreach((Function1)new Serializable(this, prefixEnv){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorRunnable $outer;
            private final ObjectRef prefixEnv$1;

            public final void apply(String p) {
                this.prefixEnv$1.elem = new Some((Object)Client$.MODULE$.getClusterPath(this.$outer.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf, Utils$.MODULE$.libraryPathEnvPrefix((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{p})))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.prefixEnv$1 = prefixEnv$1;
            }
        });
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Djava.io.tmpdir=").append((Object)new Path(YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), "./tmp")).toString());
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.getAll()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    boolean bl = SparkConf$.MODULE$.isExecutorStartupConf(k);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ListBuffer listBuffer = this.javaOpts$1.$plus$eq((Object)YarnSparkHadoopUtil$.MODULE$.escapeForShell(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}))));
                    return listBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        javaOpts.$plus$eq((Object)"-Dspark.yarn.app.container.log.dir=<LOG_DIR>");
        YarnCommandBuilderUtils$.MODULE$.addPermGenSizeOpt((ListBuffer<String>)javaOpts);
        Seq userClassPath = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Client$.MODULE$.getUserClasspath(this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf)).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorRunnable $outer;

            public final Seq<String> apply(URI uri) {
                String absPath = new File(uri.getPath()).isAbsolute() ? Client$.MODULE$.getClusterPath(this.$outer.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf, uri.getPath()) : Client$.MODULE$.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$(), uri.getPath()}));
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--user-class-path", new StringBuilder().append((Object)"file:").append((Object)absPath).toString()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSeq();
        YarnSparkHadoopUtil$.MODULE$.addOutOfMemoryErrorArgument((ListBuffer<String>)javaOpts);
        Iterable commands = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable((Option)prefixEnv.elem).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.JAVA_HOME)).append((Object)"/bin/java").toString(), "-server"})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)javaOpts, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.executor.CoarseGrainedExecutorBackend", "--driver-url", masterAddress.toString(), "--executor-id", slaveId.toString(), "--hostname", hostname.toString(), "--cores", ((Object)BoxesRunTime.boxToInteger((int)executorCores)).toString(), "--app-id", appId})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)userClassPath, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1>", "<LOG_DIR>/stdout", "2>", "<LOG_DIR>/stderr"})), scala.collection.Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)commands.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return s == null ? "null" : s;
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList();
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> prepareEnvironment(Container container) {
        void var2_2;
        String yarnHttpPolicy;
        HashMap env = new HashMap();
        Client$.MODULE$.populateClasspath(null, (Configuration)this.yarnConf(), this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf, (HashMap<String, String>)env, (Option<String>)((Option)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_CLASS_PATH())));
        this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.getExecutorEnv().foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$1, key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        scala.sys.package$.MODULE$.env().get((Object)"SPARK_YARN_USER_ENV").foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(String userEnvs) {
                YarnSparkHadoopUtil$.MODULE$.setEnvFromInputString((HashMap<String, String>)this.env$1, userEnvs);
            }
            {
                this.env$1 = env$1;
            }
        });
        String string = yarnHttpPolicy = this.yarnConf().get("yarn.http.policy", YarnConfiguration.YARN_HTTP_POLICY_DEFAULT);
        String string2 = "HTTPS_ONLY";
        String httpScheme = !(string != null ? !string.equals(string2) : string2 != null) ? "https://" : "http://";
        scala.sys.package$.MODULE$.env().get((Object)"SPARK_USER").foreach((Function1)new Serializable(this, container, env, httpScheme){
            public static final long serialVersionUID = 0L;
            private final Container container$1;
            private final HashMap env$1;
            private final String httpScheme$1;

            public final void apply(String user) {
                String containerId = ConverterUtils.toString((ContainerId)this.container$1.getId());
                String address = this.container$1.getNodeHttpAddress();
                String baseUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "/node/containerlogs/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.httpScheme$1, address, containerId, user}));
                this.env$1.update((Object)"SPARK_LOG_URL_STDERR", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/stderr?start=-4096"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
                this.env$1.update((Object)"SPARK_LOG_URL_STDOUT", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/stdout?start=-4096"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
            }
            {
                this.container$1 = container$1;
                this.env$1 = env$1;
                this.httpScheme$1 = httpScheme$1;
            }
        });
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(System.getenv()).asScala()).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.startsWith("SPARK");
            }
        }).foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$5) {
                Tuple2<String, String> tuple2 = x0$5;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    this.env$1.update((Object)k, (Object)v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        return var2_2;
    }

    public ExecutorRunnable(Container container, Configuration conf, SparkConf sparkConf, String masterAddress, String slaveId, String hostname, int executorMemory, int executorCores, String appId, SecurityManager securityMgr, scala.collection.immutable.Map<String, LocalResource> localResources) {
        this.container = container;
        this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf = sparkConf;
        this.masterAddress = masterAddress;
        this.slaveId = slaveId;
        this.hostname = hostname;
        this.executorMemory = executorMemory;
        this.executorCores = executorCores;
        this.appId = appId;
        this.securityMgr = securityMgr;
        this.localResources = localResources;
        Logging.class.$init$((Logging)this);
        this.rpc = YarnRPC.create((Configuration)conf);
        this.yarnConf = new YarnConfiguration(conf);
    }
}

