/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.io.SplittableBufferedWriter;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.manager.PostgresqlManager;
import com.cloudera.sqoop.util.DirectImportUtils;
import com.cloudera.sqoop.util.ErrorableAsyncSink;
import com.cloudera.sqoop.util.ErrorableThread;
import com.cloudera.sqoop.util.Executor;
import com.cloudera.sqoop.util.ImportException;
import com.cloudera.sqoop.util.JdbcUrl;
import com.cloudera.sqoop.util.LoggingAsyncSink;
import com.cloudera.sqoop.util.PerfCounters;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.util.AsyncSink;

public class DirectPostgresqlManager
extends PostgresqlManager {
    public static final Log LOG = LogFactory.getLog((String)DirectPostgresqlManager.class.getName());
    private static final String PSQL_CMD = "psql";

    public DirectPostgresqlManager(SqoopOptions opts) {
        super(opts, true);
    }

    private String getColumnListStr(String[] cols) {
        if (null == cols) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String col : cols) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(col);
            first = false;
        }
        return sb.toString();
    }

    private String getSelectListColumnsStr(String[] cols, String tableName) {
        if (null == cols || tableName == null) {
            return null;
        }
        Map<String, String> columnTypes = this.getColumnTypeNamesForTable(tableName);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String col : cols) {
            if (!first) {
                sb.append(", ");
            }
            if (columnTypes.get(col) == null) {
                LOG.error((Object)("can not find " + col + " in type medatadata"));
                sb.append(col);
            } else if ("bool".equalsIgnoreCase(columnTypes.get(col))) {
                sb.append(String.format("case when %s=true then 'TRUE' when %s=false then 'FALSE' end as %s", col, col, col));
            } else if ("bit".equalsIgnoreCase(columnTypes.get(col))) {
                sb.append(String.format("case when %s=B'1' then 'TRUE' when %s=B'0' then 'FALSE' end as %s", col, col, col));
            } else {
                sb.append(col);
            }
            first = false;
        }
        return sb.toString();
    }

    private String getCopyCommand(String tableName) {
        StringBuilder sb = new StringBuilder();
        String[] cols = this.getColumnNames(tableName);
        String escapedTableName = this.escapeTableName(tableName);
        sb.append("COPY ");
        String whereClause = this.options.getWhereClause();
        if (whereClause == null || whereClause.isEmpty()) {
            whereClause = "1=1";
        }
        sb.append("(");
        sb.append("SELECT ");
        if (null != cols) {
            sb.append(this.getSelectListColumnsStr(cols, tableName));
        } else {
            sb.append("*");
        }
        sb.append(" FROM ");
        sb.append(escapedTableName);
        sb.append(" WHERE ");
        sb.append(whereClause);
        sb.append(")");
        sb.append(" TO STDOUT WITH DELIMITER E'\\");
        sb.append(Integer.toString(this.options.getOutputFieldDelim(), 8));
        sb.append("' CSV ");
        if (this.options.getOutputEnclosedBy() != '\u0000') {
            sb.append("QUOTE E'\\");
            sb.append(Integer.toString(this.options.getOutputEnclosedBy(), 8));
            sb.append("' ");
        }
        if (this.options.getOutputEscapedBy() != '\u0000') {
            sb.append("ESCAPE E'\\");
            sb.append(Integer.toString(this.options.getOutputEscapedBy(), 8));
            sb.append("' ");
        }
        if (null != cols && this.options.isOutputEncloseRequired()) {
            sb.append("FORCE QUOTE ");
            sb.append(this.getColumnListStr(cols));
        }
        sb.append(";");
        String copyCmd = sb.toString();
        LOG.debug((Object)("Copy command is " + copyCmd));
        return copyCmd;
    }

    private String writeCopyCommand(String command) throws IOException {
        String tmpDir = this.options.getTempDir();
        File tempFile = File.createTempFile("tmp-", ".sql", new File(tmpDir));
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tempFile)));
        w.write(command);
        w.newLine();
        w.close();
        return tempFile.toString();
    }

    private String writePasswordFile(String password) throws IOException {
        String tmpDir = this.options.getTempDir();
        File tempFile = File.createTempFile("pgpass", ".pgpass", new File(tmpDir));
        LOG.debug((Object)("Writing password to tempfile: " + tempFile));
        DirectImportUtils.setFilePermissions(tempFile, "0600");
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tempFile)));
        w.write("*:*:*:*:" + password);
        w.close();
        return tempFile.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        String tableName = context.getTableName();
        SqoopOptions options = context.getOptions();
        LOG.info((Object)"Beginning psql fast path import");
        if (options.getFileLayout() != SqoopOptions.FileLayout.TextFile) {
            LOG.warn((Object)("File import layout" + (Object)((Object)options.getFileLayout()) + " is not supported by"));
            LOG.warn((Object)"Postgresql direct import; import will proceed as text files.");
        }
        String commandFilename = null;
        String passwordFilename = null;
        Process p = null;
        AsyncSink sink = null;
        AsyncSink errSink = null;
        PerfCounters counters = new PerfCounters();
        try {
            String copyCmd = this.getCopyCommand(tableName);
            commandFilename = this.writeCopyCommand(copyCmd);
            ArrayList<String> args = new ArrayList<String>();
            List<String> envp = Executor.getCurEnvpStrings();
            String connectString = options.getConnectString();
            String databaseName = JdbcUrl.getDatabaseName(connectString);
            String hostname = JdbcUrl.getHostName(connectString);
            int port = JdbcUrl.getPort(connectString);
            if (null == databaseName) {
                throw new ImportException("Could not determine database name");
            }
            LOG.info((Object)("Performing import of table " + tableName + " from database " + databaseName));
            args.add(PSQL_CMD);
            args.add("--tuples-only");
            args.add("--quiet");
            String username = options.getUsername();
            if (username != null) {
                args.add("--username");
                args.add(username);
                String password = options.getPassword();
                if (null != password) {
                    passwordFilename = this.writePasswordFile(password);
                    envp.add("PGPASSFILE=" + passwordFilename);
                }
            }
            args.add("--host");
            args.add(hostname);
            if (port != -1) {
                args.add("--port");
                args.add(Integer.toString(port));
            }
            if (null != databaseName && databaseName.length() > 0) {
                args.add(databaseName);
            }
            args.add("-f");
            args.add(commandFilename);
            LOG.debug((Object)"Starting psql with arguments:");
            for (String arg : args) {
                LOG.debug((Object)("  " + arg));
            }
            SplittableBufferedWriter w = DirectImportUtils.createHdfsSink(options.getConf(), options, context);
            p = Runtime.getRuntime().exec(args.toArray(new String[0]), envp.toArray(new String[0]));
            InputStream is = p.getInputStream();
            sink = new PostgresqlAsyncSink(w, options, counters);
            LOG.debug((Object)"Starting stream sink");
            counters.startClock();
            sink.processStream(is);
            errSink = new LoggingAsyncSink(LOG);
            errSink.processStream(p.getErrorStream());
        }
        catch (Throwable throwable) {
            LOG.debug((Object)"Waiting for process completion");
            int result = 0;
            if (null != p) {
                while (true) {
                    try {
                        result = p.waitFor();
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            if (null != passwordFilename && !new File(passwordFilename).delete()) {
                LOG.error((Object)("Could not remove postgresql password file " + passwordFilename));
                LOG.error((Object)"You should remove this file to protect your credentials.");
            }
            if (null != commandFilename && !new File(commandFilename).delete()) {
                LOG.info((Object)("Could not remove temp file: " + commandFilename));
            }
            int streamResult = 0;
            if (null != sink) {
                while (true) {
                    try {
                        streamResult = sink.join();
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            if (null != errSink) {
                try {
                    if (0 != errSink.join()) {
                        LOG.info((Object)"Encountered exception reading stderr stream");
                    }
                }
                catch (InterruptedException ie) {
                    LOG.info((Object)("Thread interrupted waiting for stderr to complete: " + ie.toString()));
                }
            }
            LOG.info((Object)"Transfer loop complete.");
            if (0 != result) {
                throw new IOException("psql terminated with status " + Integer.toString(result));
            }
            if (0 != streamResult) {
                throw new IOException("Encountered exception in stream sink");
            }
            counters.stopClock();
            LOG.info((Object)("Transferred " + counters.toString()));
            throw throwable;
        }
        LOG.debug((Object)"Waiting for process completion");
        int result = 0;
        if (null != p) {
            while (true) {
                try {
                    result = p.waitFor();
                }
                catch (InterruptedException ie) {
                    continue;
                }
                break;
            }
        }
        if (null != passwordFilename && !new File(passwordFilename).delete()) {
            LOG.error((Object)("Could not remove postgresql password file " + passwordFilename));
            LOG.error((Object)"You should remove this file to protect your credentials.");
        }
        if (null != commandFilename && !new File(commandFilename).delete()) {
            LOG.info((Object)("Could not remove temp file: " + commandFilename));
        }
        int streamResult = 0;
        if (null != sink) {
            while (true) {
                try {
                    streamResult = sink.join();
                }
                catch (InterruptedException ie) {
                    continue;
                }
                break;
            }
        }
        if (null != errSink) {
            try {
                if (0 != errSink.join()) {
                    LOG.info((Object)"Encountered exception reading stderr stream");
                }
            }
            catch (InterruptedException ie) {
                LOG.info((Object)("Thread interrupted waiting for stderr to complete: " + ie.toString()));
            }
        }
        LOG.info((Object)"Transfer loop complete.");
        if (0 != result) {
            throw new IOException("psql terminated with status " + Integer.toString(result));
        }
        if (0 != streamResult) {
            throw new IOException("Encountered exception in stream sink");
        }
        counters.stopClock();
        LOG.info((Object)("Transferred " + counters.toString()));
    }

    @Override
    public boolean supportsStagingForExport() {
        return false;
    }

    static class PostgresqlAsyncSink
    extends ErrorableAsyncSink {
        private final SplittableBufferedWriter writer;
        private final PerfCounters counters;
        private final SqoopOptions options;

        PostgresqlAsyncSink(SplittableBufferedWriter w, SqoopOptions opts, PerfCounters ctrs) {
            this.writer = w;
            this.options = opts;
            this.counters = ctrs;
        }

        @Override
        public void processStream(InputStream is) {
            this.child = new PostgresqlStreamThread(is, this.writer, this.options, this.counters);
            this.child.start();
        }

        private static class PostgresqlStreamThread
        extends ErrorableThread {
            public static final Log LOG = LogFactory.getLog((String)PostgresqlStreamThread.class.getName());
            private final SplittableBufferedWriter writer;
            private final InputStream stream;
            private final SqoopOptions options;
            private final PerfCounters counters;

            PostgresqlStreamThread(InputStream is, SplittableBufferedWriter w, SqoopOptions opts, PerfCounters ctrs) {
                this.stream = is;
                this.writer = w;
                this.options = opts;
                this.counters = ctrs;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader r = null;
                SplittableBufferedWriter w = this.writer;
                char recordDelim = this.options.getOutputRecordDelim();
                try {
                    String inLine;
                    r = new BufferedReader(new InputStreamReader(this.stream));
                    while (null != (inLine = r.readLine())) {
                        w.write(inLine);
                        w.write(recordDelim);
                        w.allowSplit();
                        this.counters.addBytes(1 + inLine.length());
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)("IOException reading from psql: " + ioe.toString()));
                    this.setError();
                }
                finally {
                    if (null != r) {
                        try {
                            r.close();
                        }
                        catch (IOException ioe) {
                            LOG.info((Object)("Error closing FIFO stream: " + ioe.toString()));
                        }
                    }
                    if (null != w) {
                        try {
                            w.close();
                        }
                        catch (IOException ioe) {
                            LOG.info((Object)("Error closing HDFS stream: " + ioe.toString()));
                        }
                    }
                }
            }
        }
    }
}

