/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClassLoaderStack {
    public static final Log LOG = LogFactory.getLog((String)ClassLoaderStack.class.getName());

    private ClassLoaderStack() {
    }

    public static void setCurrentClassLoader(ClassLoader cl) {
        LOG.debug((Object)("Restoring classloader: " + cl.toString()));
        Thread.currentThread().setContextClassLoader(cl);
    }

    public static ClassLoader addJarFile(String jarFile, String testClassName) throws IOException {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        if (null != testClassName) {
            try {
                LOG.debug((Object)("Checking for existing class: " + testClassName));
                Class.forName(testClassName, true, prevClassLoader);
                LOG.debug((Object)("Class is already available. Skipping jar " + jarFile));
                return prevClassLoader;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        String urlPath = "jar:file://" + new File(jarFile).getAbsolutePath() + "!/";
        LOG.debug((Object)("Attempting to load jar through URL: " + urlPath));
        LOG.debug((Object)("Previous classloader is " + prevClassLoader));
        URL[] jarUrlArray = new URL[]{new URL(urlPath)};
        URLClassLoader cl = URLClassLoader.newInstance(jarUrlArray, prevClassLoader);
        try {
            if (null != testClassName) {
                LOG.debug((Object)("Testing class in jar: " + testClassName));
                Class.forName(testClassName, true, cl);
            }
            LOG.debug((Object)("Loaded jar into current JVM: " + urlPath));
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Could not load jar " + jarFile + " into JVM. (Could not find class " + testClassName + ".)", cnfe);
        }
        LOG.debug((Object)("Added classloader for jar " + jarFile + ": " + cl));
        Thread.currentThread().setContextClassLoader(cl);
        return prevClassLoader;
    }
}

