/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;

public class ResultSetPrinter {
    public static final Log LOG = LogFactory.getLog((String)ResultSetPrinter.class.getName());
    private static final int MAX_COL_WIDTH = 20;
    private static final String COL_SEPARATOR = " | ";
    private static final String LEFT_BORDER = "| ";

    private static void printPadded(StringBuilder sb, String str, int width) {
        int numPad;
        if (null == str) {
            sb.append("(null)");
            numPad = width - "(null)".length();
        } else {
            sb.append(str);
            numPad = width - str.length();
        }
        for (int i = 0; i < numPad; ++i) {
            sb.append(' ');
        }
    }

    public final void printResultSet(PrintWriter pw, ResultSet results) throws IOException {
        try {
            StringBuilder sbNames = new StringBuilder();
            int cols = results.getMetaData().getColumnCount();
            int[] colWidths = new int[cols];
            ResultSetMetaData metadata = results.getMetaData();
            sbNames.append(LEFT_BORDER);
            for (int i = 1; i < cols + 1; ++i) {
                String colName = metadata.getColumnName(i);
                colWidths[i - 1] = Math.min(metadata.getColumnDisplaySize(i), 20);
                if (colName == null || colName.equals("")) {
                    colName = metadata.getColumnLabel(i) + "*";
                }
                ResultSetPrinter.printPadded(sbNames, colName, colWidths[i - 1]);
                sbNames.append(COL_SEPARATOR);
            }
            sbNames.append('\n');
            StringBuilder sbPad = new StringBuilder();
            for (int i = 0; i < cols; ++i) {
                for (int j = 0; j < COL_SEPARATOR.length() + colWidths[i]; ++j) {
                    sbPad.append('-');
                }
            }
            sbPad.append('-');
            sbPad.append('\n');
            pw.print(sbPad.toString());
            pw.print(sbNames.toString());
            pw.print(sbPad.toString());
            while (results.next()) {
                StringBuilder sb = new StringBuilder();
                sb.append(LEFT_BORDER);
                for (int i = 1; i < cols + 1; ++i) {
                    ResultSetPrinter.printPadded(sb, results.getString(i), colWidths[i - 1]);
                    sb.append(COL_SEPARATOR);
                }
                sb.append('\n');
                pw.print(sb.toString());
            }
            pw.print(sbPad.toString());
        }
        catch (SQLException sqlException) {
            LOG.error((Object)("Error reading from database: " + StringUtils.stringifyException((Throwable)sqlException)));
        }
    }
}

