/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class AvroRecordReader<T>
extends RecordReader<AvroWrapper<T>, NullWritable> {
    private FileReader<T> reader;
    private long start;
    private long end;
    private AvroWrapper<T> key;
    private NullWritable value;

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit split = (FileSplit)genericSplit;
        Configuration conf = context.getConfiguration();
        FsInput in = new FsInput(split.getPath(), conf);
        GenericDatumReader datumReader = new GenericDatumReader();
        this.reader = DataFileReader.openReader((SeekableInput)in, (DatumReader)datumReader);
        this.reader.sync(split.getStart());
        this.start = this.reader.tell();
        this.end = split.getStart() + split.getLength();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.reader.hasNext() || this.reader.pastSync(this.end)) {
            this.key = null;
            this.value = null;
            return false;
        }
        if (this.key == null) {
            this.key = new AvroWrapper();
        }
        if (this.value == null) {
            this.value = NullWritable.get();
        }
        this.key.datum(this.reader.next(this.key.datum()));
        return true;
    }

    public AvroWrapper<T> getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public NullWritable getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.end - this.start));
    }

    public long getPos() throws IOException {
        return this.reader.tell();
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

