/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.hcat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.mapreduce.HCatInputFormat;
import org.apache.sqoop.mapreduce.ExportInputFormat;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatInputSplit;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatRecordReader;

public class SqoopHCatExportFormat
extends HCatInputFormat {
    public static final Log LOG = LogFactory.getLog((String)SqoopHCatExportFormat.class.getName());

    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        int i;
        List hCatSplits = super.getSplits(job);
        int hCatSplitCount = hCatSplits.size();
        int expectedSplitCount = ExportInputFormat.getNumMapTasks(job);
        if (expectedSplitCount == 0) {
            expectedSplitCount = hCatSplitCount;
        }
        LOG.debug((Object)("Expected split count " + expectedSplitCount));
        LOG.debug((Object)("HCatInputFormat provided split count " + hCatSplitCount));
        Collections.sort(hCatSplits, new Comparator<InputSplit>(){

            @Override
            public int compare(InputSplit is1, InputSplit is2) {
                try {
                    return (int)(is2.getLength() - is1.getLength());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception caught while sorting Input splits " + e));
                    return 0;
                }
            }
        });
        ArrayList<InputSplit> combinedSplits = new ArrayList<InputSplit>();
        if (hCatSplitCount <= expectedSplitCount) {
            for (InputSplit split : hCatSplits) {
                ArrayList<InputSplit> hcSplitList = new ArrayList<InputSplit>();
                hcSplitList.add(split);
                combinedSplits.add(new SqoopHCatInputSplit(hcSplitList));
            }
            return combinedSplits;
        }
        ArrayList combinedSplitList = new ArrayList();
        for (int i2 = 0; i2 < expectedSplitCount; ++i2) {
            combinedSplitList.add(new ArrayList());
        }
        boolean ascendingAssigment = true;
        int lastSet = 0;
        for (i = 0; i < hCatSplitCount; ++i) {
            int splitNum = i % expectedSplitCount;
            int currentSet = i / expectedSplitCount;
            if (currentSet != lastSet) {
                boolean bl = ascendingAssigment = !ascendingAssigment;
            }
            if (ascendingAssigment) {
                ((List)combinedSplitList.get(splitNum)).add(hCatSplits.get(i));
            } else {
                ((List)combinedSplitList.get(expectedSplitCount - 1 - splitNum)).add(hCatSplits.get(i));
            }
            lastSet = currentSet;
        }
        for (i = 0; i < expectedSplitCount; ++i) {
            SqoopHCatInputSplit sqoopSplit = new SqoopHCatInputSplit((List)combinedSplitList.get(i));
            combinedSplits.add(sqoopSplit);
        }
        return combinedSplits;
    }

    public RecordReader<WritableComparable, HCatRecord> createRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        LOG.debug((Object)"Creating a SqoopHCatRecordReader");
        return new SqoopHCatRecordReader(split, taskContext, this);
    }

    public RecordReader<WritableComparable, HCatRecord> createHCatRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        LOG.debug((Object)"Creating a base HCatRecordReader");
        return super.createRecordReader(split, taskContext);
    }
}

