/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.sqlserver;

import com.cloudera.sqoop.lib.SqoopRecord;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.mapreduce.ExportBatchOutputFormat;

public class SqlServerExportBatchOutputFormat<K extends SqoopRecord, V>
extends ExportBatchOutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(SqlServerExportBatchOutputFormat.class);

    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new SqlServerExportBatchRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class SqlServerExportBatchRecordWriter<K extends SqoopRecord, V>
    extends ExportBatchOutputFormat.ExportBatchRecordWriter<K, V> {
        public SqlServerExportBatchRecordWriter(TaskAttemptContext context) throws ClassNotFoundException, SQLException {
            super(context);
        }

        @Override
        protected String getInsertStatement(int numRows) {
            int numSlots;
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO " + this.tableName + " ");
            String tableHints = this.getConf().get("org.apache.sqoop.manager.sqlserver.table.hints");
            if (tableHints != null) {
                LOG.info((Object)("Using table hints: " + tableHints));
                sb.append(" WITH (").append(tableHints).append(") ");
            }
            if (this.columnNames != null) {
                numSlots = this.columnNames.length;
                sb.append("(");
                boolean first = true;
                for (String col : this.columnNames) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(col);
                    first = false;
                }
                sb.append(") ");
            } else {
                numSlots = this.columnCount;
            }
            sb.append("VALUES ");
            sb.append("(");
            for (int i = 0; i < numSlots; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append("?");
            }
            sb.append(")");
            String query = sb.toString();
            LOG.info((Object)("Using query " + query));
            return query;
        }
    }
}

